package pacman3d.labyrinth.leveleditor;

import javax.swing.*;
import pacman3d.labyrinth.*;
import pacman3d.labyrinth.leveleditor.*;
import java.awt.event.*;
import java.awt.*;
import javax.vecmath.*;
import pacman3d.labyrinth.cells.*;

/**
 * <b>Titel:</b>Pacman 3D - Leveleditor<p>
 *
 * <b>Beschreibung:</b><br>
 * Diese Klasse ist eine Subklasse von {@link javax.swing.JPanel JPanel} und
 * kann als solche GUI-Komponente verwendet werden.<br>
 * Diese Subklasse stellt alle dem Leveleditor zur Verfgung stehenden
 * {@link pacman3d.labyrinth.cells.Cell Zellentypen} auf dem Bildschirm dar.
 * Jedem {@link pacman3d.labyrinth.cells.Cell Zellentyp} ist in eigener
 * {@link javax.swing.JTabbedPane Reiter} zugeordnet, in welchen sich weitere
 * GUI-Komponenten befinden, wie z.B. die Darstellung der zugewiesenen Texturen
 * und Farben oder auch evtl. die in einer Zelle gesetzten {@link
 * pacman3d.labyrinth.items.Item Items}.<p>
 *
 * <b>Copyright:</b>	Copyright (c) 2001/02<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             1.0 03/15/2002<br>
 */
public class CellsJPanel extends JPanel implements java.awt.event.ActionListener {
  /**
   * Instanz der Klasse {@link javax.swing.JTabbedPane JTabbedPane}, um die einzelnen
   * Zelltypen in verschiedenen Reitern zu organisieren.
   */
  protected JTabbedPane tabbedPane    = null;

  /**
   * Boolscher Flag, ob beim Zelltyp {@link pacman3d.labyrinth.cells.CellWall CellWall}
   * die Wrfeloberseite texturiert bzw. koloriert werden soll.
   *
   * @see #bottom_side
   * @see #left_side
   * @see #right_side
   * @see #back_side
   * @see #front_side
   * @see pacman3d.labyrinth.cells.CellWall
   */
  protected boolean top_side    = true;

  /**
   * Boolscher Flag, ob beim Zelltyp {@link pacman3d.labyrinth.cells.CellWall CellWall}
   * die Wrfelunterseite texturiert bzw. koloriert werden soll.
   *
   * @see #top_side
   * @see #left_side
   * @see #right_side
   * @see #back_side
   * @see #front_side
   * @see pacman3d.labyrinth.cells.CellWall
   */
  protected boolean bottom_side = true;

  /**
   * Boolscher Flag, ob beim Zelltyp {@link pacman3d.labyrinth.cells.CellWall CellWall}
   * die linke Wrfelseite texturiert bzw. koloriert werden soll.
   *
   * @see #top_side
   * @see #bottom_side
   * @see #right_side
   * @see #back_side
   * @see #front_side
   * @see pacman3d.labyrinth.cells.CellWall
   */
  protected boolean left_side   = true;

  /**
   * Boolscher Flag, ob beim Zelltyp {@link pacman3d.labyrinth.cells.CellWall CellWall}
   * die rechte Wrfelseite texturiert bzw. koloriert werden soll.
   *
   * @see #top_side
   * @see #bottom_side
   * @see #left_side
   * @see #back_side
   * @see #front_side
   * @see pacman3d.labyrinth.cells.CellWall
   */
  protected boolean right_side  = true;

  /**
   * Boolscher Flag, ob beim Zelltyp {@link pacman3d.labyrinth.cells.CellWall CellWall}
   * die hintere Wrfelseite texturiert bzw. koloriert werden soll.
   *
   * @see #top_side
   * @see #bottom_side
   * @see #left_side
   * @see #right_side
   * @see #front_side
   * @see pacman3d.labyrinth.cells.CellWall
   */
  protected boolean back_side   = true;

  /**
   * Boolscher Flag, ob beim Zelltyp {@link pacman3d.labyrinth.cells.CellWall CellWall}
   * die vordere Wrfelseite texturiert bzw. koloriert werden soll.
   *
   * @see #top_side
   * @see #bottom_side
   * @see #left_side
   * @see #right_side
   * @see #back_side
   * @see pacman3d.labyrinth.cells.CellWall
   */
  protected boolean front_side  = true;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Benutzer
   * die Mglichkeit zu geben, auszuwhlen, welche Seite einer Instanz der Klasse
   * {@link pacman3d.labyrinth.cells.CellWall CellWall} texturiert bzw. koloriert
   * werden soll. Ist diese JCheckBox mit einem Hkchen selektiert, so erfolgt
   * eine Texturierung bzw. Kolorierung der linken Seite der entsprechenden
   * {@link pacman3d.labyrinth.cells.CellWall CellWall-Instanz}.
   *
   * @see #rightSideBox
   * @see #frontSideBox
   * @see #backSideBox
   * @see #topSideBox
   * @see #bottomSideBox
   */
  protected JCheckBox leftSideBox;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Benutzer
   * die Mglichkeit zu geben, auszuwhlen, welche Seite einer Instanz der Klasse
   * {@link pacman3d.labyrinth.cells.CellWall CellWall} texturiert bzw. koloriert
   * werden soll. Ist diese JCheckBox mit einem Hkchen selektiert, so erfolgt
   * eine Texturierung bzw. Kolorierung der rechten Seite der entsprechenden
   * {@link pacman3d.labyrinth.cells.CellWall CellWall-Instanz}.
   *
   * @see #leftSideBox
   * @see #frontSideBox
   * @see #backSideBox
   * @see #topSideBox
   * @see #bottomSideBox
   */
  protected JCheckBox rightSideBox;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Benutzer
   * die Mglichkeit zu geben, auszuwhlen, welche Seite einer Instanz der Klasse
   * {@link pacman3d.labyrinth.cells.CellWall CellWall} texturiert bzw. koloriert
   * werden soll. Ist diese JCheckBox mit einem Hkchen selektiert, so erfolgt
   * eine Texturierung bzw. Kolorierung der vorderen Seite der entsprechenden
   * {@link pacman3d.labyrinth.cells.CellWall CellWall-Instanz}.
   *
   * @see #leftSideBox
   * @see #rightSideBox
   * @see #backSideBox
   * @see #topSideBox
   * @see #bottomSideBox
   */
  protected JCheckBox frontSideBox;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Benutzer
   * die Mglichkeit zu geben, auszuwhlen, welche Seite einer Instanz der Klasse
   * {@link pacman3d.labyrinth.cells.CellWall CellWall} texturiert bzw. koloriert
   * werden soll. Ist diese JCheckBox mit einem Hkchen selektiert, so erfolgt
   * eine Texturierung bzw. Kolorierung der hinteren Seite der entsprechenden
   * {@link pacman3d.labyrinth.cells.CellWall CellWall-Instanz}.
   *
   * @see #leftSideBox
   * @see #rightSideBox
   * @see #frontSideBox
   * @see #topSideBox
   * @see #bottomSideBox
   */
  protected JCheckBox backSideBox;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Benutzer
   * die Mglichkeit zu geben, auszuwhlen, welche Seite einer Instanz der Klasse
   * {@link pacman3d.labyrinth.cells.CellWall CellWall} texturiert bzw. koloriert
   * werden soll. Ist diese JCheckBox mit einem Hkchen selektiert, so erfolgt
   * eine Texturierung bzw. Kolorierung der oberen Seite der entsprechenden
   * {@link pacman3d.labyrinth.cells.CellWall CellWall-Instanz}.
   *
   * @see #leftSideBox
   * @see #rightSideBox
   * @see #frontSideBox
   * @see #backSideBox
   * @see #bottomSideBox
   */
  protected JCheckBox topSideBox;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Benutzer
   * die Mglichkeit zu geben, auszuwhlen, welche Seite einer Instanz der Klasse
   * {@link pacman3d.labyrinth.cells.CellWall CellWall} texturiert bzw. koloriert
   * werden soll. Ist diese JCheckBox mit einem Hkchen selektiert, so erfolgt
   * eine Texturierung bzw. Kolorierung der unteren Seite der entsprechenden
   * {@link pacman3d.labyrinth.cells.CellWall CellWall-Instanz}.
   *
   * @see #leftSideBox
   * @see #rightSideBox
   * @see #frontSideBox
   * @see #backSideBox
   * @see #topSideBox
   */
  protected JCheckBox bottomSideBox;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Zellentyp
   * {@link pacman3d.labyrinth.cells.CellLadderWest CellLadderWest} zum setzen
   * im Labyrinth auszuwhlen.
   *
   * @see #ladderRightCheckBox
   * @see #ladderFrontCheckBox
   * @see #ladderBackCheckBox
   */
  protected JCheckBox ladderLeftCheckBox;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Zellentyp
   * {@link pacman3d.labyrinth.cells.CellLadderEast CellLadderEast} zum setzen
   * im Labyrinth auszuwhlen.
   *
   * @see #ladderLeftCheckBox
   * @see #ladderFrontCheckBox
   * @see #ladderBackCheckBox
   */
  protected JCheckBox ladderRightCheckBox;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Zellentyp
   * {@link pacman3d.labyrinth.cells.CellLadderSouth CellLadderSouth} zum setzen
   * im Labyrinth auszuwhlen.
   *
   * @see #ladderLeftCheckBox
   * @see #ladderRightCheckBox
   * @see #ladderBackCheckBox
   */
  protected JCheckBox ladderFrontCheckBox;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Zellentyp
   * {@link pacman3d.labyrinth.cells.CellLadderNorth CellLadderNorth} zum setzen
   * im Labyrinth auszuwhlen.
   *
   * @see #ladderLeftCheckBox
   * @see #ladderRightCheckBox
   * @see #ladderFrontCheckBox
   */
  protected JCheckBox ladderBackCheckBox;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Zellentyp
   * {@link pacman3d.labyrinth.cells.CellSimpleWindowHorizontal
   * CellSimpleWindowHorizontal} zum setzen im Labyrinth auszuwhlen.
   *
   * @see #simpleWindowVerticalCheckBox
   */
  protected JCheckBox simpleWindowHorizontalCheckBox;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Zellentyp
   * {@link pacman3d.labyrinth.cells.CellSimpleWindowVertical
   * CellSimpleWindowVertical} zum setzen im Labyrinth auszuwhlen.
   *
   * @see #simpleWindowHorizontalCheckBox
   */
  protected JCheckBox simpleWindowVerticalCheckBox;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Zellentyp
   * {@link pacman3d.labyrinth.cells.CellSimpleDoorWest
   * CellSimpleDoorWest} zum setzen im Labyrinth auszuwhlen.
   *
   * @see #cellSimpleDoorRightCheckBox
   * @see #cellSimpleDoorFrontCheckBox
   * @see #cellSimpleDoorBackCheckBox
   */
  protected JCheckBox cellSimpleDoorLeftCheckBox;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Zellentyp
   * {@link pacman3d.labyrinth.cells.CellSimpleDoorEast
   * CellSimpleDoorEast} zum setzen im Labyrinth auszuwhlen.
   *
   * @see #cellSimpleDoorLeftCheckBox
   * @see #cellSimpleDoorFrontCheckBox
   * @see #cellSimpleDoorBackCheckBox
   */
  protected JCheckBox cellSimpleDoorRightCheckBox;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Zellentyp
   * {@link pacman3d.labyrinth.cells.CellSimpleDoorSouth
   * CellSimpleDoorSouth} zum setzen im Labyrinth auszuwhlen.
   *
   * @see #cellSimpleDoorLeftCheckBox
   * @see #cellSimpleDoorRightCheckBox
   * @see #cellSimpleDoorBackCheckBox
   */
  protected JCheckBox cellSimpleDoorFrontCheckBox;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Zellentyp
   * {@link pacman3d.labyrinth.cells.CellSimpleDoorNorth
   * CellSimpleDoorNorth} zum setzen im Labyrinth auszuwhlen.
   *
   * @see #cellSimpleDoorLeftCheckBox
   * @see #cellSimpleDoorRightCheckBox
   * @see #cellSimpleDoorFrontCheckBox
   */
  protected JCheckBox cellSimpleDoorBackCheckBox;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Zellentyp
   * {@link pacman3d.labyrinth.cells.CellArchwayHorizontal
   * CellArchwayHorizontal} zum setzen im Labyrinth auszuwhlen.
   *
   * @see #cellArchwayVerticalCheckBox
   * @see #cellArchwayBothCheckBox
   */
  protected JCheckBox cellArchwayHorizontalCheckBox;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Zellentyp
   * {@link pacman3d.labyrinth.cells.CellArchwayVertical
   * CellArchwayVertical} zum setzen im Labyrinth auszuwhlen.
   *
   * @see #cellArchwayHorizontalCheckBox
   * @see #cellArchwayBothCheckBox
   */
  protected JCheckBox cellArchwayVerticalCheckBox;

  /**
   * Instanz der Klasse {@link javax.swing.JCheckBox JCheckBox}, um den Zellentyp
   * {@link pacman3d.labyrinth.cells.CellArchwayConnection
   * CellArchwayConnection} zum setzen im Labyrinth auszuwhlen.
   *
   * @see #cellArchwayHorizontalCheckBox
   * @see #cellArchwayVerticalCheckBox
   */
  protected JCheckBox cellArchwayBothCheckBox;

  /**
   * Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.AppearanceJPanel
   * AppearanceJPanel}, welche dazu verwendet wird, um die gesetzten Texturen
   * bzw. Farben eines evtl. im Labyrinth gesetzten Zellentyps
   * {@link pacman3d.labyrinth.cells.CellWall CellWall} anzuzeigen.
   *
   * @see #cellSimplePillarAppearanceJPanel
   * @see #cellArchwayAppearanceJPanel
   * @see #cellGlassWallAppearanceJPanel
   * @see #cellSimpleDoorAppearanceJPanel
   * @see #cellLadderAppearanceJPanel
   * @see #cellSimpleWindowAppearanceJPanel
   * @see #cellSimpleConeAppearanceJPanel
   * @see #cellHalfWallAppearanceJPanel
   * @see pacman3d.labyrinth.leveleditor.AppearanceJPanel
   */
  protected AppearanceJPanel appearanceJPanel;

  /**
   * Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.AppearanceJPanel
   * AppearanceJPanel}, welche dazu verwendet wird, um die gesetzten Texturen
   * bzw. Farben eines evtl. im Labyrinth gesetzten Zellentyps
   * {@link pacman3d.labyrinth.cells.CellSimplePillar CellSimplePillar} anzuzeigen.
   *
   * @see #appearanceJPanel
   * @see #cellArchwayAppearanceJPanel
   * @see #cellGlassWallAppearanceJPanel
   * @see #cellSimpleDoorAppearanceJPanel
   * @see #cellLadderAppearanceJPanel
   * @see #cellSimpleWindowAppearanceJPanel
   * @see #cellSimpleConeAppearanceJPanel
   * @see #cellHalfWallAppearanceJPanel
   * @see pacman3d.labyrinth.leveleditor.AppearanceJPanel
   */
  protected AppearanceJPanel cellSimplePillarAppearanceJPanel;

  /**
   * Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.AppearanceJPanel
   * AppearanceJPanel}, welche dazu verwendet wird, um die gesetzten Texturen
   * bzw. Farben der evtl. im Labyrinth gesetzten Zellentypen
   * {@link pacman3d.labyrinth.cells.CellArchwayHorizontal},
   * {@link pacman3d.labyrinth.cells.CellArchwayVertical} oder
   * {@link pacman3d.labyrinth.cells.CellArchwayConnection} anzuzeigen.
   *
   * @see #appearanceJPanel
   * @see #cellSimplePillarAppearanceJPanel
   * @see #cellGlassWallAppearanceJPanel
   * @see #cellSimpleDoorAppearanceJPanel
   * @see #cellLadderAppearanceJPanel
   * @see #cellSimpleWindowAppearanceJPanel
   * @see #cellSimpleConeAppearanceJPanel
   * @see #cellHalfWallAppearanceJPanel
   * @see pacman3d.labyrinth.leveleditor.AppearanceJPanel
   */
  protected AppearanceJPanel cellArchwayAppearanceJPanel;

  /**
   * Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.AppearanceJPanel
   * AppearanceJPanel}, welche dazu verwendet wird, um die gesetzten Texturen
   * bzw. Farben des evtl. im Labyrinth gesetzten Zellentyps
   * {@link pacman3d.labyrinth.cells.CellGlassWall CellGlassWall} anzuzeigen.
   *
   * @see #appearanceJPanel
   * @see #cellSimplePillarAppearanceJPanel
   * @see #cellArchwayAppearanceJPanel
   * @see #cellSimpleDoorAppearanceJPanel
   * @see #cellLadderAppearanceJPanel
   * @see #cellSimpleWindowAppearanceJPanel
   * @see #cellSimpleConeAppearanceJPanel
   * @see #cellHalfWallAppearanceJPanel
   * @see pacman3d.labyrinth.leveleditor.AppearanceJPanel
   */
  protected AppearanceJPanel cellGlassWallAppearanceJPanel;

  /**
   * Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.AppearanceJPanel
   * AppearanceJPanel}, welche dazu verwendet wird, um die gesetzten Texturen
   * bzw. Farben der evtl. im Labyrinth gesetzten Zellentypen
   * {@link pacman3d.labyrinth.cells.CellSimpleDoorNorth CellSimpleDoorNorth},
   * {@link pacman3d.labyrinth.cells.CellSimpleDoorEast CellSimpleDoorEast},
   * {@link pacman3d.labyrinth.cells.CellSimpleDoorSouth CellSimpleDoorSouth} oder
   * {@link pacman3d.labyrinth.cells.CellSimpleDoorWest CellSimpleDoorWest}
   * anzuzeigen.
   *
   * @see #appearanceJPanel
   * @see #cellSimplePillarAppearanceJPanel
   * @see #cellArchwayAppearanceJPanel
   * @see #cellGlassWallAppearanceJPanel
   * @see #cellLadderAppearanceJPanel
   * @see #cellSimpleWindowAppearanceJPanel
   * @see #cellSimpleConeAppearanceJPanel
   * @see #cellHalfWallAppearanceJPanel
   * @see pacman3d.labyrinth.leveleditor.AppearanceJPanel
   */
  protected AppearanceJPanel cellSimpleDoorAppearanceJPanel;

  /**
   * Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.AppearanceJPanel
   * AppearanceJPanel}, welche dazu verwendet wird, um die gesetzten Texturen
   * bzw. Farben der evtl. im Labyrinth gesetzten Zellentypen
   * {@link pacman3d.labyrinth.cells.CellLadderNorth CellLadderNorth},
   * {@link pacman3d.labyrinth.cells.CellLadderEast CellLadderEast},
   * {@link pacman3d.labyrinth.cells.CellLadderSouth CellLadderSouth} oder
   * {@link pacman3d.labyrinth.cells.CellLadderWest CellLadderWest} anzuzeigen.
   *
   * @see #appearanceJPanel
   * @see #cellSimplePillarAppearanceJPanel
   * @see #cellArchwayAppearanceJPanel
   * @see #cellGlassWallAppearanceJPanel
   * @see #cellSimpleWindowAppearanceJPanel
   * @see #cellSimpleConeAppearanceJPanel
   * @see #cellHalfWallAppearanceJPanel
   * @see pacman3d.labyrinth.leveleditor.AppearanceJPanel
   */
  protected AppearanceJPanel cellLadderAppearanceJPanel;

  /**
   * Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.AppearanceJPanel
   * AppearanceJPanel}, welche dazu verwendet wird, um die gesetzten Texturen
   * bzw. Farben der evtl. im Labyrinth gesetzten Zellentypen
   * {@link pacman3d.labyrinth.cells.CellSimpleWindowHorizontal
   * CellSimpleWindowHorizontal} oder
   * {@link pacman3d.labyrinth.cells.CellSimpleWindowVertical
   * CellSimpleWindowVertical}anzuzeigen.
   *
   * @see #appearanceJPanel
   * @see #cellSimplePillarAppearanceJPanel
   * @see #cellArchwayAppearanceJPanel
   * @see #cellGlassWallAppearanceJPanel
   * @see #cellSimpleDoorAppearanceJPanel
   * @see #cellLadderAppearanceJPanel
   * @see #cellSimpleConeAppearanceJPanel
   * @see #cellHalfWallAppearanceJPanel
   * @see pacman3d.labyrinth.leveleditor.AppearanceJPanel
   */
  protected AppearanceJPanel cellSimpleWindowAppearanceJPanel;

  /**
   * Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.AppearanceJPanel
   * AppearanceJPanel}, welche dazu verwendet wird, um die gesetzten Texturen
   * bzw. Farben eines evtl. im Labyrinth gesetzten Zellentyps
   * {@link pacman3d.labyrinth.cells.CellSimpleCone CellSimpleCone} anzuzeigen.
   *
   * @see #appearanceJPanel
   * @see #cellSimplePillarAppearanceJPanel
   * @see #cellArchwayAppearanceJPanel
   * @see #cellGlassWallAppearanceJPanel
   * @see #cellSimpleDoorAppearanceJPanel
   * @see #cellLadderAppearanceJPanel
   * @see #cellSimpleWindowAppearanceJPanel
   * @see #cellHalfWallAppearanceJPanel
   * @see pacman3d.labyrinth.leveleditor.AppearanceJPanel
   */
  protected AppearanceJPanel cellSimpleConeAppearanceJPanel;

  /**
   * Instanz der Klasse {@link pacman3d.labyrinth.leveleditor.AppearanceJPanel
   * AppearanceJPanel}, welche dazu verwendet wird, um die gesetzten Texturen
   * bzw. Farben eines evtl. im Labyrinth gesetzten Zellentyps
   * {@link pacman3d.labyrinth.cells.CellHalfWall CellHalfWall} anzuzeigen.
   *
   * @see #appearanceJPanel
   * @see #cellSimplePillarAppearanceJPanel
   * @see #cellArchwayAppearanceJPanel
   * @see #cellGlassWallAppearanceJPanel
   * @see #cellSimpleDoorAppearanceJPanel
   * @see #cellLadderAppearanceJPanel
   * @see #cellSimpleWindowAppearanceJPanel
   * @see #cellSimpleConeAppearanceJPanel
   * @see pacman3d.labyrinth.leveleditor.AppearanceJPanel
   */
  protected AppearanceJPanel cellHalfWallAppearanceJPanel;

  /**
   * Instanz der Klasse {@link javax.swing.JList JList}, um die evtl. in einer
   * Zelle vom Typ {@link pacman3d.labyrinth.cells.CellFloor CellFloor} gesetzen
   * {@link pacman3d.labyrinth.items.Item Items} aufzulisten.
   *
   * @see #cellArchwayItemList
   * @see #cellSimpleDoorItemList
   * @see #cellLadderItemList
   */
  protected JList cellFloorItemList;

  /**
   * Instanz der Klasse {@link javax.swing.JList JList}, um die evtl. in einer
   * Zelle vom Typ {@link pacman3d.labyrinth.cells.CellArchwayHorizontal
   * CellArchwayHorizontal}, {@link pacman3d.labyrinth.cells.CellArchwayVertical
   * CellArchwayVertical} oder {@link pacman3d.labyrinth.cells.CellArchwayConnection
   * CellArchwayConnection} gesetzen {@link pacman3d.labyrinth.items.Item Items}
   * aufzulisten.
   *
   * @see #cellFloorItemList
   * @see #cellSimpleDoorItemList
   * @see #cellLadderItemList
   */
  protected JList cellArchwayItemList;

  /**
   * Instanz der Klasse {@link javax.swing.JList JList}, um die evtl. in einer
   * Zelle vom Typ {@link pacman3d.labyrinth.cells.CellSimpleDoorNorth
   * CellSimpleDoorNorth}, {@link pacman3d.labyrinth.cells.CellSimpleDoorEast
   * CellSimpleDoorEast}, {@link pacman3d.labyrinth.cells.CellSimpleDoorSouth
   * CellSimpleDoorSouth} oder {@link pacman3d.labyrinth.cells.CellSimpleDoorWest
   * CellSimpleDoorWest} gesetzen {@link pacman3d.labyrinth.items.Item Items}
   * aufzulisten.
   *
   * @see #cellFloorItemList
   * @see #cellArchwayItemList
   * @see #cellLadderItemList
   */
  protected JList cellSimpleDoorItemList;

  /**
   * Instanz der Klasse {@link javax.swing.JList JList}, um die evtl. in einer
   * Zelle vom Typ {@link pacman3d.labyrinth.cells.CellLadderNorth CellLadderNorth},
   * {@link pacman3d.labyrinth.cells.CellLadderEast CellLadderEast},
   * {@link pacman3d.labyrinth.cells.CellLadderSouth CellLadderSouth} oder
   * {@link pacman3d.labyrinth.cells.CellLadderWest CellLadderWest}
   * gesetzen {@link pacman3d.labyrinth.items.Item Items} aufzulisten.
   *
   * @see #cellFloorItemList
   * @see #cellArchwayItemList
   * @see #cellSimpleDoorItemList
   */
  protected JList cellLadderItemList;

  /**
   * Referenz auf die {@link pacman3d.labyrinth.leveleditor.Leveleditor
   * Hauptklasse des Leveleditors}.
   */
  protected Leveleditor leveleditor;


  /**
   * Konstruktor: <br>
   *
   * Diese Klasse ist eine Subklasse von {@link javax.swing.JPanel JPanel} und
   * kann als solche wie alle Swing-Komponenten verwendet werden. Des weiteren
   * ist diese Klasse um einige Funktionalitt erweitert, so durch diverse GUI-Elemente
   * eine Auswahl und Editierung diverser {@link pacman3d.labyrinth.cells.Cell Zellentypen}
   * erfolgen kann.<br>
   * Zur Initialisierung dieser Klasse ist nur eine Instanz auf die
   * {@link pacman3d.labyrinth.leveleditor.Leveleditor Hauptklasse des Leveleditors}
   * zu bergeben.
   *
   * @param leveleditor Hauptklasse des Leveleditors.
   */
  public CellsJPanel(Leveleditor leveleditor) {
    this.leveleditor = leveleditor;
    guiInit();
  }

  /**
   * Initialisierung diverser GUI-Einstellungen dieser Komponente. Diese Methode
   * wird automatisch vom Konstruktor dieser Klasse aufgerufen und sollte somit nicht
   * von Interesse fr den Endanwender sein.
   *
   * @see #CellsJPanel
   */
  private void guiInit() {
    // Hauptlayout:
    this.setLayout(new BorderLayout());
    // Layout fr die einzelnen Panel der versch. Cell-Typen:

    // Fr jeden Zellentyp einen eigenen Reiter ->
    tabbedPane = new JTabbedPane(JTabbedPane.TOP);
    this.add(tabbedPane, BorderLayout.CENTER);

    //
    // CellFloor
    //
    GridBagLayout gbl       = new GridBagLayout();
    GridBagConstraints gbc  = null;
    JPanel cellFloorMainPanel = new JPanel(gbl);

    // Elemente zur Anzeige der gesetzen Items
    JPanel cellFloorItemPanel = new JPanel(new BorderLayout());
    cellFloorItemPanel.setBorder(BorderFactory.createTitledBorder("Gesetzte Items"));
    cellFloorItemList = new JList();
    cellFloorItemList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
    cellFloorItemPanel.add(new JScrollPane(cellFloorItemList, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED), BorderLayout.CENTER);

    JButton delItemButton = new JButton("Lschen");
    delItemButton.setEnabled(false);
    JButton propItemButton = new JButton("Eigenschaften");
    propItemButton.setEnabled(false);
    JPanel dummyJPanel = new JPanel();
    dummyJPanel.add(delItemButton);
    dummyJPanel.add(propItemButton);
    cellFloorItemPanel.add(dummyJPanel, BorderLayout.SOUTH);

    gbc = makeGBC(0, 0, 1, 1);
    gbc.fill    = GridBagConstraints.BOTH;
    gbc.anchor  = GridBagConstraints.CENTER;
    gbc.weightx = 1.0f;
    gbc.weighty = 1.0f;

    gbl.addLayoutComponent(cellFloorItemPanel, gbc);
    cellFloorMainPanel.add(cellFloorItemPanel);

    tabbedPane.addTab("Leerer Gang", cellFloorMainPanel);

    //
    // CellWall
    //
    gbl       = new GridBagLayout();
    JPanel cellWallMainPanel = new JPanel(gbl);
    JPanel checkBoxesSelectionPanel = new JPanel(new GridLayout(3, 2));

    // Komponenten zur Auswahl der zu texturierenden bzw. kolorierenten Seite
    leftSideBox = new JCheckBox("linke Seite", true);
    leftSideBox.setActionCommand("left_side");
    leftSideBox.addActionListener(this);
    checkBoxesSelectionPanel.add(leftSideBox);

    rightSideBox = new JCheckBox("rechte Seite", true);
    rightSideBox.setActionCommand("right_side");
    rightSideBox.addActionListener(this);
    checkBoxesSelectionPanel.add(rightSideBox);

    frontSideBox = new JCheckBox("vodere Seite", true);
    frontSideBox.setActionCommand("front_side");
    frontSideBox.addActionListener(this);
    checkBoxesSelectionPanel.add(frontSideBox);

    backSideBox = new JCheckBox("hintere Seite", true);
    backSideBox.setActionCommand("back_side");
    backSideBox.addActionListener(this);
    checkBoxesSelectionPanel.add(backSideBox);

    topSideBox = new JCheckBox("obere Seite", true);
    topSideBox.setActionCommand("top_side");
    topSideBox.addActionListener(this);
    checkBoxesSelectionPanel.add(topSideBox);

    bottomSideBox = new JCheckBox("untere Seite", true);
    bottomSideBox.setActionCommand("bottom_side");
    bottomSideBox.addActionListener(this);
    checkBoxesSelectionPanel.add(bottomSideBox);

    JPanel dummyWallPanel = new JPanel();
    dummyWallPanel.setBorder(BorderFactory.createTitledBorder("Textur setzen fr"));
    dummyWallPanel.add(checkBoxesSelectionPanel);

    gbc = makeGBC(0, 0, 1, 1);
    gbc.anchor = gbc.CENTER;
    gbc.fill   = gbc.BOTH;
    gbc.weightx = 1.0;
    gbc.weighty = 0.0;
    gbl.addLayoutComponent(dummyWallPanel, gbc);
    cellWallMainPanel.add(dummyWallPanel);

    // Komponenten zur Anzeige der gesetzen Textur bzw. Farbe:
    gbc = makeGBC(0, 1, 1, 1);
    gbc.anchor = gbc.CENTER;
    gbc.fill   = gbc.BOTH;
    gbc.weightx = 1.0;
    gbc.weighty = 1.0;
    String[] descriptions = {"vorne", "hinten", "links", "rechts", "oben", "unten"};
    appearanceJPanel = new AppearanceJPanel(descriptions);
    appearanceJPanel.setBorder(BorderFactory.createTitledBorder("Appearance"));
    gbl.addLayoutComponent(appearanceJPanel, gbc);
    cellWallMainPanel.add(appearanceJPanel);

    JScrollPane scrollPaneForCellWall = new JScrollPane(cellWallMainPanel);
    tabbedPane.addTab("Wand", scrollPaneForCellWall);


    //
    // CellSimplePillar
    //
    gbl       = new GridBagLayout();
    JPanel cellSimplePillarMainPanel = new JPanel(gbl);
    JScrollPane cellSimplePillarMainPanleScrollPane = new JScrollPane(cellSimplePillarMainPanel);
    tabbedPane.addTab("Sule", cellSimplePillarMainPanleScrollPane);

    // Komponenten zur Anzeige der gesetzten Textur bzw. Farbe:
    gbc = makeGBC(0, 0, 1, 1);
    gbc.anchor = gbc.CENTER;
    gbc.fill   = gbc.BOTH;
    gbc.weightx = 1.0;
    gbc.weighty = 1.0;
    String[] cellSimplePillarDescriptions = {""};
    cellSimplePillarAppearanceJPanel = new AppearanceJPanel(cellSimplePillarDescriptions);
    cellSimplePillarAppearanceJPanel.setBorder(BorderFactory.createTitledBorder("Appearance"));
    gbl.addLayoutComponent(cellSimplePillarAppearanceJPanel, gbc);
    cellSimplePillarMainPanel.add(cellSimplePillarAppearanceJPanel);


    //
    // Torbgen
    //
    // CellArchwayConnection
    gbl       = new GridBagLayout();
    JPanel cellArchwayMainPanel = new JPanel(gbl);

    // Komponenten zur Auswahl der zu setzenden Torbogen-Typs:
    JPanel cellArchwayPositionPanel = new JPanel();
    cellArchwayPositionPanel.setBorder(BorderFactory.createTitledBorder("Durchgangsrichtung"));
    cellArchwayHorizontalCheckBox   = new JCheckBox("horizontal");
    cellArchwayHorizontalCheckBox.setSelected(true);
    cellArchwayPositionPanel.add(cellArchwayHorizontalCheckBox);

    cellArchwayVerticalCheckBox  = new JCheckBox("vertikal");
    cellArchwayPositionPanel.add(cellArchwayVerticalCheckBox);

    cellArchwayBothCheckBox  = new JCheckBox("beide");
    cellArchwayPositionPanel.add(cellArchwayBothCheckBox);

    ButtonGroup cellArchwayPositionButtonGroup = new ButtonGroup();
    cellArchwayPositionButtonGroup.add(cellArchwayHorizontalCheckBox);
    cellArchwayPositionButtonGroup.add(cellArchwayVerticalCheckBox);
    cellArchwayPositionButtonGroup.add(cellArchwayBothCheckBox);

    gbc = makeGBC(0, 0, 1, 1);
    gbc.anchor = gbc.CENTER;
    gbc.fill   = gbc.BOTH;
    gbc.weightx = 1.0;
    gbc.weighty = 0.0;
    gbl.addLayoutComponent(cellArchwayPositionPanel, gbc);
    cellArchwayMainPanel.add(cellArchwayPositionPanel);


    JScrollPane cellArchwayMainPanelScrollPane = new JScrollPane(cellArchwayMainPanel);
    tabbedPane.addTab("Torbogen", cellArchwayMainPanel);
    gbc = makeGBC(0, 1, 1, 1);
    gbc.anchor = gbc.CENTER;
    gbc.fill   = gbc.BOTH;
    gbc.weightx = 1.0;
    gbc.weighty = 1.0;
    // Komponenten zur Anzeige der gesetzen Textur/Farbe
    String[] cellArchwayDescriptions = {""};
    cellArchwayAppearanceJPanel = new AppearanceJPanel(cellArchwayDescriptions);
    cellArchwayAppearanceJPanel.setBorder(BorderFactory.createTitledBorder("Appearance"));

    gbl.addLayoutComponent(cellArchwayAppearanceJPanel, gbc);
    cellArchwayMainPanel.add(cellArchwayAppearanceJPanel);

    // Elemente zur Anzeige der gesetzen Items
    JPanel cellArchwayItemPanel = new JPanel(new BorderLayout());
    cellArchwayItemPanel.setBorder(BorderFactory.createTitledBorder("Gesetzte Items"));
    cellArchwayItemList = new JList();
    cellArchwayItemList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
    cellArchwayItemPanel.add(new JScrollPane(cellArchwayItemList, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED), BorderLayout.CENTER);

    JButton delItemArchButton = new JButton("Lschen");
    delItemArchButton.setEnabled(false);
    JButton propItemArchButton = new JButton("Eigenschaften");
    propItemArchButton.setEnabled(false);
    JPanel archItemButtonPanel = new JPanel();
    archItemButtonPanel.add(delItemArchButton);
    archItemButtonPanel.add(propItemArchButton);
    cellArchwayItemPanel.add(archItemButtonPanel, BorderLayout.SOUTH);

    gbc = makeGBC(0, 2, 1, 1);
    gbc.fill    = GridBagConstraints.BOTH;
    gbc.anchor  = GridBagConstraints.CENTER;
    gbc.weightx = 1.0f;
    gbc.weighty = 1.0f;

    gbl.addLayoutComponent(cellArchwayItemPanel, gbc);
    cellArchwayMainPanel.add(cellArchwayItemPanel);


    //
    // CellGlassWall
    //
    gbl       = new GridBagLayout();
    JPanel cellGlassWallMainPanel = new JPanel(gbl);
    CellGlassWall cellGlassWall = new CellGlassWall();

    JScrollPane cellGlassWallMainPanelScrollPane = new JScrollPane(cellGlassWallMainPanel);

    tabbedPane.addTab("Glasswand", cellGlassWallMainPanel);
    gbc = makeGBC(0, 0, 1, 1);
    gbc.anchor = gbc.CENTER;
    gbc.fill   = gbc.BOTH;
    gbc.weightx = 1.0;
    gbc.weighty = 1.0;

    String[] cellGlassWallDescriptions = {""};
    cellGlassWallAppearanceJPanel = new AppearanceJPanel(cellGlassWallDescriptions);
    cellGlassWallAppearanceJPanel.setBorder(BorderFactory.createTitledBorder("Appearance"));
    gbl.setConstraints(cellGlassWallAppearanceJPanel, gbc);
    cellGlassWallMainPanel.add(cellGlassWallAppearanceJPanel);


    //
    // CellSimpleDoor
    //
    gbl       = new GridBagLayout();
    JPanel cellSimpleDoorMainPanel = new JPanel(gbl);

    JPanel cellSimpleDoorPositionPanel = new JPanel();
    cellSimpleDoorPositionPanel.setBorder(BorderFactory.createTitledBorder("Tr offen nach"));
    cellSimpleDoorLeftCheckBox   = new JCheckBox("links");
    cellSimpleDoorLeftCheckBox.setSelected(true);
    cellSimpleDoorPositionPanel.add(cellSimpleDoorLeftCheckBox);

    cellSimpleDoorFrontCheckBox  = new JCheckBox("vorne");
    cellSimpleDoorPositionPanel.add(cellSimpleDoorFrontCheckBox);

    cellSimpleDoorRightCheckBox  = new JCheckBox("rechts");
    cellSimpleDoorPositionPanel.add(cellSimpleDoorRightCheckBox);

    cellSimpleDoorBackCheckBox   = new JCheckBox("hinten");
    cellSimpleDoorPositionPanel.add(cellSimpleDoorBackCheckBox);

    ButtonGroup cellSimpleDoorPositionButtonGroup = new ButtonGroup();
    cellSimpleDoorPositionButtonGroup.add(cellSimpleDoorLeftCheckBox);
    cellSimpleDoorPositionButtonGroup.add(cellSimpleDoorFrontCheckBox);
    cellSimpleDoorPositionButtonGroup.add(cellSimpleDoorRightCheckBox);
    cellSimpleDoorPositionButtonGroup.add(cellSimpleDoorBackCheckBox);

    gbc = makeGBC(0, 0, 1, 1);
    gbc.anchor = gbc.CENTER;
    gbc.fill   = gbc.BOTH;
    gbc.weightx = 1.0;
    gbc.weighty = 0.0;
    gbl.addLayoutComponent(cellSimpleDoorPositionPanel, gbc);
    cellSimpleDoorMainPanel.add(cellSimpleDoorPositionPanel);

    JScrollPane cellSimpleDoorMainPanelScrollPane = new JScrollPane(cellSimpleDoorMainPanel);
    tabbedPane.addTab("Tr", cellSimpleDoorMainPanel);

    gbc = makeGBC(0, 1, 1, 1);
    gbc.anchor = gbc.CENTER;
    gbc.fill   = gbc.BOTH;
    gbc.weightx = 1.0;
    gbc.weighty = 1.0;
    String[] cellSimpleDoorAppearanceDescriptions = {""};
    cellSimpleDoorAppearanceJPanel = new AppearanceJPanel(cellSimpleDoorAppearanceDescriptions);
    cellSimpleDoorAppearanceJPanel.setBorder(BorderFactory.createTitledBorder("Appearance"));
    gbl.addLayoutComponent(cellSimpleDoorAppearanceJPanel, gbc);
    cellSimpleDoorMainPanel.add(cellSimpleDoorAppearanceJPanel);

    // Elemente zur Anzeige der gesetzen Items
    JPanel cellSimpleDoorItemPanel = new JPanel(new BorderLayout());
    cellSimpleDoorItemPanel.setBorder(BorderFactory.createTitledBorder("Gesetzte Items"));
    cellSimpleDoorItemList = new JList();
    cellSimpleDoorItemList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
    cellSimpleDoorItemPanel.add(new JScrollPane(cellSimpleDoorItemList, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED), BorderLayout.CENTER);

    JButton delItemDoorButton = new JButton("Lschen");
    delItemDoorButton.setEnabled(false);
    JButton propItemDoorButton = new JButton("Eigenschaften");
    propItemDoorButton.setEnabled(false);
    JPanel doorItemButtonPanel = new JPanel();
    doorItemButtonPanel.add(delItemDoorButton);
    doorItemButtonPanel.add(propItemDoorButton);
    cellSimpleDoorItemPanel.add(doorItemButtonPanel, BorderLayout.SOUTH);

    gbc = makeGBC(0, 2, 1, 1);
    gbc.fill    = GridBagConstraints.BOTH;
    gbc.anchor  = GridBagConstraints.CENTER;
    gbc.weightx = 1.0f;
    gbc.weighty = 1.0f;

    gbl.addLayoutComponent(cellSimpleDoorItemPanel, gbc);
    cellSimpleDoorMainPanel.add(cellSimpleDoorItemPanel);


    //
    // CellLadder
    //
    gbl       = new GridBagLayout();
    JPanel cellLadderMainPanel = new JPanel(gbl);

    JPanel cellLadderPositionPanel = new JPanel();
    cellLadderPositionPanel.setBorder(BorderFactory.createTitledBorder("Positionierung"));
    ladderLeftCheckBox   = new JCheckBox("links");
    ladderLeftCheckBox.setSelected(true);
    cellLadderPositionPanel.add(ladderLeftCheckBox);

    ladderFrontCheckBox  = new JCheckBox("vorne");
    cellLadderPositionPanel.add(ladderFrontCheckBox);

    ladderRightCheckBox  = new JCheckBox("rechts");
    cellLadderPositionPanel.add(ladderRightCheckBox);

    ladderBackCheckBox   = new JCheckBox("hinten");
    cellLadderPositionPanel.add(ladderBackCheckBox);

    ButtonGroup ladderPositionButtonGroup = new ButtonGroup();
    ladderPositionButtonGroup.add(ladderLeftCheckBox);
    ladderPositionButtonGroup.add(ladderFrontCheckBox);
    ladderPositionButtonGroup.add(ladderRightCheckBox);
    ladderPositionButtonGroup.add(ladderBackCheckBox);

    gbc = makeGBC(0, 0, 1, 1);
    gbc.anchor = gbc.CENTER;
    gbc.fill   = gbc.BOTH;
    gbc.weightx = 1.0;
    gbc.weighty = 0.0;
    gbl.addLayoutComponent(cellLadderPositionPanel, gbc);
    cellLadderMainPanel.add(cellLadderPositionPanel);
    JScrollPane cellLadderMainPanelScrollPane = new JScrollPane(cellLadderMainPanel);
    tabbedPane.addTab("Leiter", cellLadderMainPanel);

    gbc = makeGBC(0, 1, 1, 1);
    gbc.anchor = gbc.CENTER;
    gbc.fill   = gbc.BOTH;
    gbc.weightx = 1.0;
    gbc.weighty = 1.0;
    String[] cellLadderAppearanceDescriptions = {""};
    cellLadderAppearanceJPanel = new AppearanceJPanel(cellLadderAppearanceDescriptions);
    cellLadderAppearanceJPanel.setBorder(BorderFactory.createTitledBorder("Appearance"));
    gbl.addLayoutComponent(cellLadderAppearanceJPanel, gbc);
    cellLadderMainPanel.add(cellLadderAppearanceJPanel);

    // Elemente zur Anzeige der gesetzen Items
    JPanel cellLadderItemPanel = new JPanel(new BorderLayout());
    cellLadderItemPanel.setBorder(BorderFactory.createTitledBorder("Gesetzte Items"));
    cellLadderItemList = new JList();
    cellLadderItemList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
    cellLadderItemPanel.add(new JScrollPane(cellLadderItemList, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED), BorderLayout.CENTER);

    JButton delItemLadderButton = new JButton("Lschen");
    delItemLadderButton.setEnabled(false);
    JButton propItemLadderButton = new JButton("Eigenschaften");
    propItemLadderButton.setEnabled(false);
    JPanel ladderItemButtonPanel = new JPanel();
    ladderItemButtonPanel.add(delItemLadderButton);
    ladderItemButtonPanel.add(propItemLadderButton);
    cellLadderItemPanel.add(ladderItemButtonPanel, BorderLayout.SOUTH);

    gbc = makeGBC(0, 2, 1, 1);
    gbc.fill    = GridBagConstraints.BOTH;
    gbc.anchor  = GridBagConstraints.CENTER;
    gbc.weightx = 1.0f;
    gbc.weighty = 1.0f;

    gbl.addLayoutComponent(cellLadderItemPanel, gbc);
    cellLadderMainPanel.add(cellLadderItemPanel);


    //
    // CellSimpleWindow
    //
    gbl       = new GridBagLayout();
    JPanel cellSimpleWindowMainPanel = new JPanel(gbl);

    JPanel cellSimpleWindowOrientationPanel = new JPanel();
    cellSimpleWindowOrientationPanel.setBorder(BorderFactory.createTitledBorder("Durchsicht"));
    simpleWindowHorizontalCheckBox   = new JCheckBox("horizontal");
    simpleWindowHorizontalCheckBox.setSelected(true);
    cellSimpleWindowOrientationPanel.add(simpleWindowHorizontalCheckBox);

    simpleWindowVerticalCheckBox  = new JCheckBox("vertikal");
    cellSimpleWindowOrientationPanel.add(simpleWindowVerticalCheckBox);

    ButtonGroup simpleWindowOrientationButtonGroup = new ButtonGroup();
    simpleWindowOrientationButtonGroup.add(simpleWindowHorizontalCheckBox);
    simpleWindowOrientationButtonGroup.add(simpleWindowVerticalCheckBox);

    gbc = makeGBC(0, 0, 1, 1);
    gbc.anchor = gbc.CENTER;
    gbc.fill   = gbc.BOTH;
    gbc.weightx = 1.0;
    gbc.weighty = 0.0;
    gbl.addLayoutComponent(cellSimpleWindowOrientationPanel, gbc);
    cellSimpleWindowMainPanel.add(cellSimpleWindowOrientationPanel);
    JScrollPane cellSimpleWindowMainPanelScrollPane = new JScrollPane(cellSimpleWindowMainPanel);

    tabbedPane.addTab("Fenster", cellSimpleWindowMainPanelScrollPane);

    gbc = makeGBC(0, 1, 1, 1);
    gbc.anchor = gbc.CENTER;
    gbc.fill   = gbc.BOTH;
    gbc.weightx = 1.0;
    gbc.weighty = 1.0;
    String[] cellSimpleWindowAppearanceDescriptions = {""};
    cellSimpleWindowAppearanceJPanel = new AppearanceJPanel(cellSimpleWindowAppearanceDescriptions);
    cellSimpleWindowAppearanceJPanel.setBorder(BorderFactory.createTitledBorder("Appearance"));
    gbl.addLayoutComponent(cellSimpleWindowAppearanceJPanel, gbc);
    cellSimpleWindowMainPanel.add(cellSimpleWindowAppearanceJPanel);

    //
    // CellSimpleCone
    //
    gbl       = new GridBagLayout();
    JPanel cellSimpleConeMainPanel = new JPanel(gbl);
    JScrollPane cellSimpleConeMainPanelScrollPane = new JScrollPane(cellSimpleConeMainPanel);
    tabbedPane.addTab("Kegel", cellSimpleConeMainPanelScrollPane);

    gbc = makeGBC(0, 1, 1, 1);
    gbc.anchor = gbc.CENTER;
    gbc.fill   = gbc.BOTH;
    gbc.weightx = 1.0;
    gbc.weighty = 1.0;
    String[] cellSimpleConeAppearanceDescriptions = {""};
    cellSimpleConeAppearanceJPanel = new AppearanceJPanel(cellSimpleConeAppearanceDescriptions);
    cellSimpleConeAppearanceJPanel.setBorder(BorderFactory.createTitledBorder("Appearance"));
    gbl.addLayoutComponent(cellSimpleConeAppearanceJPanel, gbc);
    cellSimpleConeMainPanel.add(cellSimpleConeAppearanceJPanel);

    //
    // CellHalfWall
    //
    gbl       = new GridBagLayout();
    JPanel cellHalfWallMainPanel = new JPanel(gbl);
    JScrollPane cellHalfWallMainPanelScrollPane = new JScrollPane(cellHalfWallMainPanel);
    tabbedPane.addTab("1/4 hohe Wand", cellHalfWallMainPanelScrollPane);

    gbc = makeGBC(0, 1, 1, 1);
    gbc.anchor = gbc.CENTER;
    gbc.fill   = gbc.BOTH;
    gbc.weightx = 1.0;
    gbc.weighty = 1.0;
    String[] cellHalfWallAppearanceDescriptions = {""};
    cellHalfWallAppearanceJPanel = new AppearanceJPanel(cellHalfWallAppearanceDescriptions);
    cellHalfWallAppearanceJPanel.setBorder(BorderFactory.createTitledBorder("Appearance"));
    gbl.addLayoutComponent(cellHalfWallAppearanceJPanel, gbc);
    cellHalfWallMainPanel.add(cellHalfWallAppearanceJPanel);


    tabbedPane.setSelectedIndex(1);
  }


 /**
  * Je nach dem, welcher Reiter der GUI-Komponeten {@link #tabbedPane} zur Auswahl
  * eines Zellentyps gewhlt wurde, wird der entsprechende Zellentyp instantiiert
  * mit der bergebenen Referenz auf die Instanz <b>pos</b> instantiiert und eine
  * Referenz auf diese zurckgeliefert.
  *
  * @param pos Positionsangabe, mit welcher der zu produzierende Zellentyp instantiiert
  *            werden soll.
  * @return    Instanz des selektierten Zellentyps.
  */
  protected Cell produceSelectedCellType(Tuple3i pos) {
    pos = new Point3i(pos.x, pos.y, pos.z);
    switch (tabbedPane.getSelectedIndex()) {
      case 0: return new CellFloor(pos);

      case 1: return new CellWall(pos);

      case 2: return new CellSimplePillar(pos);

      case 3: if (this.cellArchwayHorizontalCheckBox.isSelected())
                return new CellArchwayHorizontal(pos);
              else if (this.cellArchwayVerticalCheckBox.isSelected())
                return new CellArchwayVertical(pos);
              else if (this.cellArchwayBothCheckBox.isSelected())
                return new CellArchwayConnection(pos);

      case 4: return new CellGlassWall(pos);

      case 5: if (this.cellSimpleDoorBackCheckBox.isSelected())
                return new CellSimpleDoorNorth(pos);
              else if (this.cellSimpleDoorFrontCheckBox.isSelected())
                return new CellSimpleDoorSouth(pos);
              else if (this.cellSimpleDoorRightCheckBox.isSelected())
                return new CellSimpleDoorEast(pos);
              else if (this.cellSimpleDoorLeftCheckBox.isSelected())
                return new CellSimpleDoorWest(pos);

      case 6: if (this.ladderBackCheckBox.isSelected())
                return new CellLadderNorth(pos);
              else if (this.ladderFrontCheckBox.isSelected())
                return new CellLadderSouth(pos);
              else if (this.ladderRightCheckBox.isSelected())
                return new CellLadderEast(pos);
              else if (this.ladderLeftCheckBox.isSelected())
                return new CellLadderWest(pos);

      case 7: if (this.simpleWindowHorizontalCheckBox.isSelected())
                return new CellSimpleWindowHorizontal(pos);
              else if (this.simpleWindowVerticalCheckBox.isSelected())
                return new CellSimpleWindowVertical(pos);

      case 8: return new CellSimpleCone(pos);

      case 9: return new CellHalfWall(pos);
    }
    return new CellFloor(pos);
  }

  /**
   * Hilfsmethode fr den GridBagLayout-Manager.
   *
   * @param x x-Koordinate der einzufgenden Komponente.
   * @param y y-Koordinate der einzufgenden Komponente.
   * @param width Horizontal Ausbreitung der einzufgenden Komponente.
   * @param height Vertikale Ausbreitung der einzufgenden Komponente.
   *
   * @return java.awt.GridBagConstraints Instanz.
   */
  private GridBagConstraints makeGBC(int x, int y, int width, int height) {
    GridBagConstraints gbc = new GridBagConstraints();
    gbc.gridx = x;
    gbc.gridy = y;
    gbc.gridwidth = width;
    gbc.gridheight = height;
    gbc.insets = new Insets(1, 1, 1, 1);
    return gbc;
  }

  /**
   * Hilfsmethode, die die Anzahl der selektierten JCheckBoxes
   * {@link #leftSideBox}, {@link #rightSideBox}, {@link #frontSideBox},
   * {@link #backSideBox}, {@link #topSideBox} und {@link #bottomSideBox}
   * zurckliefert.
   *
   * @return Anzahl der selektierten JCheckBoxes {@link #leftSideBox},
   *         {@link #rightSideBox}, {@link #frontSideBox},
   *         {@link #backSideBox}, {@link #topSideBox} und
   *         {@link #bottomSideBox}.
   */
  private int numOfCheckBoxesSelected() {
    int numSelected = 0;

    if (leftSideBox.isSelected())
      numSelected++;
    if (rightSideBox.isSelected())
      numSelected++;
    if (topSideBox.isSelected())
      numSelected++;
    if (bottomSideBox.isSelected())
      numSelected++;
    if (frontSideBox.isSelected())
      numSelected++;
    if (backSideBox.isSelected())
      numSelected++;

    return numSelected;
  }

  /**
   * Diese Methode liefert je nach dem, welche JCheckBoxes von {@link #leftSideBox},
   * {@link #rightSideBox}, {@link #frontSideBox}, {@link #backSideBox},
   * {@link #topSideBox} und {@link #bottomSideBox} selektiert sind, einen bestimmten
   * Integerwert zurck, der angibt, welche Seiten einer Instanz von
   * {@link pacman3d.labyrinth.cells.CellWall CellWall} texturiert bzw.
   * koloriert werden sollen.
   *
   * @return {@link pacman3d.labyrinth.cells.CellWall#setSideMask SideMask} der
   *         zu texturierenden bzw. kolorierenden Seiten einer Instanz der Klasse
   *         {@link pacman3d.labyrinth.cells.CellWall CellWall}.
   */
  protected int getSideMask() {
    int sideMask = 0;

    if (left_side)
      sideMask += pacman3d.labyrinth.cells.CellWall.SIDE_LEFT;
    if (right_side)
      sideMask += pacman3d.labyrinth.cells.CellWall.SIDE_RIGHT;
    if (top_side)
      sideMask += pacman3d.labyrinth.cells.CellWall.SIDE_UP;
    if (bottom_side)
      sideMask += pacman3d.labyrinth.cells.CellWall.SIDE_DOWN;
    if (front_side)
      sideMask += pacman3d.labyrinth.cells.CellWall.SIDE_BACK;
    if (back_side)
      sideMask += pacman3d.labyrinth.cells.CellWall.SIDE_FRONT;

    if (sideMask <= 0)
      return pacman3d.labyrinth.cells.CellWall.SIDES_ALL;

    return sideMask;
  }

  /**
   * Die durch das von dieser Klasse implementierte Interface {@link java.awt.event.ActionListener}
   * geforderte Methode, um auf {@link java.awt.event.ActionEvent ActionEvents} reagieren
   * zu knnen.<br>
   * Alle {@link java.awt.event.ActionEvent ActionEvents}, die hier verarbeitet werden,
   * werden ausschlielich von den JCheckBoxes {@link #leftSideBox},
   * {@link #rightSideBox}, {@link #frontSideBox}, {@link #backSideBox},
   * {@link #topSideBox} und {@link #bottomSideBox} erzeugt und hier insofern
   * verarbeitet, da immer mindestens eine der obigen JCheckBoxes selektiert
   * ist.
   *
   * @param actionEvent {@link java.awt.event.ActionEvent}
   *
   * @see java.awt.event.ActionListener
   * @see #leftSideBox
   * @see #rightSideBox
   * @see #frontSideBox
   * @see #backSideBox
   * @see #topSideBox
   * @see #bottomSideBox
   */
  public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
    if (actionEvent.getActionCommand().equals("left_side")) {
      if (this.numOfCheckBoxesSelected() == 0 && !leftSideBox.isSelected())
        this.leftSideBox.setSelected(this.left_side);
      else
        this.left_side = !this.left_side;
    }
    else if (actionEvent.getActionCommand().equals("right_side")) {
      if (numOfCheckBoxesSelected() == 0 && !rightSideBox.isSelected())
        this.rightSideBox.setSelected(this.right_side);
      else
        this.right_side = !this.right_side;
    }
    else if (actionEvent.getActionCommand().equals("top_side")) {
      if (numOfCheckBoxesSelected() == 0 && !topSideBox.isSelected())
        this.topSideBox.setSelected(this.top_side);
      else
        this.top_side = !this.top_side;
    }
    else if (actionEvent.getActionCommand().equals("bottom_side")) {
      if (numOfCheckBoxesSelected() == 0 && !bottomSideBox.isSelected())
        this.bottomSideBox.setSelected(this.bottom_side);
      else
        this.bottom_side = !this.bottom_side;
    }
    else if (actionEvent.getActionCommand().equals("back_side")) {
      if (numOfCheckBoxesSelected() == 0 && !backSideBox.isSelected())
        this.backSideBox.setSelected(this.back_side);
      else
        this.back_side = !this.back_side;
    }
    else if (actionEvent.getActionCommand().equals("front_side")) {
      if (numOfCheckBoxesSelected() == 0 && !frontSideBox.isSelected())
        this.frontSideBox.setSelected(this.front_side);
      else
        this.front_side = !this.front_side;
    }
  }

  /**
   * Diese Methode selektiert denjenigen {@link #tabbedPane Zellentypen-Reiter},
   * der dem bergebenen Zellentypen <b>selectedCell</b> entspricht und zeigt
   * evtl. weitere Eigenschaften des bergebenen Zellentyps an, wie z.B. evtl.
   * gesetzte Items und Textur- bzw. Farbeigenschaften.
   *
   * @param selectedCell Zelle, deren Eigenschaften angezeigt werden sollen.
   */
  protected void showAttributesOfSelectedCell(Cell selectedCell) {
    if (selectedCell instanceof CellFloor) {
      cellFloorItemList.removeAll();
      cellFloorItemList.setListData(selectedCell.getItems());
      this.tabbedPane.setSelectedIndex(0);
    }
    else if (selectedCell instanceof CellGlassWall) {
      this.cellGlassWallAppearanceJPanel.updateAppearances(selectedCell);
      this.tabbedPane.setSelectedIndex(4);
    }
    else if (selectedCell instanceof CellWall) {
      this.appearanceJPanel.updateAppearances(selectedCell);
      this.tabbedPane.setSelectedIndex(1);
    }
    else if (selectedCell instanceof CellLadderNorth) {
      this.cellLadderAppearanceJPanel.updateAppearances(selectedCell);
      cellLadderItemList.removeAll();
      cellLadderItemList.setListData(selectedCell.getItems());
      this.ladderBackCheckBox.setSelected(true);
      this.tabbedPane.setSelectedIndex(6);
    }
    else if (selectedCell instanceof CellLadderEast) {
      this.cellLadderAppearanceJPanel.updateAppearances(selectedCell);
      cellLadderItemList.removeAll();
      cellLadderItemList.setListData(selectedCell.getItems());
      this.ladderRightCheckBox.setSelected(true);
      this.tabbedPane.setSelectedIndex(6);
    }
    else if (selectedCell instanceof CellLadderSouth) {
      this.cellLadderAppearanceJPanel.updateAppearances(selectedCell);
      cellLadderItemList.removeAll();
      cellLadderItemList.setListData(selectedCell.getItems());
      this.ladderFrontCheckBox.setSelected(true);
      this.tabbedPane.setSelectedIndex(6);
    }
    else if (selectedCell instanceof CellLadderWest) {
      this.cellLadderAppearanceJPanel.updateAppearances(selectedCell);
      cellLadderItemList.removeAll();
      cellLadderItemList.setListData(selectedCell.getItems());
      this.ladderLeftCheckBox.setSelected(true);
      this.tabbedPane.setSelectedIndex(6);
    }
    else if (selectedCell instanceof CellArchwayConnection) {
      this.cellArchwayAppearanceJPanel.updateAppearances(selectedCell);
      cellArchwayItemList.removeAll();
      cellArchwayItemList.setListData(selectedCell.getItems());
      this.cellArchwayBothCheckBox.setSelected(true);
       this.tabbedPane.setSelectedIndex(3);
    }
    else if (selectedCell instanceof CellArchwayHorizontal) {
      this.cellArchwayAppearanceJPanel.updateAppearances(selectedCell);
      cellArchwayItemList.removeAll();
      cellArchwayItemList.setListData(selectedCell.getItems());
      this.cellArchwayHorizontalCheckBox.setSelected(true);
      this.tabbedPane.setSelectedIndex(3);
    }
    else if (selectedCell instanceof CellArchwayVertical) {
      this.cellArchwayAppearanceJPanel.updateAppearances(selectedCell);
      cellArchwayItemList.removeAll();
      cellArchwayItemList.setListData(selectedCell.getItems());
      this.cellArchwayVerticalCheckBox.setSelected(true);
      this.tabbedPane.setSelectedIndex(3);
    }
    else if (selectedCell instanceof CellSimpleDoorNorth) {
      this.cellSimpleDoorAppearanceJPanel.updateAppearances(selectedCell);
      cellSimpleDoorItemList.removeAll();
      cellSimpleDoorItemList.setListData(selectedCell.getItems());
      this.cellSimpleDoorBackCheckBox.setSelected(true);
      this.tabbedPane.setSelectedIndex(5);
    }
    else if (selectedCell instanceof CellSimpleDoorEast) {
      this.cellSimpleDoorAppearanceJPanel.updateAppearances(selectedCell);
      cellSimpleDoorItemList.removeAll();
      cellSimpleDoorItemList.setListData(selectedCell.getItems());
      this.cellSimpleDoorRightCheckBox.setSelected(true);
      this.tabbedPane.setSelectedIndex(5);
    }
    else if (selectedCell instanceof CellSimpleDoorSouth) {
      this.cellSimpleDoorAppearanceJPanel.updateAppearances(selectedCell);
      cellSimpleDoorItemList.removeAll();
      cellSimpleDoorItemList.setListData(selectedCell.getItems());
      this.cellSimpleDoorFrontCheckBox.setSelected(true);
      this.tabbedPane.setSelectedIndex(5);
    }
    else if (selectedCell instanceof CellSimpleDoorWest) {
      this.cellSimpleDoorAppearanceJPanel.updateAppearances(selectedCell);
      cellSimpleDoorItemList.removeAll();
      cellSimpleDoorItemList.setListData(selectedCell.getItems());
      this.cellSimpleDoorLeftCheckBox.setSelected(true);
      this.tabbedPane.setSelectedIndex(5);
    }
    else if (selectedCell instanceof CellSimplePillar) {
      this.cellSimplePillarAppearanceJPanel.updateAppearances(selectedCell);
      this.tabbedPane.setSelectedIndex(2);
    }
    else if (selectedCell instanceof CellSimpleWindowHorizontal) {
      this.cellSimpleWindowAppearanceJPanel.updateAppearances(selectedCell);
      this.simpleWindowHorizontalCheckBox.setSelected(true);
      this.tabbedPane.setSelectedIndex(7);
    }
    else if (selectedCell instanceof CellSimpleWindowVertical) {
      this.cellSimpleWindowAppearanceJPanel.updateAppearances(selectedCell);
      this.simpleWindowVerticalCheckBox.setSelected(true);
      this.tabbedPane.setSelectedIndex(7);
    }
    else if (selectedCell instanceof CellSimpleCone) {
      this.cellSimpleConeAppearanceJPanel.updateAppearances(selectedCell);
      this.tabbedPane.setSelectedIndex(8);
    }
    else if (selectedCell instanceof CellHalfWall) {
      this.cellHalfWallAppearanceJPanel.updateAppearances(selectedCell);
      this.tabbedPane.setSelectedIndex(9);
    }
    else if (selectedCell instanceof Cell) {
      this.tabbedPane.setSelectedIndex(10);
    }
    else if (selectedCell == null) {
      this.cellGlassWallAppearanceJPanel.updateAppearances(selectedCell);
      this.appearanceJPanel.updateAppearances(selectedCell);
      this.cellLadderAppearanceJPanel.updateAppearances(selectedCell);
      this.cellLadderAppearanceJPanel.updateAppearances(selectedCell);
      this.cellLadderAppearanceJPanel.updateAppearances(selectedCell);
      this.cellLadderAppearanceJPanel.updateAppearances(selectedCell);
      this.cellArchwayAppearanceJPanel.updateAppearances(selectedCell);
      this.cellArchwayAppearanceJPanel.updateAppearances(selectedCell);
      this.cellArchwayAppearanceJPanel.updateAppearances(selectedCell);
      this.cellSimpleDoorAppearanceJPanel.updateAppearances(selectedCell);
      this.cellSimpleDoorAppearanceJPanel.updateAppearances(selectedCell);
      this.cellSimpleDoorAppearanceJPanel.updateAppearances(selectedCell);
      this.cellSimpleDoorAppearanceJPanel.updateAppearances(selectedCell);
      this.cellSimplePillarAppearanceJPanel.updateAppearances(selectedCell);
      this.cellSimpleWindowAppearanceJPanel.updateAppearances(selectedCell);
      this.cellSimpleWindowAppearanceJPanel.updateAppearances(selectedCell);
      this.cellSimpleConeAppearanceJPanel.updateAppearances(selectedCell);
    }
  }
}