package pacman3d.labyrinth.leveleditor;

import java.util.Vector;

/**
 * <b>Titel:</b>Pacman 3D - Leveleditor<p>
 *
 * <b>Beschreibung:</b><br>
 * Diese Klasse ist eine Subklasse von {@link java.util.Vector Vector},
 * berschreibt allerdings die Methode {@link java.util.Vector#indexOf indexOf},
 * so da beim Test von "Objektgleichheit" nicht mehr die von allen Klassen
 * geerbte Methode {@link java.lang.Object#equals equals} von {@link
 * java.lang.Object Object} verwendet wird, sondern einfach nur der Operator
 * <code>==</code>. Des weiteren erfolgt in der Methode {@link #indexOf} ein
 * "Typecast" nach {@link pacman3d.labyrinth.cells.Cell Cell}, so da diese
 * Subklasse von Vector nur fr Subklassen von {@link
 * pacman3d.labyrinth.cells.Cell Cell} verwendet werden kann.
 *
 * <b>Copyright:</b>	Copyright (c) 2001/02<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             1.0 03/15/2002<br>
 */
public class CellVector extends Vector {
    /**
     * Konstruktor:<p>
     *
     * Zur Instantiierung dieser Klasse ist nur parameterlose Konstruktor
     * aufzurufen.
     */
    public CellVector() {
      super();
    }

    /**
     * Diese Methode ist von {@link java.util.Vector Vector} geerbt und hier
     * berschrieben, so da beim Test von "Objektgleichheit" nicht mehr die
     * von allen Klassen geerbte Methode {@link java.lang.Object#equals equals}
     * von {@link java.lang.Object Object} verwendet wird, sondern einfach nur
     * der Operator <code>==</code>. Des weiteren erfolgt in dieser Methode ein
     * "Typecast" nach {@link pacman3d.labyrinth.cells.Cell Cell}, so da diese
     * Methode - und somit jede Instanz dieser Klasse - nur fr Subklassen von
     * {@link pacman3d.labyrinth.cells.Cell Cell} verwendet werden kann.
     *
     * @param elem  {@link java.util.Vector#indexOf indexOf(Object, int)}
     * @param index {@link java.util.Vector#indexOf indexOf(Object, int)}
     *
     * @return {@link java.util.Vector#indexOf indexOf(Object, int)}
     */
    public synchronized int indexOf(Object elem, int index) {
	if (elem == null) {
	    for (int i = index ; i < elementCount ; i++)
		if (elementData[i]==null)
		    return i;
	} else {
	    for (int i = index ; i < elementCount ; i++) {
		pacman3d.labyrinth.cells.Cell cell = (pacman3d.labyrinth.cells.Cell)elem;
		if (cell == elementData[i])
                    return i;
            }
	}
	return -1;
    }
}