package pacman3d.labyrinth.items;

import pacman3d.labyrinth.*;

/**
 * <b>Title:</b>            Pacman 3D - Nicht wirklich ;)</br>
 * <b>Description:</b><br>
 *
 * Eine Fackel
 * <p>
 *
 * <b>Copyright:</b>        Copyright (c) 2001<br>
 *
 * @author		    Labyrinth-Gruppe<br>
 * @version 		    4.12.2001<br>
 */

import javax.media.j3d.*;
import com.sun.j3d.utils.geometry.*;
import javax.vecmath.*;

public class ItemTorch extends Item
{
  // Der Java3D Knoten
  private TransformGroup view;
  // Die seite an der die Fackel angebracht ist
  private int side=SIDE_RIGHT;
  // Periode der Animation in milisekunden
  private int animation_duration = 300;
  // soundContainer, der den Sound fr die Fackel enthlt
  private MediaContainer soundContainer;
  // Rotationen fr die Fackel
  private AxisAngle4f[] rotationen = { new AxisAngle4f(0.0f,1.0f,0.0f,3.141593f),
                                              new AxisAngle4f(0.0f,1.0f,0.0f,4.712389f),
                                              new AxisAngle4f(0.0f,0.0f,0.0f,0.0f),
                                              new AxisAngle4f(0.0f,1.0f,0.0f,1.570796f),
                                            };
  // Farben der Fackel
  private Color3f brown    = new Color3f(0.357f,0.192f,0.043f);
  private Color3f darkGray = new Color3f(0.25f,0.25f,0.25f);
  // Farben des Flackerns der Fackel
  private Color3f[] lights = { new Color3f(0.9f,0.9f,0.5f) ,new Color3f(0.86f,0.7f,0.4f),
                                      new Color3f(0.83f,0.5f,0.3f),new Color3f(0.8f,0.3f,0.2f) ,
                                      new Color3f(0.83f,0.5f,0.3f),new Color3f(0.86f,0.7f,0.4f)
                                    };
  // Attentuation fr das Licht der Fackel
  private Point3f attent   = new Point3f(0.0f,0.0f,5.0f);

  /** Seite an der die Fackel befestigt werden kann
   *  Right <=>    X Direction
   */
  static public final int SIDE_RIGHT =  0;

  /** Seite an der die Fackel befestigt werden kann
   *  Left  <=>  - X Direction
   */
  static public final int SIDE_LEFT  =  2;

  /** Seite an der die Fackel befestigt werden kann
   *  Front <=>  - Z Direction
   */
  static public final int SIDE_FRONT =  1;

  /** Seite an der die Fackel befestigt werden kann
   *  Back  <=>    Z Direction
   */
  static public final int SIDE_BACK  =  3;



  /** Leerer Konstruktor
   *  Fackel wird auf der Rechten Seite erzeugt
   */
  public ItemTorch()
  { side=0;
  }

  /** parametrisierter Konstruktor
   *  @param side  Flag der Seite an der die Fackel erzeugt werden soll
   *               SIDE_RIGHT, SIDE_LEFT, SIDE_FRONT, SIDE_BACK
   */
  public ItemTorch(int side) throws Exception
  { setSide(side);
  }

  /** parametrisierter Konstruktor
   *  @param side            Flag der Seite an der die Fackel erzeugt werden soll
   *                         SIDE_RIGHT, SIDE_LEFT, SIDE_FRONT, SIDE_BACK
   *  @param soundContainer  MediaContainer-Objekt mit dem entsprechenden Sound
   */
  public ItemTorch(int side, MediaContainer soundContainer) throws Exception
  { this.soundContainer = soundContainer;
    setSide(side);
  }


  /** Methode um die Fackel zu positionieren
   *  @param side Flag der Seite an der die Fackel erzeugt werden soll
   *              SIDE_RIGHT, SIDE_LEFT, SIDE_FRONT, SIDE_BACK
   */
  public void setSide(int side) throws Exception
  { if(side>3 || side <0)
      throw new P3DException("Ungltige seite im ItemTorch.setSide");
    this.side = side;
  }

  /** Methode um die Periode des Flackerns der Fackel zu setzen
   *  @param duration  In Milisekunden
   */
  public void setDuration(int duration)
  { animation_duration = duration;
  }

  /**
   * Liefert die Periode des Flackerns der Fackel zurck.
   *
   * @return Flackerintervall der Fackel in Milisekunden.
   */
  public int getDuration() {
    return this.animation_duration;
  }

  /** Methode um den Sound der Fackel zu setzen
   *  @param soundContainer  MediaContainer-Objekt mit dem entsprechenden Sound
   */
  public void setSound(MediaContainer soundContainer)
  { this.soundContainer = soundContainer;
  }



  /** Ist das Item ausnehmbar?
   * @return <b>false</b>, da eine Fackel nicht aufgenommen werden kann.
   */
  public boolean isTakable()
  { return false;
  }

  /** Gibt die Java3D-Reprsentation der Fackel zurck
   * @return Die Fackel als Java3D Objekt
   */
  public Node getNode ()
  { build();
    return view;
  }


  /** Diese Methode erzeugt die Fackel.
   *  Es werden Primitive benutzt!
   *  Die Animation wird ber ein Switch und ein SwitchValueInterpolator erzeugt.
   *  todo: das Feuer modelieren
   */
  private void build()
  { // Initiale Rotation
    Transform3D tr = new Transform3D();
    tr.setRotation(rotationen[side]);
    view = new TransformGroup(tr);
    // FackelRumpf -- Farbe: brown
    tr = new Transform3D();
    tr.setTranslation(new Vector3f(-0.47f,0.1f,0.0f));
    tr.setRotation(new AxisAngle4f(0.0f,0.0f,1.0f,-0.3f));
    TransformGroup trGr = new TransformGroup(tr);
    Appearance app = new Appearance();
    app.setMaterial(new Material(brown,black,white,brown,10.0f));
    trGr.addChild(new Cone(0.02f,-0.2f,app));
    tr = new Transform3D();
    tr.setTranslation(new Vector3f(0.0f,0.12f,0.0f));
    TransformGroup trGr2 = new TransformGroup(tr);
    trGr2.addChild(new Cylinder(0.02f,0.06f,app));
    trGr.addChild(trGr2);
    view.addChild(trGr);
    // FackelRing -- Farbe: darkgray
    tr = new Transform3D();
    tr.setTranslation(new Vector3f(-0.44f,0.2f,0.0f));
    trGr = new TransformGroup(tr);
    app = new Appearance();
    app.setMaterial(new Material(darkGray,black,black,black,60.0f));
    trGr.addChild(new Cylinder(0.025f,0.01f,app));
    tr.setTranslation(new Vector3f(-0.04f,0.0f,0.03f));
    tr.setRotation(new AxisAngle4f(0.0f,1.0f,0.0f,0.3f));
    trGr2 = new TransformGroup(tr);
    trGr2.addChild(new Box(0.04f,0.005f,0.005f,app));
    trGr.addChild(trGr2);
    tr = new Transform3D();
    tr.setTranslation(new Vector3f(-0.04f,0.0f,-0.03f));
    tr.setRotation(new AxisAngle4f(0.0f,1.0f,0.0f,-0.3f));
    trGr2 = new TransformGroup(tr);
    trGr2.addChild(new Box(0.04f,0.005f,0.005f,app));
    trGr.addChild(trGr2);
    view.addChild(trGr);
    // FackelFeuer
    //   mit Switch und SwitchInterpolator realisiert
    //   Animation mit 6 Phasen in "animation_duration" milisekunden
    tr = new Transform3D();
    tr.setTranslation(new Vector3f(-0.41f,0.3f,0.0f));
    trGr = new TransformGroup(tr);

      // Sound hinzufgen
      PointSound sound = new PointSound(soundContainer,1.0f,0.0f,0.0f,0.0f);
      sound.setSchedulingBounds(new BoundingBox(new Point3d(-2.0,-0.5,-2.0),new Point3d(2.0,0.5,2.0)));
      sound.setBounds(new BoundingBox(new Point3d(-2.0,-0.5,-2.0),new Point3d(2.0,0.5,2.0)));

      sound.setEnable(true);
      sound.setLoop(Sound.INFINITE_LOOPS);
      Point2f[] disGain = {new Point2f(0.0f,0.5f),new Point2f(1.0f,0.25f), new Point2f(2.0f,0.1f),new Point2f(4.0f,0.0f)};
      sound.setDistanceGain(disGain);
      trGr.addChild(sound);

    // Switch vorbereiten
    Switch lightSwitch = new Switch(0);
    lightSwitch.setCapability(Switch.ALLOW_SWITCH_WRITE);

    Point3f point = new Point3f(0.0f,0.0f,0.0f); //Position des Lichts
    BoundingSphere bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0),4.0);
    PointLight light;
    float[] radien = {0.07f,0.066f,0.072f,0.068f,0.071f,0.069f}; // vorlfig fr die Kugelen

    // 6 Phasen
    for(int i=0;i<6;i++)
    { light = new PointLight(lights[0],point,attent);
      light.setInfluencingBounds(bounds);
      trGr2 = new TransformGroup();
      app = new Appearance();
      app.setMaterial(new Material(lights[i],black,white,lights[i],30.0f));
      trGr2.addChild(new Sphere(radien[i] ,app));
      trGr2.addChild(light);
      lightSwitch.addChild(trGr2);
    }
    // Animation
    Alpha alpha = new Alpha(-1,Alpha.INCREASING_ENABLE,0,0,animation_duration,0,0,0,0,0);
    SwitchValueInterpolator intpol = new SwitchValueInterpolator(alpha,lightSwitch);
    intpol.setSchedulingBounds(bounds);
    trGr.addChild(lightSwitch);
    trGr.addChild(intpol);
    view.addChild(trGr);
  }



}