package pacman3d.labyrinth.items;

import pacman3d.pacman.*;
import pacman3d.util.*;
import pacman3d.message.*;

import java.io.*;
import com.sun.j3d.loaders.Scene;
import javax.media.j3d.*;
import javax.vecmath.*;
import ncsa.j3d.loaders.*;


/**
 *
 * @author Labyrinth-Gruppe
 * @version 20.01.2002
 */

public class ItemToolkit extends Item implements
	pacman3d.message.MessageListener
{

    private Scene sc;

    private int ItemID;
    private double Scale;
    private Point3d ItemPosition;

	/** diese variable enthlt den status des items, wenn es genommen wurde
	 *  muss eine Nachricht an den MessageService geschickt werden, die dafr
	 *  sorgt, dass das Item nach 30 sekunden respawned.
	 *
	 *  bekommt das Item die Nachricht, muss die TransformGroup wieder sichtbar
	 *  werden
	 */
	private boolean m_bIsTaken;

	/** der switch dient dem ausblenden des items */
	private Switch m_oSW;
    /** die instanz zu der die messages geschickt werden */
    private static MessageService m_oMessageService;

    TransformGroup nodeTG;

    /**
     * Einige Items, die wie folgt nummeriert sind:
     *     0  --  ball  (default)
     *     1  --  green apple
     *     2  --  red apple
     *     3  --  pear
     *     4  --  cherry
     *     5  --  banana
     *     6  --  grape
     *     7  --  first-aid-box
     *     8  --  blue pill
     *     9  --  green pill
     *    10  --  orange pill
     *    11  --  red pill
     *    12  --  transparent pill
     *    13  --  machine gun
     *    14  --  hand gun
     *    15  --  (not yet)
     */

    private static String Ball     = "models/ball.wrl";
    private static String AppleGrn = "models/apple-green.wrl";
    private static String AppleRed = "models/apple-red.wrl";
    private static String Pear     = "models/pear.wrl";
    private static String Cherry   = "models/cherry.wrl";
    private static String Banana   = "models/banana.wrl";
    private static String Grape    = "models/grape.wrl";
    private static String FirstAid = "models/first-aid.wrl";
    private static String PillBlu  = "models/pill-blue.wrl";
    private static String PillGrn  = "models/pill-green.wrl";
    private static String PillOrg  = "models/pill-orange.wrl";
    private static String PillRed  = "models/pill-red.wrl";
    private static String PillTrs  = "models/pill-transp.wrl";
    private static String MachGun  = "models/machinegun.3ds";
    private static String HandGun  = "models/handgun.3ds";
    private static String oItems[] = {
		Ball,       //0
		AppleGrn,   //1
		AppleRed,   //2
		Banana,     //3
		Cherry,     //4
		FirstAid,   //5
		Grape,      //6
		Pear,       //7
		PillBlu,    //8
		PillGrn,    //9
		PillOrg,    //10
		PillRed,	//11
		PillTrs,    //12
		MachGun,    //13
		HandGun     //14
		};

	private static int nRespawnTimes[] = {
		0,          //0
		0,          //1
		0,          //2
		3000,       //3
		5000,       //4
		7000,       //5
		9000,       //6
		15000,      //7
		0,          //8
		30000,      //9
		0,          //10
		0,          //11
		0,          //12
		0,          //13
		0           //14
		};

    /**
     * Diese Konstruktormethode initialisiert ein neues Itemobjekt mit Standardwerten
     */
    public ItemToolkit () {
	// original: ItemPosition = new Point3d(1.0, -.4, 0.0);
		this(0,new Point3d(0.0, -.2, 0.0));

    }

    public ItemToolkit (int varItemID) {
		this(varItemID,new Point3d(0.0, -.4, 0.0));
    }

    public ItemToolkit (int varItemID, Point3d varItemPosition) {
	ItemID = varItemID;
	ItemPosition = varItemPosition;
		m_bIsTaken=false;
	build();
		m_oSW.setWhichChild(1);
    }

	/**
	 * klont das Objekt und liefert es zurck
	 * @return der Klon der Instanz mit dem gleichen Typ (aber per
	 * Definition als Objekt gecastet)
	 */
	public Object clone () {
		ItemToolkit oResult = (ItemToolkit) super.clone();

				oResult.nodeTG = new TransformGroup();
				oResult.nodeTG.setCapability(oResult.nodeTG.ALLOW_CHILDREN_READ);
				oResult.nodeTG.addChild( nodeTG.cloneTree() );
				oResult.m_oSW = getSwitch(oResult.nodeTG);
				// das folgende Feld ist doch per Definition
				// von Object.clone() sowieso schon gesetzt!
				// oResult.ItemID = ItemID;
		return oResult;
	}

	/**
	 * returns the visibility status of this item
	 * @return <b>true</b> if visible false otherwise
	 */
	public boolean isVisible (){
		return !m_bIsTaken;
	}

    /**
     * Liefert zurck, ob der mit der Instanz beschriebene Spielgegenstand
     * "aufgenommen" - also benutzt - werden kann (to take!). Fr Vitaminpillen
     * trifft dies beispielsweise zu, fr an die Decke gehngte Lampen - beide
     * werden als <b>items</b> implementiert - jedoch nicht.</p>
     *
     * <p>Die Methode sollte vor dem eigentlichen Aufruf von <i>take()</i>
     * aufgerufen werden</p>
     *
     * <p>Zudem kann ein <b>item</b>-Objekt ein wechselthaftes Verhalten aufweisen
     * und nach bestimmten Kriterien unterschieden mal das "aufnehmen" zulassen
     * und zu anderen Zeitpunkten bzw. Zustnden nicht.</p>
     *
     * @return <b>true</b> wenn Objekt aufgenommen/benutzt werden kann, <br/><b>false</b> wenn nicht.
     */
    public boolean isTakable() {
		switch(ItemID) {
			// bis jetzt sind alle Items "takable",

			// changed ... i think score items should *not* be takable
			// this way items will be executed by pacman and the score will
			// be added, so there won't be that many items in the inventory

			case 0:  return false;
                        case 1:  return false;
                        case 2:  return false;
			case 3:  return false;
			case 4:  return false;
			case 5:  return false;
			case 6:  return false;
			case 7:  return false;
			case 11: return false;
			case 20: return false;
			default:return true;
		}
    }

    /**
     * <p>"nimmt den Gegenstand auf" und fhrt je nach Implementierung der
     * abgeleiteten Itemklasse zu einem internen Statuswechsel. Manche Items
     * sind beispielsweise nach der Aufnahme durch Pacmans unsichtbar und knnen
     * nicht mehr aufgenommen werden.</p>
     *
     * @param oPacman die Instanz eines Pacman-Objekts. Der Parameter wird zur
     * potentiellen Zwei-Wege-Kommunikation mit dem Objekt verwendet.
     */
    public void take (Pacman oPacman) {
	    if (isVisible()) {
			setVisible(false,nRespawnTimes[ItemID]);
	    }
    }

    /**
     * <p>Wird aufgerufen, um Funktionalitt und Semantik des mit der Instanz
     * reprsentierten Gegenstandes auszufhren. Dies lt erkennen, dass items
     * nicht benutzt werden sondern aktiv und autark arbeiten sollen. Mit
     * diesem Ansatz bietet sich ein weiteres Feld an Erweiterungsmglichkeiten,
     * als wenn die <b>Item</b>-Klassen nur passive Codefragmente wren.</p>
     *
     * <p> Die Nutzung dieser Klasse gestaltet sich dann so, dass ein Pacman von
     * der Zelle eine Reihe von darin enthaltenen <b>Items</b> erhlt (oder auch keine
     * bei einer leergerumten Zelle). Mit der Methode <i>isTakable()</i> prft Pacman,
     * ob das jeweilige <b>Item</b> aufnehmbar ist und nimmt es dann auch mit
     * <i>take()</i> auf. Sofort oder zu einem spteren Zeitpunkt kann mit
     * dieser Methode <i>execute()</i> die Ausfhrung der Semantik des <b>Items</b>
     * begonnen werden, die ihrerseits primr auf das bergebene Pacman-Objekt
     * einwirken, aber auch die Umgebung und sich selbst beeinflussen knnen
     * (Licht, etc.)</p>
     *
     * @param oPacman die Instanz eines Pacman-Objekts. Der Parameter wird zur
     * potentiellen Zwei-Wege-Kommunikation mit dem Objekt verwendet.
     * @see Item#take
     * @see Item#isTakable
     */
    public void execute (Pacman oPacman) {
	// Funktionalitt
		if (isVisible() || isTakable()) {
			switch(ItemID) {
			case 0: oPacman.setParameter("score", new Integer(5));
				    setVisible(false,nRespawnTimes[ItemID]);
					break;
			case 1: oPacman.setParameter("score", new Integer(6));
				    setVisible(false,nRespawnTimes[ItemID]);
					break;
			case 2: oPacman.setParameter("score", new Integer(7));
				    setVisible(false,nRespawnTimes[ItemID]);
					break;
			case 3: oPacman.setParameter("score", new Integer(10));
				    setVisible(false,nRespawnTimes[ItemID]);
					break;
			case 4: oPacman.setParameter("score", new Integer(20));
				    setVisible(false,nRespawnTimes[ItemID]);
					break;
			case 5: oPacman.setParameter("score", new Integer(30));
				    setVisible(false,nRespawnTimes[ItemID]);
					break;
			case 6: oPacman.setParameter("score", new Integer(100));
				    setVisible(false,nRespawnTimes[ItemID]);
					break;
			case 7: oPacman.setParameter("lives", new Integer(1));
				    setVisible(false,nRespawnTimes[ItemID]);
					break;
			case 8:
			case 9: //oPacman.setParameter("invincible", new Integer(30000));
				    sendInvincibility(oPacman.getID(),new Integer(30000));
				    setVisible(false,nRespawnTimes[ItemID]);
					break;
			case 10:
			case 11:
			case 12: // unsichtbar, noch nicht implementiert
			case 13: // hand gun, noch nicht
			case 14: // machine gun...
			}
		}
	return;
    }

    /**
     * Liefert den <b>Java3D-Node</b> zurck, der den Gegenstand darstellt, der von
     * der Item-Instanz reprsentiert wird. Ein Objekt vom Typ <i>TransformGroup</i>
     * ist hier sicherlich nicht unblich, aber auch <i>Shape3D</i> oder BranchGroup
     * Instanzen sind denkbar.
     *
     * @return ein Java3D-Node-Objekt, das zum Rendern des Items in der Szene bentigt wird.
     */

    public Node getNode(){
	    return nodeTG;
    }

    /** Gibt die Java3D-Reprsentation des Blinklichtes zurck
	 *
	 *  @param rebuild falls <b>true</b> bergeben wird, wird die
	 *                 Transformgroup neu erstellt, sonst wird die
	 *                 vorhandene zurckgegeben.
	 *
     *  @return Das Blinklicht als Java3D Objekt
     */
    public Node getNode(boolean rebuild) {
		if(rebuild) build();
		return nodeTG;
    }

    /**
     * builds the partial scene of this item
     */
    public void build () {

	// load Modell
	ModelLoader loader = new ModelLoader();
	try{
	    sc = loader.load(oItems[ItemID]);
	    Debug.out(this.getClass().getName(), "loading "+oItems[ItemID], Debug.LEVEL_NOTICE);
	} catch (FileNotFoundException e){
	    // System.exit(1);
			Debug.out( getClass().getName(), e, Debug.LEVEL_WARNING );
	}

		/* Falls das Item nicht gefunden wurde, Fehler melden und
		beenden. */
		if (sc == null) {
			Debug.out( getClass().getName(),
				"could not load item model " + oItems[ItemID] + "!",
				Debug.LEVEL_WARNING );
			return;
		}

	Node loadedNode =  sc.getSceneGroup();
	nodeTG = new TransformGroup();
		nodeTG.setCapability(nodeTG.ALLOW_CHILDREN_READ);

		TransformGroup oTG = new TransformGroup();
		oTG.addChild(loadedNode);
	m_oSW = new Switch();
	m_oSW.setCapability(Switch.ALLOW_SWITCH_READ);
	m_oSW.setCapability(Switch.ALLOW_SWITCH_WRITE);
	m_oSW.setCapability(Switch.ALLOW_CHILDREN_READ);
	//m_oSW.setCapability(Switch.ALLOW_CHILDREN_WRITE);
	m_oSW.addChild(new TransformGroup ());
		m_oSW.addChild(oTG);

	nodeTG.addChild(m_oSW);

	//nodeTG.rotX(-Math.PI/2);

	Transform3D nodePos = new Transform3D();
	nodePos.rotX(-Math.PI/2);

	switch(ItemID) {
	    case 2: Scale = .01;  break;
	    case 4: Scale = .015; break;
	    case 5: Scale = .015; break;
	    case 6: Scale = .015; break;
	    default:Scale = .02;
	}

	nodePos.setScale(Scale);

	nodePos.setTranslation(new Vector3d(ItemPosition.x,ItemPosition.y,ItemPosition.z));
	oTG.setTransform(nodePos);


	BoundingSphere Bounds =	new BoundingSphere(ItemPosition, 2.0);

	AmbientLight ambientLight = new AmbientLight(new Color3f(.5f, .5f, .5f));
	ambientLight.setInfluencingBounds(Bounds);

	DirectionalLight Directionallicht =
	    new DirectionalLight(
		new Color3f(0.7f, 0.7f, 0.7f),
		new Vector3f(new Vector3d(ItemPosition.x-.5,ItemPosition.y-.5,ItemPosition.z+.5)));
	Directionallicht.setInfluencingBounds(Bounds);

	oTG.addChild(ambientLight);
	oTG.addChild(Directionallicht);
	// return nodeTG;
    }
	/**
     * Nimmt eine Nachricht entgegen, die anschliessend ausgewertet
     * wird.
	 *
	 * @param oMessage die entgegengenommene Nachricht
	 * @see pacman3d.message.Message
	 */
    public void getMessage( pacman3d.message.Message oMessage ){
		Object oTemp = oMessage.getContent();
		//Debug.out(this.getClass().getName(),"got message: "+ oMessage);
		if (oTemp instanceof String) {
			if (((String)oTemp).equalsIgnoreCase("showItem")) {
				m_oSW.setWhichChild(1);
				m_bIsTaken=false;
			} else if (((String)oTemp).equalsIgnoreCase("hideItem")) {
				m_oSW.setWhichChild(0);
				m_bIsTaken=true;

				// zustzlich an das eigene Labyrinth einen
				// Methodenaufruf absetzen (wenn es nicht der Server
				// oder Singleplayermode ist, wird der Aufruf in
				// der Methode abgefangen) -> dient zum Herunterzhlen
				// der Scoreitems, um ein Spielende zu determinieren
				if ((m_oLabyrinth != null) && (isCoreItem())) {
					m_oLabyrinth.addCollectedItem(1);
				}
			}
		}

	}
	/**
	 * Diese Funktion sorgt dafr, dass das Item aus- oder eingeblendet
	 * wird.
	 *
	 * @param bIsVisible    <b>true</b> - Item ist sichtbar<br>
	 *                      <b>false</b> - sonst
	 * @param nRespawnTime
	 */
	private void setVisible ( boolean bIsVisible, int nRespawnTime) {

	    if (m_oMessageService == null)
				m_oMessageService = MessageService.getInstance();
		try {
			m_oMessageService.sendMessage(
				new Message(m_oID,"hideItem",m_oID));
		    if (nRespawnTime > 0 ) {

				m_oMessageService.sendDelayedMessage(
					new Message(m_oID,"showItem",m_oID),nRespawnTime);

			}
		}
		catch (Exception ex) {
				Debug.out("ItemToolkit",
					"Error while sending Message",Debug.LEVEL_NOTICE );
				Debug.out(this.getClass().getName(),ex);
		}
	}

	/**
	 * this function will just dump the transformgroups. This way it should
	 * be possible to verify whether or not the TG was successfully cloned.
	 *
	 *
	 * @param oTG TransformGroup to dump
	 */
	private static void dumpTransformGroup (TransformGroup oTG) {

		try {
		    java.util.Enumeration oTemp=oTG.getAllChildren();
			while (oTemp.hasMoreElements()) {
				Object oNext = oTemp.nextElement();
				Debug.out("ItemToolkit",
					"next Element: " + oNext ,Debug.LEVEL_NOTICE );
				if (oNext instanceof TransformGroup) {
					dumpTransformGroup((TransformGroup)oNext);
				} else if (oNext instanceof Switch) {
					Switch oSW = (Switch)oNext;
					java.util.Enumeration oSwitchTemp = oSW.getAllChildren();
					Debug.out("ItemToolkit",
						"selected Element: " + oSW.getWhichChild() ,Debug.LEVEL_NOTICE );

					while (oSwitchTemp.hasMoreElements()) {
						Object oSwitchNext = oSwitchTemp.nextElement();
						Debug.out("ItemToolkit",
							"next Switch Element: " + oSwitchNext ,Debug.LEVEL_NOTICE );
					}
				}
			}
		}
		catch (Exception ex) {

			Debug.out("ItemToolkit",
					"couldn't dump TransformGroup: " + oTG,Debug.LEVEL_NOTICE );
			Debug.out("ItemToolkit",ex);

		}


	}

	/**
	 * this function will search in a given TransformGroup for a Switch,
	 * if one is found it will be returned, if not, an empty one will be
	 * created.
	 *
	 * @param   oTG the TransformGroup to search in
	 * @return  if switch is found it will be returned, or a new one will
	 *          be generated
	 */
	private static Switch getSwitch(TransformGroup oTG) {
		java.util.Enumeration oTemp = oTG.getAllChildren();
		while (oTemp.hasMoreElements()) {
			Object oNext =oTemp.nextElement();
			if (oNext instanceof TransformGroup) {
				return getSwitch((TransformGroup)oNext);
			} else if (oNext instanceof Switch) {
				return (Switch)oNext;
			}
		}
		return new Switch();
	}

	/**
	 * returns whether or not this item is a core item. All Core Items have
	 * to be taken in order to sucessfully end the game.
	 *
	 * @return <b>true</b> if item is a core item <b>false</b> otherwise
	 */
	public boolean isCoreItem() {
		return (ItemID==0);
	}
	/**
	 * sends the pacman the command to enable invincibility for the given
	 * amount of seconds
	 *
	 * @param oPacmanID the pacman to send the message to
	 * @param oTimeOfInvincibility the time that invincibility shall last
	 */
	private void sendInvincibility(pacman3d.message.ID oPacmanID,
		Integer oTimeOfInvincibility) {

		if (m_oMessageService == null)
				m_oMessageService = MessageService.getInstance();
		try {
			m_oMessageService.sendMessage(
				new Message(m_oID,oTimeOfInvincibility,oPacmanID));
		}
		catch (Exception ex) {
				Debug.out("ItemToolkit",
					"Error while sending Message",Debug.LEVEL_NOTICE );
				Debug.out(this.getClass().getName(),ex);
		}

	}

}
