package pacman3d.labyrinth.items;

/**
 * <b>Title:</b>            Pacman 3D - Nicht wirklich ;)</br>
 * <b>Description:</b><br>
 *
 * Eine Fackel
 * <p>
 *
 * <b>Copyright:</b>        Copyright (c) 2001<br>
 *
 * @author		    Labyrinth-Gruppe<br>
 * @version 		    4.12.2001<br>
 */

import javax.media.j3d.*;
import com.sun.j3d.utils.geometry.*;
import javax.vecmath.*;

public class ItemSignalLamp extends Item
{
  // Der Java3D Knoten
  private TransformGroup view;
  // Periode der Animation in milisekunden
  private int animation_duration = 700;
  // Farbe des Blinklichtes
  private Color3f farbe = new Color3f(1.0f,0.0f,0.0f);
  // Attentuation fr das Licht der Fackel
  private Point3f attent = new Point3f(0.0f,0.0f,5.0f);
  // Farben der Lampe
  private Color3f glass    = new Color3f(0.80f,0.50f,0.50f);
  private Color3f darkGray = new Color3f(0.25f,0.25f,0.25f);



  /** Leerer Konstruktor
   *  Ein rotes Blinklicht wird erzeugt
   */
  public ItemSignalLamp()
  { build();
  }

  /** Parametrisierter Konstruktor
   *  Ein Blinklicht der bergebenen Farbe wird erzeugt
   *  @param color  Farbe des Blinklichtes
   */
  public ItemSignalLamp(Color3f color)
  { setColor(color);
  }

  /** Methode um die Farbe des Blinklichtes zu setzen
   *  @param color  Farbe des Blinklichtes
   */
  public void setColor(Color3f color)
  { this.farbe = color;
    build();
  }

  /** Methode um die Periode des Blinken zu setzen
   *  @param duration  In milisekunden
   */
  public void setDuration(int duration)
  { animation_duration = duration;
    build();
  }

  /**
   * Liefert die Periode des Blinkens in Milisekunden.
   *
   * @return  Perdiode des Blinkes in Milisekunden.
   */
  public int getDuration() {
    return this.animation_duration;
  }


  /** Ist das Item ausnehmbar?
   * @return <b>false</b>, da ein Blinklicht nicht aufgenommen werden kann.
   */
  public boolean isTakable()
  { return false;
  }

  /** Gibt die Java3D-Reprsentation des Blinklichtes zurck
   * @return Das Blinklicht als Java3D Objekt
   */
  public Node getNode ()
  {
    return view;
  }


  /** Gibt die Java3D-Reprsentation des Blinklichtes zurck
   * @return Das Blinklicht als Java3D Objekt
   */
  public Node getNode(boolean rebuild)
  { if(rebuild)
      build();
    return view;
  }

  /** Diese Methode erzeugt das Blinklicht
   *  Es werden Primitive benutzt!
   *  Die Animation wird ber ein Switch und ein SwitchValueInterpolator erzeugt.
   */
  private void build()
  { view = new TransformGroup();
    // Licht erzeugen
    Transform3D tr = new Transform3D();
    tr.setTranslation(new Vector3f(0.0f,0.46f,0.0f));
    TransformGroup trGr = new TransformGroup(tr);
    // Switch
    Switch lightSwitch = new Switch(0);
    lightSwitch.setCapability(Switch.ALLOW_SWITCH_WRITE);

    // Licht erzeugen
    BoundingSphere bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0),4.0);
    PointLight light = new PointLight(farbe,new Point3f(0.0f,0.0f,0.0f),attent);
    light.setInfluencingBounds(bounds);
    lightSwitch.addChild(light);

    // MEIN DANK GEHT AN PAUL :o)!!!
    // -> deswegen ging das Clonen nicht -> NullpointerException!!!!
    // Mu man ersteinmal finden!!!
          //lightSwitch.addChild(null);
    lightSwitch.addChild(new Shape3D());
    // MEIN DANK GEHT AN PAUL :o)!!!

    // Animation
    Alpha alpha = new Alpha(-1,Alpha.INCREASING_ENABLE,0,0,animation_duration,0,0,0,0,0);
    SwitchValueInterpolator intpol = new SwitchValueInterpolator(alpha,lightSwitch);
    intpol.setSchedulingBounds(bounds);
    trGr.addChild(lightSwitch);
    trGr.addChild(intpol);
    // Glasskugel erzeugen
    Appearance app = new Appearance();
    app.setTransparencyAttributes(new TransparencyAttributes(TransparencyAttributes.NICEST,0.6f));
    app.setMaterial(new Material(glass,black,white,glass,10.0f));
    trGr.addChild(new Sphere(0.04f,Sphere.GENERATE_NORMALS_INWARD|Sphere.GENERATE_NORMALS,app));
    // Birne erzeugen
    app = new Appearance();
    app.setMaterial(new Material(farbe,black,white,farbe,50.0f));
    trGr.addChild(new Sphere(0.015f,app));
    view.addChild(trGr);
    // Fassung erzeugen
    tr = new Transform3D();
    tr.setTranslation(new Vector3f(0.0f,0.48f,0.0f));
    trGr = new TransformGroup(tr);
    app = new Appearance();
    app.setMaterial(new Material(darkGray,black,black,darkGray,1.0f));
    trGr.addChild(new Cylinder(0.04f,0.025f,app));
    view.addChild(trGr);
    // Halterung erzeugen
    tr = new Transform3D();
    tr.setTranslation(new Vector3f(0.0f,0.495f,0.0f));
    trGr = new TransformGroup(tr);
    app = new Appearance();
    app.setMaterial(new Material(black,black,black,black,50.0f));
    trGr.addChild(new Cylinder(0.045f,0.01f,app));
    view.addChild(trGr);
  }

  /**
   * klont das Objekt und liefert es zurck
   * @return der Klon der Instanz mit dem gleichen Typ (aber per
   * Definition als Objekt gecastet)
   */
  public Object clone () {
    ItemSignalLamp oResult = (ItemSignalLamp) super.clone();
    oResult.view = new TransformGroup();
    java.util.Enumeration enum = view.getAllChildren();
    //getAllShapes(enum);
    oResult.view.addChild( view.cloneTree() );

    return oResult;
  }

  private void getAllShapes(java.util.Enumeration e) {
    while(e.hasMoreElements()){
      Object o = e.nextElement();
      if (o instanceof Shape3D){
        //((Shape3D)o).setCapability(Shape3D.ALLOW_APPEARANCE_READ);
        //((Shape3D)o).setAppearance(super.DUMMY_APPEARANCE);
        //shapes_vector.add(o);// = (Shape3D) o;
        System.out.println(o);
      }
      if (o instanceof Group) {
        Group g = (Group) o;
        System.out.println(g);
        this.getAllShapes(g.getAllChildren());
      }
      if (o == null)
        System.out.println(o);
    }
  }



}