package pacman3d.labyrinth.items;

import javax.media.j3d.*;

import pacman3d.pacman.*;
import pacman3d.util.*;

/**
 * <b>Title:</b> Pacman 3D - Nicht wirklich ;)<br/>
 * <b>Description:</b>
 *
 * <p>Die Itembasisklasse fr bewegliche und/oder kleine Objekte in
 * <i>Labyrinthzellen</i>, die mit Pacmans interagieren knnen und ber eigene Logik
 * fr die 3D-Darstellung verfgen.</p>
 *
 * <p><b>Items</b> sind Objekte die kleiner als <i>Zellen</i> sind wie Vitaminpille, Werkzeugkoffer,
 * Erste-Hilfe-Kasten, Lichtschalter, Tretmine, Tarnkleidung. Sie liegen in <i>Zellen</i>.
 * Entsprechend kann eine Zelle beispielsweise eine Vitaminpille und einen Lichtschalter
 * enthalten. <b>Items</b> sind also die zentralen Interaktionselemente zwischen
 * Pacmans und Labyrinth im Spiel.</p>
 *
 * <p>Items bestehen aus einem Verhalten und einer Optik. Beim Verhalten kann es
 * sich beispielsweise um das Erhhen des Pacmanpunktestands handeln, bei der Optik
 * um die Visualisierung von Vitaminpillen oder Waffen, visualisiert durch
 * Java3D-Objekte. Diese Objekte werden von der <b>Item-Klasse</b> und ihren Ableitungen
 * eigenstndig verwaltet.</p>
 *
 * <b>Copyright:</b> Copyright (c) 2001<br/>
 *
 * @author Labyrinth-Gruppe<br/>
 * @version 25.11.2001<br/>
 */

public class Item implements pacman3d.util.XMLSerializeable,
	java.lang.Cloneable, pacman3d.util.Identifiable,
		pacman3d.message.MessageListener
{
	/** Grundlegende Farbe um Appearance bzw. Material zu erzeugen  */
	static public javax.vecmath.Color3f black = new javax.vecmath.Color3f(0.0f,0.0f,0.0f);

	/** Grundlegende Farbe um Appearance bzw. Material zu erzeugen  */
	static public javax.vecmath.Color3f white = new javax.vecmath.Color3f(1.0f,1.0f,1.0f);

	/** Die eindeutige Bezeichnung dieser Item-Instanz */
	protected pacman3d.message.ID m_oID;

	/** eine Instanz auf das Labyrinth, in dem sich das Item befindet */
	protected pacman3d.labyrinth.Labyrinth m_oLabyrinth = null;



	/**
	 * Diese Konstruktormethode initialisiert ein neues Itemobjekt mit Standardwerten
	 */
	public Item ()
	{ this.createNewID();
	}

	/**
	 * Liefert zurck, ob der mit der Instanz beschriebene Spielgegenstand
	 * "aufgenommen" - also benutzt - werden kann (to take!). Fr Vitaminpillen
	 * trifft dies beispielsweise zu, fr an die Decke gehngte Lampen - beide
	 * werden als <b>items</b> implementiert - jedoch nicht.</p>
	 *
	 * <p>Die Methode sollte vor dem eigentlichen Aufruf von <i>take()</i>
	 * aufgerufen werden</p>
	 *
	 * <p>Zudem kann ein <b>item</b>-Objekt ein wechselthaftes Verhalten aufweisen
	 * und nach bestimmten Kriterien unterschieden mal das "aufnehmen" zulassen
	 * und zu anderen Zeitpunkten bzw. Zustnden nicht.</p>
	 *
	 * @return <b>true</b> wenn Objekt aufgenommen/benutzt werden kann, <br/><b>false</b> wenn nicht.
	 */
	public boolean isTakable()
	{ // Funktionalitt
	  // wird der der entsprechenden Subklasse definiert
		return false;
	}

	/**
	 * Gibt die eindeutige Bezeichnung des Items zurueck.
	 *
	 * @see pacman3d.message.ID
	 * @see pacman3d.util.Identifiable
	 */
	public pacman3d.message.ID getID() {
		return m_oID;
	}

	/**
	 * Setzt die eindeutige Bezeichnung des Items.
	 *
	 * @see pacman3d.message.ID
	 * @see pacman3d.util.Identifiable
	 */
	public void setID( pacman3d.message.ID oID ) {
		m_oID = oID;
	}

	/**
	 * <p>"nimmt den Gegenstand auf" und fhrt je nach Implementierung der
	 * abgeleiteten Itemklasse zu einem internen Statuswechsel. Manche Items
	 * sind beispielsweise nach der Aufnahme durch Pacmans unsichtbar und knnen
	 * nicht mehr aufgenommen werden.</p>
	 *
	 * @param oPacman die Instanz eines Pacman-Objekts. Der Parameter wird zur
	 * potentiellen Zwei-Wege-Kommunikation mit dem Objekt verwendet.
	 * @return nothing
	 */
	public void take (Pacman oPacman)
	{ // Funktionalitt
	  // wird der der entsprechenden Subklasse definiert
		return;
	}

	/**
	 * <p>Wird aufgerufen, um Funktionalitt und Semantik des mit der Instanz
	 * reprsentierten Gegenstandes auszufhren. Dies lt erkennen, dass items
	 * nicht benutzt werden sondern aktiv und autark arbeiten sollen. Mit
	 * diesem Ansatz bietet sich ein weiteres Feld an Erweiterungsmglichkeiten,
	 * als wenn die <b>Item</b>-Klassen nur passive Codefragmente wren.</p>
	 *
	 * <p> Die Nutzung dieser Klasse gestaltet sich dann so, dass ein Pacman von
	 * der Zelle eine Reihe von darin enthaltenen <b>Items</b> erhlt (oder auch keine
	 * bei einer leergerumten Zelle). Mit der Methode <i>isTakable()</i> prft Pacman,
	 * ob das jeweilige <b>Item</b> aufnehmbar ist und nimmt es dann auch mit
	 * <i>take()</i> auf. Sofort oder zu einem spteren Zeitpunkt kann mit
	 * dieser Methode <i>execute()</i> die Ausfhrung der Semantik des <b>Items</b>
	 * begonnen werden, die ihrerseits primr auf das bergebene Pacman-Objekt
	 * einwirken, aber auch die Umgebung und sich selbst beeinflussen knnen
	 * (Licht, etc.)</p>
	 *
	 * @param oPacman die Instanz eines Pacman-Objekts. Der Parameter wird zur
	 * potentiellen Zwei-Wege-Kommunikation mit dem Objekt verwendet.
	 * @return nothing
	 * @see Item#take
	 * @see Item#isTakable
	 */
	public void execute (Pacman oPacman)
	{ // Funktionalitt
	  // wird der der entsprechenden Subklasse definiert
		return;
	}

	/**
	 * Liefert den <b>Java3D-Node</b> zurck, der den Gegenstand darstellt, der von
	 * der Item-Instanz reprsentiert wird. Ein Objekt vom Typ <i>TransformGroup</i>
	 * ist hier sicherlich nicht unblich, aber auch <i>Shape3D</i> oder BranchGroup
	 * Instanzen sind denkbar.
	 *
	 * @return ein Java3D-Node-Objekt, das zum Rendern des Items in der Szene bentigt wird.
	 */
	public Node getNode ()
	{ // Funktionalitt
	  // wird der der entsprechenden Subklasse definiert
		return null;
	}

	/**
	 * klont das Objekt und liefert es zurck
	 * @return der Klon der Instanz mit dem gleichen Typ (aber per
	 * Definition als Objekt gecastet)
	 */
	public Object clone () {
		Item oResult = this;
		try {
			oResult = (Item) super.clone();

			// neue ID fuer das neue Item erzeugen!
			oResult.createNewID();
		} catch (java.lang.CloneNotSupportedException ex) {
			Debug.out (this.getClass().getName(), ex, Debug.LEVEL_CRITICAL);
		}
		return oResult;
	}

	/**
	 * vergleicht die Zelle mit dem angegebenen Objekt und liefert true
	 * bei Gleichheit, sonst falsch.
	 * @param obj das mit sich selbst zu vergleichende Objekt
	 * @return true bei Gleichheit, sonst false
	 */
	public boolean equals (Object obj) {

		// sind die Klassen gleich? die erste wichtige Eigenschaft!
		if (!obj.getClass().getName().equals(this.getClass().getName())) {
			return false;
		}

		return true;

	}

	/**
	 * Nimmt ein XML Element entgegen, und deserialisiert den Zustand des
	 * eigenen Objektes.
	 *
	 * @param oElement      Das XML-Element, unterhalb dessen ein Objekt
	 *                      seinen Zustand speichern darf.
	 */
	public void loadFromDOM( org.w3c.dom.Element oElement ) {

	}

	/**
	 * Serialisiert den Zustand der Instanz in ein XML-Element.
	 *
	 * @param oDoc das Document, in das die Daten eingefgt werden sollen
	 * (wird fr das Erzeugen von Elementen nach dem Factory-Konzept bentigt)
	 * @return Valide XML-Daten in String-Form.
	 */
	public org.w3c.dom.Element saveToDOM(org.w3c.dom.Document oDoc) {
		// neues XML Element fr das Item erzeugen
		org.w3c.dom.Element oItemElement = oDoc.createElement(
			LevelXmlSyntax.TAG_ITEM );

		// Attribut mit der Javaklasse erzeugen
		oItemElement.setAttribute( LevelXmlSyntax.ATTR_JAVACLASS,
			this.getClass().getName() );

		return oItemElement;
	}

	/**
	 * Erzeugt fuer das aktuelle Item eine neue ID.
	 * @see pacman3d.message.ID
	 */
	private void createNewID() {
	  this.m_oID = new pacman3d.message.ID();
	}

	/**
	 * Nimmt eine Nachricht entgegen, die anschliessend ausgewertet
	 * wird.
	 *
	 * @param oMessage die entgegengenommene Nachricht
	 * @see pacman3d.message.Message
	 */
	public void getMessage( pacman3d.message.Message oMessage ){}

	/**
	 * returns visibility status of this item. In Item it will always
	 * return true, but in Itemtoolkit it will be overridden.
	 * @return true
	 */
	public boolean isVisible() {
		return true;
	}

	/**
	 * sets the visibility status of this item.
	 */
	public void setVisibility( boolean bVisibility ) {
		// what now?
	}

	/**
	 * returns whether or not this item is a core item. All Core Items have
	 * to be taken in order to sucessfully end the game.
	 *
	 * @return <b>true</b> if item is a core item <b>false</b> otherwise
	 */
	public boolean isCoreItem() {
		return false;
	}

	/**
	 * setzt einen Zeiger auf das Labyrinth, in dem sich das Item befindet
	 * (dieses Konstrukt ist ntig geworden, um eine Kommunikation zwischen
	 * Labyrinth und Items zu ermglichen. Alternativ htte man auch das
	 * Labyrinth mit einem MessageListener ausstatten knnen, aber dieser
	 * Weg erschien der direktere zu sein)
	 *
	 * @param oLabyrinth die zu speichernde Labyrinth-Instanz
	 */
	public void setLabyrinth(pacman3d.labyrinth.Labyrinth oLabyrinth) {
		m_oLabyrinth = oLabyrinth;
	}

}