package pacman3d.labyrinth.cells;

import javax.media.j3d.*;
import javax.vecmath.*;
import com.sun.j3d.utils.geometry.*;

import java.util.*;
import org.w3c.dom.*;

import pacman3d.util.*;

import com.sun.j3d.loaders.*;
import ncsa.j3d.loaders.*;

import com.mnstarfire.loaders3d.Inspector3DS;

/**
 * <b>Titel:</b>Pacman 3D - Labyrinthzellen<p>
 *
 * <b>Beschreibung:</b><br>
 * <p>
 *
 * <b>Copyright:</b>	Copyright (c) 2001/02<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             1.0 03/15/2002<br>
 */
public class CellSimpleDoor extends Cell { // Der Java3D Knoten
  private TransformGroup view;
  // Die Position der Zelle
  private Tuple3i position;
  protected BranchGroup bg;
  private Shape3D shape = null;
  private Vector shapes_vector = new Vector();

  /** Leerer Konstruktor
   *  initialisiert die Zelle
   */
  public CellSimpleDoor() {
    super(true);
    bg = this.getNode();

  }

  /** Konstruktor
   *  @param pos Position der Zelle
   */
  public CellSimpleDoor(Tuple3i pos) {
    super(true);
    bg = this.getNode();
    setPosition(pos);
  }

  /** Methode setzt die Position der Zelle
   *  @param pos Position der Zelle
   */
  public void setPosition(Tuple3i pos) {
    position = pos;
  }

  /** Methode setzt die Seiten Maske der Zelle
   *  @param sideMask  Flags der Seiten die <b>nicht</b> erzeugt werden sollen
   *                   (Teil)Summe der folgenden Flags:
   *                   SIDE_RIGHT, SIDE_FRONT, SIDE_LEFT, SIDE_BACK
   */
  public void setSideMask(int sideMask) {
  }

  /** Gibt den Java3D Knoten zurck
   *  @return Den Java3d Knoten mit der Ansicht der Zelle.
   */
  public javax.media.j3d.Node getJ3DGroup() {
    build();
    return view;
  }


  /** Erzeugt den Java3D Knoten
   */
  private void build() {
    Transform3D tr = new Transform3D();;
    tr.setScale(0.0254d);

    if(position != null)
      tr.setTranslation(new Vector3f(position.x,position.y,position.z));

    view = new TransformGroup(tr);
    view.addChild(bg);
  }

   /** Setzt eine Textur auf eine Seite
   *  @param side               Flag der Seite(n), die Texturiert werden soll(en).
   *                            Fr mehrere Seiten Summe der Flags.
   *  @param sTextureType       Der Name des Texturtyps, wie er fuer den
   *                            Zugriff auf den <code>ResourceHandler</code>
   *                            benoetigt wird.
   *  @param texId              Die Textur-Id
   *  @see                      pacman3d.util.ResourceHandler
   */
  public void setTexture(int side, String sTextureName, long texId) throws Exception {
    // Textur vom ResourceHandler holen
    ResourceHandler oResourceHandler = ResourceHandler.getInstance();
    Texture tex = oResourceHandler.getTexture( sTextureName );

    String sNull = (tex == null) ? "texture " + sTextureName +
        " not available" : "texture " + sTextureName + " loaded";
    Debug.out (getClass().getName(), sNull, Debug.LEVEL_NOTICE);

    Appearance app = new Appearance();
    // Textur attribute
    TextureAttributes texAttr = new TextureAttributes();
    texAttr.setTextureMode(TextureAttributes.MODULATE);
    app.setTextureAttributes(texAttr);
    app.setTexture(tex);
    // Farbe und Material werden gesetzt
    app.setMaterial(new Material(white,black,white,white,10.0f));

    for (int i = 0; i < shapes_vector.size(); i++) {
      ((Shape3D)shapes_vector.get(i)).setAppearance(app);
    }
    //shape.setAppearance(app);
  }

  /** Setzt eine Farbe auf eine Seiten
   *  @param side   Flag der Seite(n), die Coloriert werden soll(en).
   *                Fr mehrere Seiten Summe der Flags.
   *  @param color  Die Farbe
   *  @param texId  Die Textur-Id
   */
  public void setColor(int side, Color3f color) {
    Material material = new Material(new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.235f/6f, 0.360f/6f, 1.0f/6f), new Color3f(0.235f, 0.360f, 1.0f), new Color3f(1.0f, 1.0f, 1.0f), 128);
    material.setAmbientColor(color);
    material.setLightingEnable(true);
    //shape.getAppearance().setMaterial(material);
  }

  /** Erzeugt eine Seite
   */
  private BranchGroup getNode() {
    java.net.URL url = ClassLoader.getSystemResource("media/models/Simple_open_door.3DS");
    System.out.println(url.getPath());
    Inspector3DS loader = null;
    try {
    loader = new com.mnstarfire.loaders3d.Inspector3DS(url.getPath());
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    loader.setTextureLightingOn();
    loader.parseIt();

    BranchGroup bg = new BranchGroup();
    TransformGroup tg = loader.getModel();
    Enumeration en = tg.getAllChildren();
    getAllShapes(en);

    // Material-Instanz fr Rder (Parameterreihenfolge:
    // ambientColor, emissiveColor, diffuseColor, specularColor, shininess
    Material material = new Material(new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.235f/6f, 0.360f/6f, 1.0f/6f), new Color3f(0.235f, 0.360f, 1.0f), new Color3f(1.0f, 1.0f, 1.0f), 128);
    material.setLightingEnable(true);

    for (int i = 0; i < shapes_vector.size(); i++) {
      Appearance app = ((Shape3D)shapes_vector.get(i)).getAppearance();
      app.setMaterial(material);
    }

    //return scene.getSceneGroup();
    bg.addChild(tg);
    return bg;
  }

  /**
   * liefert ein Array der Appearance-Objekte der sechs Seiten einer CellWall zurck
   * @return ein sechselementiges Array der Appearance-Objekte
   */
  public Appearance[] getAppearance() {
    Appearance[] appearance = new Appearance[1];
    for (int i = 0; i < 1; i++) {
      ;//appearance[i] = cone.getAppearance();
    }
    return appearance;
  }

  /**
   *  Lscht Appearance-Instanz der gegebenen Seite.
   *
   *  @param side   Flag der Seite(n), deren Appearance-Instanzen gelscht werden sollen
   *                Fr mehrere Seiten Summe der Flags.
   */
  public void removeAppearance(int side) {
  }

  public void setAppearance(int side, Appearance appearance) {
    //System.out.println("hier");
    //shape.setAppearance(appearance);
  }

  private void getAllShapes(Enumeration e) {
    while(e.hasMoreElements()){
      Object o = e.nextElement();
      if (o instanceof Shape3D){
        shapes_vector.add(o);// = (Shape3D) o;
      }
      if (o instanceof Group) {
        Group g = (Group) o;
        this.getAllShapes(g.getAllChildren());
      }
    }
  }


}