package pacman3d.labyrinth.cells;

import javax.media.j3d.*;
import javax.vecmath.*;

import pacman3d.util.*;
import pacman3d.labyrinth.items.*;


/**
 * <b>Titel:</b>Pacman 3D - Labyrinthzellen<p>
 *
 * <b>Beschreibung:</b><br>
 * <p>
 *
 * <b>Copyright:</b>	Copyright (c) 2001/02<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             1.0 03/15/2002<br>
 */
public class CellFloor extends Cell
{
	// Der Java3D Knoten
	private TransformGroup view;

	// Die Position der Zelle
	private Tuple3i position;



	/** Leerer Konstruktor
	 *  initialisiert die Zelle
	 */
	public CellFloor() {
		super(true);
	}

	/** Konstruktor
	 *  @param pos Position der Zelle
	 */
	public CellFloor(Tuple3i pos) {
		super(true);
		setPosition(pos);
	}

	/** Methode setzt die Position der Zelle
	 *  @param pos Position der Zelle
	 */
	public void setPosition(Tuple3i pos) {
		position = pos;
	}

	/**
	* Methode liefert die gesetzte Position der Zelle im Labyrinth.
	* @return Position der Zelle im Labyrinth.
	*/
	public Tuple3i getPosition() {
		return position;
	}

	/**
	 * fgt der Spielfeldzelle ein Item hinzu
	 *
	 * @param item Das Item, das der Spielfeldzelle hinzugefgt werden soll.
	 */
	public void addItem(Item item) {
		if(item != null) {
			items.addElement(item);

			// ist die view ungleich null und bereits kompiliert,
			// dann existieren schon andere Items bzw. Elemente in der Zelle
			// und das neue Item ist sanft "dazuzurendern"
			if (view != null) {
				if (view.isCompiled()) {
					BranchGroup bgItem = new BranchGroup();
					bgItem.addChild(item.getNode());
					view.addChild(bgItem);
				}
			}
		}

	}

	/**
	 * Gibt den Java3D Knoten zurck
	 */
	public Node getJ3DGroup() {
		build();
		return view;
	}

	/**
	 * baut die die Java3D-Strukturen fr diesen Zellentyp auf (primr Erzeugen
	 * der 3D-Ansichten der Items)
	 */
	private void build()
	{
		Transform3D tr = new Transform3D();
		if(position != null) {
			tr.setTranslation(new Vector3f(position.x,position.y,position.z));
		}

		view = new TransformGroup(tr);
		view.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
		view.setCapability(TransformGroup.ALLOW_CHILDREN_EXTEND);

		if (hasItems()) {
			Item[] items = getItems();
			for(int i=0; i < items.length; i++) {
				Node n = items[i].getNode();
				if (n != null)
				view.addChild(n);
			}
		}
	}

	/**
	 * klont das Objekt und liefert es zurck
	 * @return der Klon der Instanz mit dem gleichen Typ (aber per
	 * Definition als Objekt gecastet)
	 */
	public Object clone () {
		//CellFloor cellFloor = (CellFloor)super.clone();
		//cellFloor.setPosition(this.position);
		return super.clone();

	}

	/** Setzt eine Textur auf eine Seite
	 *  @param side               Flag der Seite(n), die Texturiert werden soll(en).
	 *                            Fr mehrere Seiten Summe der Flags.
	 *  @param sTextureType       Der Name des Texturtyps, wie er fuer den
	 *                            Zugriff auf den <code>ResourceHandler</code>
	 *                            benoetigt wird.
	 *  @param texId              Die Textur-Id
	 *  @see                      pacman3d.util.ResourceHandler
	 */
	public void setTexture(int side, String sTextureName, long texId) throws Exception {
	}


	public Appearance[] getAppearance() {
		return null;
	}


	public void setColor(int side, javax.vecmath.Color3f color3f) throws Exception {
	}
}