package pacman3d.labyrinth.cells;

import javax.media.j3d.*;
import javax.vecmath.*;
import com.sun.j3d.utils.geometry.*;

import java.util.*;
import org.w3c.dom.*;

import pacman3d.util.*;
import pacman3d.labyrinth.items.*;

import com.sun.j3d.loaders.*;
import ncsa.j3d.loaders.*;

import com.mnstarfire.loaders3d.Inspector3DS;

/**
 * <b>Titel:</b>Pacman 3D - Labyrinthzellen<p>
 *
 * <b>Beschreibung:</b><br>
 * <p>
 *
 * <b>Copyright:</b>	Copyright (c) 2001/02<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             1.0 03/15/2002<br>
 */
public class CellArchwayConnection extends Cell { // Der Java3D Knoten
  protected static TransformGroup MODEL = null;
  static {
    if (MODEL == null) {
      java.net.URL url = ClassLoader.getSystemResource("media/models/Simple_archway_connection.3DS");
      String sEncodedPath = url.getPath();
      String sDecodedPath = java.net.URLDecoder.decode( sEncodedPath );
      Inspector3DS loader = null;
      try {
        loader = new com.mnstarfire.loaders3d.Inspector3DS( sDecodedPath );
      }
      catch(Exception e) {
        e.printStackTrace();
      }
      loader.setTextureLightingOn();
      loader.parseIt();
      MODEL = loader.getModel();

      Transform3D modelTransform = new Transform3D();
      MODEL.getTransform(modelTransform);
      modelTransform.setScale(0.0254d);
      MODEL.setTransform(modelTransform);
    }
  }

  private TransformGroup view;
  // Die Position der Zelle
  private Tuple3i position;
  protected TransformGroup model;
  private Vector shapes_vector = new Vector();

  /** Leerer Konstruktor
   *  initialisiert die Zelle
   */
  public CellArchwayConnection() {
    super(true);
    model = this.getNode();
  }

  /** Konstruktor
   *  @param pos Position der Zelle
   */
  public CellArchwayConnection(Tuple3i pos) {
    super(true);
    model = this.getNode();
    setPosition(pos);
  }

  /** Methode setzt die Position der Zelle
   *  @param pos Position der Zelle
   */
  public void setPosition(Tuple3i pos) {
    position = pos;
  }

  /**
   * Methode liefert die gesetzte Position der Zelle im Labyrinth.
   *
   * @return Position der Zelle im Labyrinth.
   */
  public Tuple3i getPosition() {
    return position;
  }

  /** Methode setzt die Seiten Maske der Zelle
   *  @param sideMask  Flags der Seiten die <b>nicht</b> erzeugt werden sollen
   *                   (Teil)Summe der folgenden Flags:
   *                   SIDE_RIGHT, SIDE_FRONT, SIDE_LEFT, SIDE_BACK
   */
  public void setSideMask(int sideMask) {
  }

  /** Gibt den Java3D Knoten zurck
   *  @return Den Java3d Knoten mit der Ansicht der Zelle.
   */
  public javax.media.j3d.Node getJ3DGroup() {
    build();
    return view;
  }


  /** Erzeugt den Java3D Knoten
   */
  private void build() {
    Transform3D tr = new Transform3D();;

    if(position != null)
      tr.setTranslation(new Vector3f(position.x,position.y,position.z));

    view = new TransformGroup(tr);
    view.addChild(model.cloneTree(true));

    if (hasItems()) {
      Item[] items = getItems();
      for(int i = 0; i < items.length; i++) {
        javax.media.j3d.Node n = items[i].getNode();
        if (n != null)
          view.addChild(n);
      }
    }
  }

   /** Setzt eine Textur auf eine Seite
   *  @param side               Flag der Seite(n), die Texturiert werden soll(en).
   *                            Fr mehrere Seiten Summe der Flags.
   *  @param sTextureType       Der Name des Texturtyps, wie er fuer den
   *                            Zugriff auf den <code>ResourceHandler</code>
   *                            benoetigt wird.
   *  @param texId              Die Textur-Id
   *  @see                      pacman3d.util.ResourceHandler
   */
  public void setTexture(int side, String sTextureName, long texId) throws Exception {
    // Textur vom ResourceHandler holen
    ResourceHandler oResourceHandler = ResourceHandler.getInstance();
    Texture tex = oResourceHandler.getTexture( sTextureName );

    String sNull = (tex == null) ? "texture " + sTextureName +
        " not available" : "texture " + sTextureName + " loaded";
    Debug.out (getClass().getName(), sNull, Debug.LEVEL_NOTICE);

    Appearance app = new Appearance();
    app.setCapability(Appearance.ALLOW_TEXTURE_READ);
    // Textur attribute
    TextureAttributes texAttr = new TextureAttributes();
    texAttr.setTextureMode(TextureAttributes.MODULATE);
    app.setTextureAttributes(texAttr);
    app.setTexture(tex);
    // Farbe und Material werden gesetzt
    app.setMaterial(new Material(white,black,white,white,10.0f));

    for (int i = 0; i < shapes_vector.size(); i++) {
      ((Shape3D)shapes_vector.get(i)).setAppearance(app);
    }
    //shape.setAppearance(app);
  }

  /** Setzt eine Farbe auf eine Seiten
   *  @param side   Flag der Seite(n), die Coloriert werden soll(en).
   *                Fr mehrere Seiten Summe der Flags.
   *  @param color  Die Farbe
   *  @param texId  Die Textur-Id
   */
  public void setColor(int side, Color3f color) {
    Material material = new Material(color,black,white,white,10.0f);
    material.setCapability(Material.ALLOW_COMPONENT_READ);
    material.setLightingEnable(true);
    Appearance appearance = new Appearance();
    appearance.setCapability(Appearance.ALLOW_MATERIAL_READ);
    appearance.setMaterial(material);

    for (int i = 0; i < shapes_vector.size(); i++) {
      ((Shape3D)shapes_vector.get(i)).setAppearance(appearance);
    }
  }

  /** Erzeugt eine Seite
   */
  private TransformGroup getNode() {
    TransformGroup tg = (TransformGroup)MODEL.cloneTree(true);
    getAllShapes(tg.getAllChildren());
    return tg;
  }

  /**
   * liefert ein Array der Appearance-Objekte der sechs Seiten einer CellWall zurck
   * @return ein sechselementiges Array der Appearance-Objekte
   */
  public Appearance[] getAppearance() {
    Appearance[] appearance = new Appearance[1];
    for (int i = 0; i < 1; i++) {
      appearance[i] = ((Shape3D)this.shapes_vector.get(i)).getAppearance();
    }
    return appearance;
  }

  /**
   *  Lscht Appearance-Instanz der gegebenen Seite.
   *
   *  @param side   Flag der Seite(n), deren Appearance-Instanzen gelscht werden sollen
   *                Fr mehrere Seiten Summe der Flags.
   */
  public void removeAppearance(int side) {
  }

  public void setAppearance(int side, Appearance appearance) {
    //System.out.println("hier");
    //shape.setAppearance(appearance);
  }

  private void getAllShapes(Enumeration e) {
    while(e.hasMoreElements()){
      Object o = e.nextElement();
      if (o instanceof Shape3D){
        ((Shape3D)o).setCapability(Shape3D.ALLOW_APPEARANCE_READ);
        ((Shape3D)o).setAppearance(super.DUMMY_APPEARANCE);
        shapes_vector.add(o);// = (Shape3D) o;
      }
      if (o instanceof Group) {
        Group g = (Group) o;
        this.getAllShapes(g.getAllChildren());
      }
    }
  }


  /**
   * Nimmt ein XML Element entgegen, und deserialisiert den Zustand des
   * eigenen Objektes.
   *
   * @param oElement      Das XML-Element, unterhalb dessen ein Objekt
   *                      seinen Zustand speichern darf.
   */
  public void loadFromDOM( org.w3c.dom.Element oElement ) {
    // zunchst die Elternmethode aufrufen und sie werkeln lassen
    super.loadFromDOM(oElement);

    // wenn kein Elemenmt bergeben wurde, dann sofort zurckspringen
    if (oElement == null) {
      return;
    }

    // wir brauchen die Instanz des ResourcenHandlers zum Holen von Texturen
    ResourceHandler oResourceHandler = pacman3d.util.ResourceHandler.getInstance();

    // jetzt holen wir uns unsere Parameter fr die Texturen (entweder ist
    // das bergebene oElement selbst <params> oder ein Kind von ihm)
    Element elParams = null;
    if (oElement.getTagName().equals(LevelXmlSyntax.TAG_PARAMS)) {
      elParams = oElement;
    }
    else {
      elParams = XmlUtils.getChildElement(oElement, LevelXmlSyntax.TAG_PARAMS);
    }
    if (elParams != null) {
      if (elParams.hasChildNodes()) {
        NodeList oChildren = elParams.getChildNodes();

        // gehe durch alle Parameter durch und lade Texturen ein
        for (int i=0; i < oChildren.getLength(); i++) {
          org.w3c.dom.Node ndCurrent = oChildren.item(i);
          if (ndCurrent.getNodeType() == org.w3c.dom.Node.ELEMENT_NODE) {
            if (((Element)ndCurrent).getTagName().equals("texture")) {

              // <texture side="1"><rsrclink xlink:type="simple" xlink:href="#res_wallX"/></texture>

              // job 1 ist das Holen der Seitennummer (iSide)
              int iSide = 0;
              try {
                String sSide = ((Element)ndCurrent).getAttribute("side");
                if (sSide != null) {
                  iSide = new Integer(sSide).intValue();
                }
              }
              catch (java.lang.NumberFormatException ex) {
                Debug.out (this.getClass().getName(), "keine Zahl vorgefunden", Debug.LEVEL_WARNING);
              }

              // job 2 ist das Holen des Texturnamens
              Element elResLink = XmlUtils.getChildElement((Element)ndCurrent, LevelXmlSyntax.TAG_RESOURCELINK);
              String sResName = "";
              if (elResLink != null) {
                // hole den Namen der Resourcen aus dem <rsrclink>-Element und schneide
                // das fhrende # des Namens ab (im <rscrlink>-Element ist der Name der
                // Resource im href-Attribut als ein XPointer-Verweis auf eine folgende
                // Resourcendefinition abgelegt. Die Syntax fr einen solchen lokalen
                // Verweis ist: '#' Name. Dementspreched mu das fhrende # abgeschnitten
                // werden, bevor der ResourceHandler die Anweisung zum Laden bekommt
                sResName = elResLink.getAttribute(LevelXmlSyntax.ATTR_RESOURCELINK_HREF);
                if (sResName.startsWith("#")) {
                  sResName = sResName.substring(1);
                }
                // Debug.out(this.getClass().getName(), "" + sResName);

                // lade die Textur vom ResourcenHandler
                // javax.media.j3d.Texture2D txLoaded = null;
                // txLoaded = oResourceHandler.getTexture(sResName);
                // String sNull = (txLoaded == null) ? "texture " + sResName + " not available" : "texture " + sResName + " loaded";
                // Debug.out (this.getClass().getName(), sNull, Debug.LEVEL_NOTICE);

                try {
                  this.setTexture(iSide, sResName, 0);
                }
                catch (java.lang.Exception ex) {
                  Debug.out (getClass().getName(), ex, Debug.LEVEL_WARNING);
                  Debug.out (getClass().getName(), "error assigning texture", Debug.LEVEL_WARNING);
                }
              }
            }
          }
        }
      }
    }
  }



  /**
   * Serialisiert den Zustand der Instanz in ein XML-Element, hier insbesondere
   * die Parameter zur Darstellung der Zelle (Texturen)
   *
   * @param oDoc das Document, in das die Daten eingefgt werden sollen
   * (wird fr das Erzeugen von Elementen nach dem Factory-Konzept bentigt)
   * @return Valide XML-Daten in String-Form.
   */
  public org.w3c.dom.Element saveToDOM(org.w3c.dom.Document oDoc) {
    // zunchst die Elternmethode aufrufen und sie werkeln lassen
    Element oCell = super.saveToDOM(oDoc);

    // Einfgen der Parameter (hier mu eine Prfung rein, ob schon
    // ein <params>-Tag vorhanden ist
    Element elParams = oDoc.createElement(LevelXmlSyntax.TAG_PARAMS);

    // wir brauchen die Instanz des ResourcenHandlers zum Ablegen von Texturen
    ResourceHandler oResourceHandler = pacman3d.util.ResourceHandler.getInstance();

    // alle sechs Seiten durchlaufen
    for (int iSide = 0; iSide < this.shapes_vector.size(); iSide++) {

      // die Adresse der Textur der aktuellen Seite holen{
      // String sTextureName = sides[iSide].getAppearance().getTexture().toString();
      Debug.out(this.getClass().getName(), "shapes_vector.get(" + iSide + ") == " + shapes_vector.get(iSide));
      Debug.out(this.getClass().getName(), "((Shape3D)shapes_vector.get("+ iSide + ")).getAppearance() == " + ((Shape3D)shapes_vector.get(iSide)).getAppearance());
      Debug.out(this.getClass().getName(), "((Shape3D)shapes_vector.get(" + iSide + ")).getAppearance().getTexture() == " + ((Shape3D)shapes_vector.get(iSide)).getAppearance().getTexture());
      String sTextureName = oResourceHandler.addTexture( ((Shape3D)shapes_vector.get(iSide)).getAppearance().getTexture() );
      // oResourceHandler.addTexture(sides[iSide].getAppearance().getTexture());

      // eine <texture side="."><rsrclink ... xlink:href=""/></texture> Struktur aufbauen
      Element elTexture = oDoc.createElement (LevelXmlSyntax.TAG_TEX);
      elTexture.setAttribute(LevelXmlSyntax.ATTR_TEX_SIDE, "" + (1 << iSide));
      Element elResourceLink = oDoc.createElement(LevelXmlSyntax.TAG_RESOURCELINK);
      elResourceLink.setAttribute("xlink:type", "simple");
      elResourceLink.setAttribute(LevelXmlSyntax.ATTR_RESOURCELINK_HREF, "#" + sTextureName);
      elTexture.appendChild(elResourceLink);
      elParams.appendChild(elTexture);

    }



    oCell.appendChild(elParams);

    return oCell;
  }

  /**
   * klont das Objekt und liefert es zurck
   * @return der Klon der Instanz mit dem gleichen Typ (aber per
   * Definition als Objekt gecastet)
   */
  public Object clone () {
    return super.clone();
  }

}