package pacman3d.labyrinth;

import javax.vecmath.*;


/**
 * <b>Title:</b> Pacman 3D - Nicht wirklich ;)<br/>
 * <b>Description:</b><br>Die Klasse stellt eine Datenstruktur fr Positionsangaben
 * im Labyrinth bereit. Neben den eigentlichen 3 Punktkoordinanten wird auch
 * die Blickrichtung mitgespeichert.
 * <b>Copyright:</b>Copyright (c) 2001-2002<br/>
 *
 * @author Labyrinth-Gruppe<br/>
 * @version $Version$ $Date: 2002/02/17 05:06:13 $<br/>
 */

public class Position {

	/* die Positionsangabe */
	private Point3i m_oPosition = null;

	/* die Blickrichtungsangabe */
	private Vector3d m_oLineOfSight = null;



	/**
	 * der leere Konstruktor initialisiert die Instanz mit neutralen Werten
	 */
	public Position() {
		m_oPosition = new Point3i (0, 0, 0);
		m_oLineOfSight = new Vector3d (0.0, 0.0, 1.0);
	}

	/**
	 * der alternative Konstruktor erlaubt das Setzen der Werte fr
	 * Position (mit den einzelnen Komponentenwerten) und Blickrichtung
	 * @param x die x-Koordinate der Positionsangabe
	 * @param y die y-Koordinate der Positionsangabe
	 * @param z die z-Koordinate der Positionsangabe
	 * @param oLineOfSight die Blickrichtung
	 */
	public Position (int x, int y, int z, Vector3d oLineOfSight) {
		m_oPosition = new Point3i (x, y, z);
		m_oLineOfSight = oLineOfSight;
	}

	/**
	 * der alternative Konstruktor erlaubt das Setzen der Werte fr
	 * Position (mit einem 3i-Vector) und Blickrichtung
	 * @param oPosition die zu reprsentierende Positionsangabe
	 * @param oLineOfSight die Blickrichtung
	 */
	public Position (Point3i oPosition, Vector3d oLineOfSight) {
		m_oPosition = oPosition;
		m_oLineOfSight = oLineOfSight;
	}

	/**
	 * setzt die Positionsangabe mit den Werten der einzelnen Komponenten
	 * @param x die x-Koordinate der Positionsangabe
	 * @param y die y-Koordinate der Positionsangabe
	 * @param z die z-Koordinate der Positionsangabe
	 */
	public void setPosition (int x, int y, int z) {
		this.m_oPosition.set (x,y,z);
	}

	/**
	 * setzt die Positionsangabe mit einem Point3i-Objekt
	 * @param oPosition die neue Position
	 */
	public void setPosition (Point3i oPosition) {
		this.m_oPosition.set(oPosition);
	}

	/**
	 * liefert die Position als Point3i zurck
	 * @return die gespeicherte Positionsangabe
	 */
	public Point3i getPosition () {
		return this.m_oPosition;
	}

	/**
	 * setzt die Blickwinkelangabe
	 * @param oLineOfSight der Blickwinkel (z. B. 1.0, 0.0, 0.0 fr Blick
	 * in die x-Richtung)
	 */
	public void setLineOfSight (Vector3d oLineOfSight) {
		this.m_oLineOfSight.set(oLineOfSight);
	}

	/**
	 * liefert die Blickwinkelangabe zurck
	 * @return der gespeicherte Blickwinkel
	 */
	public Vector3d getLineOfSight () {
		return m_oLineOfSight;
	}

}