package pacman3d.labyrinth;

/**
 * Title:        Pacman 3D
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author Paul Izquierdo Rojas
 * @version 1.0
 */
import java.awt.*;
import javax.vecmath.*;
import pacman3d.message.ID;

public class Overview extends pacman3d.util.GameCockpitPanel
{
	private Labyrinth lab;

	public Overview(Labyrinth lab)
	{
		super(lab.isMultiplayerGame(), lab.isServer());

		// einige Einstellungen setzen
		this.setBackground(new Color(80,80,80));
		this.lab = lab;
	}

	/**
	 * ldt die Bilder fr die Darstellung ein. Die Methode sollte von
	 * den Nachkommen der Klasse berschrieben werden, wenn sie ein
	 * eigenes Design wnschen.
	 */
	protected void loadImages () {

		// Einladen von Bildern. Knnte man das nicht auch ber den
		// Resourcenhandler abwickeln. Vielleicht so ein
		// Resourcenbeschreibungsfile (in xml), dass immer eingeladen
		// wird, da es fr GameFrame / AboutBox / Hilfe ntig ist.
		imgBorderWithLogo = getToolkit().createImage("media/gameframe/images/cockpit_border_top_2.png");
		imgBorderBottom = getToolkit().createImage("media/gameframe/images/cockpit_border_bottom_2.png");
		imgBorderLeft = getToolkit().createImage("media/gameframe/images/cockpit_border_left_2.png");
		imgBorderRight = getToolkit().createImage("media/gameframe/images/cockpit_border_right_2.png");

		// setzen des Flags "bild geladen" (als Indikator in der Paint-Methode)
		bImagesLoaded = true;
	}

  public void paint(Graphics gr)
  {
    super.paint(gr);
    // Graphics2D g = (Graphics2D) oGr;

    Graphics2D g = (Graphics2D) gr;
    // g.setBackground(Color.black);
    g.setColor(Color.white);
    Color lightYellow = new Color(1.0f,1.0f,0.7f);
    int xmax = lab.getConstraints().x;
    int ymax = lab.getConstraints().z;
    int zmax = lab.getConstraints().y;
    int breite = this.getWidth()-30;
    int hoehe  = this.getHeight()-30;
    //g.clearRect(0,0,breite,hoehe);
    float br,xb,yb,zb;
    int xa, ya;
    int mpz, ppz;
    if(breite>=hoehe)
    { br=hoehe-8;
      xa=(breite-hoehe-8)/2+20;
      ya=20;
    }
    else
    { br=breite-8;
      xa=20;
      ya=(hoehe-breite-8)/2+20;
    }
    xb = xmax * br/(xmax+ymax/2);
    yb = br-xb;
    zb = br-yb;
    // Hinten
    g.setColor(Color.gray);
    g.drawLine(i(xa+yb),i(ya+zb),i(xa+xb+yb),i(ya+zb));
    g.drawLine(i(xa+yb),i(ya+zb),i(xa+yb)   ,i(ya)   );
    g.drawLine(i(xa+yb),i(ya+zb),i(xa)      ,i(ya+br));
    //Innen
    float xr = xb/xmax;
    float yr = yb/ymax;
    float zr = zb/zmax;
    Tuple3i pp = lab.getPacmanPos(lab.getActivePacmanID());
    ppz = ymax-1-pp.z;
    int ebene = pp.y;
    //Monster unter Ebene
    g.setColor(Color.darkGray);
    Tuple3i mp;
    ID[] ids = lab.getAllMonsterIds();
    for(int i=0;i<ids.length;i++)
    { mp = lab.getMonsterPos(ids[i]);
      mpz = ymax-1-mp.z;
      if (mp.y<ebene)
      { g.fillOval(i(xa+(mp.x*xr)+(xr/2)+(mpz*yr)+(yr/2)-(xr*0.4f)),i(ya+br-((mp.y*zr)+(mpz*yr)+(yr/2)+(yr*0.4f))),i(xr*0.8f),i(yr*0.8f));
	g.drawLine(i(xa+(mp.x*xr)+(xr/2)),i(ya+br-(mp.y*zr)),i(xa+(mp.x*xr)+(xr/2)+yb),i(ya+br-((mp.y*zr)+yb)));
	g.drawLine(i(xa+(mpz*yr)+(yr/2)),i(ya+br-((mp.y*zr)+(mpz*yr)+(yr/2))),i(xa+(mpz*yr)+(yr/2)+xb),i(ya+br-((mp.y*zr)+(mpz*yr)+(yr/2))));
	g.fillRect(i(xa+(mp.x*xr)+(xr/2)-1),i(ya+br-(mp.y*zr)-1),3,3);
	g.fillRect(i(xa+(mpz*yr)+(yr/2)+xb-1),i(ya+br-((mp.y*zr)+(mpz*yr)+(yr/2))-1),3,3);
      }
    }
    //Ebene
    g.setColor(lightYellow);
    g.setXORMode(Color.black);
    g.fillPolygon(new int[]{i(xa),i(xa+xb),i(xa+br),i(xa+yb)},
		  new int[]{i(ya+br-(ebene*zr)),(int)(ya+br-(ebene*zr)),(int)(ya+br-(ebene*zr+yb)),(int)(ya+br-(ebene*zr+yb))},4);
    g.setColor(Color.blue);
    for(int i=0;i<xmax;i++)
      for(int j=0;j<ymax;j++)
      { if (!lab.getCell(i,ebene,ymax-1-j).isWalkable())
	  g.fillPolygon(new int[]{i(xa+(i*xr)+   (j*yr)   ),
				  i(xa+(i*xr)+xr+(j*yr)   ),
				  i(xa+(i*xr)+xr+(j*yr)+yr),
				  i(xa+(i*xr)+   (j*yr)+yr)
				 },
			new int[]{i(ya+br-(ebene*zr+   (j*yr))),
				  i(ya+br-(ebene*zr+   (j*yr))),
				  i(ya+br-(ebene*zr+yr+(j*yr))),
				  i(ya+br-(ebene*zr+yr+(j*yr)))
				 },4);
      }
    //Pacman
    g.setColor(Color.red);
    g.setPaintMode();
    g.fillOval(i(xa+(pp.x*xr)+(xr/2)+(ppz*yr)+(yr/2)-(xr*0.4f)),i(ya+br-((ebene*zr)+(ppz*yr)+(yr/2)+(yr*0.4f))),i(xr*0.8f),i(yr*0.8f));
    //Rand
    g.setColor(Color.yellow);
    g.drawLine(i(xa   ),i(ya+br-ebene*zr   ),i(xa+xb),i(ya+br-ebene*zr   ));
    g.drawLine(i(xa+xb),i(ya+br-ebene*zr   ),i(xa+br),i(ya+br-ebene*zr-yb));
    g.drawLine(i(xa+yb),i(ya+br-ebene*zr-yb),i(xa+br),i(ya+br-ebene*zr-yb));
    g.drawLine(i(xa   ),i(ya+br-ebene*zr   ),i(xa+yb),i(ya+br-ebene*zr-yb));
    //Monster ber Ebene
    g.setColor(Color.blue);
    for(int i=0;i<ids.length;i++)
    { mp = lab.getMonsterPos(ids[i]);
      mpz = ymax-1-mp.z;
      if (mp.y>ebene)
      { g.fillOval(i(xa+(mp.x*xr)+(xr/2)+(mpz*yr)+(yr/2)-(xr*0.4f)),i(ya+br-((mp.y*zr)+(mpz*yr)+(yr/2)+(yr*0.4f))),i(xr*0.8f),i(yr*0.8f));
	g.drawLine(i(xa+(mp.x*xr)+(xr/2)),i(ya+br-(mp.y*zr)),i(xa+(mp.x*xr)+(xr/2)+yb),i(ya+br-((mp.y*zr)+yb)));
	g.drawLine(i(xa+(mpz*yr)+(yr/2)),i(ya+br-((mp.y*zr)+(mpz*yr)+(yr/2))),i(xa+(mpz*yr)+(yr/2)+xb),i(ya+br-((mp.y*zr)+(mpz*yr)+(yr/2))));
	g.fillRect(i(xa+(mp.x*xr)+(xr/2)-1),i(ya+br-(mp.y*zr)-1),3,3);
	g.fillRect(i(xa+(mpz*yr)+(yr/2)+xb-1),i(ya+br-((mp.y*zr)+(mpz*yr)+(yr/2))-1),3,3);
      }
      if (mp.y==ebene)
	g.fillOval(i(xa+(mp.x*xr)+(xr/2)+(mpz*yr)+(yr/2)-(xr*0.4f)),i(ya+br-((mp.y*zr)+(mpz*yr)+(yr/2)+(yr*0.4f))),i(xr*0.8f),i(yr*0.8f));
    }
    // Vorne
    g.setColor(Color.white);
    // Quadrat Vorne
    g.drawLine(i(xa   ),i(ya+br),i(xa+xb),i(ya+br));
    g.drawLine(i(xa   ),i(ya+yb),i(xa+xb),i(ya+yb));
    g.drawLine(i(xa   ),i(ya+br),i(xa   ),i(ya+yb));
    g.drawLine(i(xa+xb),i(ya+br),i(xa+xb),i(ya+yb));
    // Seiten Hinten
    g.drawLine(i(xa+yb),i(ya   ),i(xa+br),i(ya   ));
    g.drawLine(i(xa+br),i(ya+zb),i(xa+br),i(ya   ));
    // Diagonalen
    g.drawLine(i(xa+yb),i(ya   ),i(xa   ),i(ya+yb));
    g.drawLine(i(xa+br),i(ya   ),i(xa+xb),i(ya+yb));
    g.drawLine(i(xa+br),i(ya+zb),i(xa+xb),i(ya+br));
  }

  private int i(float f)
  {return (int)(f+0.5f);}
}