package pacman3d.labyrinth;

import pacman3d.message.*;

/**
 * <b>Title:</b>Pacman 3D - Nicht wirklich ;)</br>
 * <b>Description:</b><br>
 * LabyrinthContainer stellt einen Container dar, in den mit ID Objekte
 * eingefgt und lokalisiert werden knnen *
 * <b>Copyright:</b>	Copyright (c) 2001-2002<br>
 *
 * @author              Labyrinth-Gruppe<br>
 * @version             $Version$ $Date: 2002/02/11 09:28:14 $<br>
 */

public class LabyrinthContainer {

    private String klassentyp;
    private java.util.Vector v = new java.util.Vector();

    /** Nur bergebene Klasse wird in dem Container akzeptiert
     *  @param typ  Klassentyp, der im Container gespeichert werden soll.
     */
    public LabyrinthContainer(String classTyp)
    { klassentyp = classTyp;
    }

    /** Fgt ein Objekt hinzu. ndert ein vorhandenes
     *  @param id  ID des Objektes.
     *  @param o   Objekt das im Container gespeichert werden soll,
     *             mu vom im Konstruktor festgelegtem Klassentyp sein.
     */
    public void add(ID id, Object o) throws P3DException
    { if(!o.getClass().getName().equals(klassentyp))
	throw new P3DException("Wrong Class at LabyrinthContainer.add()");
      int index = find(id);
      if(index==-1)
	v.add(new Entry(id,o));
      else
	((Entry)v.elementAt(index)).o = o;
    }

    /** Sucht ein Objekt.
     *  @param id  ID des Objektes.
     *  @return    Das entsprechende Objekt
     */
    public Object get(ID id)
    { Entry e = null;
      for(java.util.Enumeration en = v.elements();en.hasMoreElements();)
      { e = (Entry) en.nextElement();
	if(e.id.equals(id))
	  return e.o;
      }
      return null;
    }

    /** Lscht ein Objekt.
     *  @param id  ID des Objektes.
     */
    public void del(ID id)
    { int index = find(id);
      if(index>=0)
	v.removeElementAt(index);
    }

    /** Gibt alle Ids in diesem Container zurck
     */
    public ID[] getAllIds()
    { ID[] ids = new ID[v.size()];
      for(int i=0;i<v.size();i++)
	ids[i] = ((Entry)v.elementAt(i)).id;
      return ids;
    }


    /** Gibt die Anzahl der Objekte zurck.
     */
    public int count()
    { return v.size();
    }


    /** Sucht ein Object und gibt den index zurck
     */
    private int find(ID id)
    { for(int i=0;i<v.size();i++)
	if(((Entry)v.elementAt(i)).id.equals(id))
	  return i;
      return -1;
    }

    /** Interne Klasse
     *  Stellt ein Eintrag dar.
     */
    class Entry
    { ID id;
      Object o;
       public Entry(ID id, Object o)
       { this.id = id;
	  this.o = o;
       }
    }

}