package pacman3d.intro;

import javax.vecmath.*;
import javax.media.j3d.*;
import pacman3d.util.Debug;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.util.Enumeration;

/**
 * Zur Ereignisbehandlung in der PacmanRoomScene.
 * @see PacmanRoomScene
 * @author Gruppe Intro + Netz
 * */

public class PacmanRoomSceneBehavior extends Behavior {

	private WakeupOnElapsedFrames wakeUp = null;
	private int rotStatus = 0;
	private RotPosPathInterpolator interpolator1 = null;
	private RotPosPathInterpolator interpolator2 = null;
	private RotPosPathInterpolator interpolator3 = null;

	private TransformGroup viewTG = null;
	private Transform3D view = new Transform3D();
	private int activeView = 0;

	private PacmanRoomScene pacman_scene = null;
	private SimpleUniverse simpleU = null;

	/**
	 * Konstruktor
	 * @param simpleU SimpleUniverse
	 * @param pacman_scene pacman3dP.intro.PacmanRoomScene
	 * */
	public PacmanRoomSceneBehavior(
		SimpleUniverse simpleU,
		PacmanRoomScene pacman_scene) {

		setSchedulingBounds(Defaults.BIG_BOUNDS);
		if (simpleU != null) {
			viewTG = simpleU.getViewingPlatform().getViewPlatformTransform();
		} else
			Debug.out(
				getClass().getName(),
				"SimpleUniverse is null!!!",
				Debug.LEVEL_CRITICAL);
		this.pacman_scene = pacman_scene;
		this.simpleU = simpleU;

		interpolator1 = pacman_scene.getRotPosPathInt1();
		interpolator2 = pacman_scene.getRotPosPathInt2();
		interpolator3 = pacman_scene.getRotPosPathInt3();
	}

	/**
	 * Initialisiert den Behavior
	 * */
	public void initialize() {
		wakeUp = new WakeupOnElapsedFrames(1, false);
		wakeupOn(wakeUp);
	}

	/**
	 * Was beim WakeUp des Behaviors gemacht werden soll.
	 * @param criteria Enumeration
	 * */
	public void processStimulus(Enumeration criteria) {

		if (rotStatus == 0) {
			// hier geht noch nix

		} else if (rotStatus == 1) {

			if (interpolator1.getAlpha().value() > 0.95) {
				// er ist da (vor menu)
				interpolator1.setEnable(false);
				setEnable(0);
				setViewPos(2);
			}

		} else if (rotStatus == 2) {

			if (interpolator2.getAlpha().value() > 0.95) {
				// er ist da (vor menu)
				interpolator2.setEnable(false);
				setEnable(0);
				setViewPos(2);
			}

		} else if (rotStatus == 3) {

			if (interpolator3.getAlpha().value() > 0.95) {
				// er ist da (vor menu)
				setEnable(0);
				setViewPos(3);
				interpolator3.setEnable(false);
			}

		}

		wakeupOn(wakeUp);
	}

	/**
	 * Aktiviert den bergebenen Interpolator.
	 * @param i Interpolatorindex
	 * */
	public void setEnable(int i) {
		if (i > -1 && i < 4) {
			rotStatus = i;
		}
		switch (rotStatus) {

			case 0 :
				break;
			case 1 :
				setViewPos(4);
				pacman_scene.setRotPosPathInterpolator(1);
				break;
			case 2 :
				setViewPos(4);
				pacman_scene.setRotPosPathInterpolator(2);
				break;
			case 3 :
				setViewPos(4);
				pacman_scene.setRotPosPathInterpolator(3);
				break;
		}
	}
	
	/**
	 * Deaktiviert den bergebenen Interpolator.
	 * @param i Interpolatorindex
	 * */
	public void setDisable(int i) {
		if (i > -1 && i < 4) {
			rotStatus = i;
		}
		switch (rotStatus) {

			case 0 :
				break;
			case 1 :
				//setViewPos(4);
				interpolator1.setEnable(false);
				System.out.println("Interpolator1 = false");
				break;
			case 2 :
				//setViewPos(4);
				interpolator2.setEnable(false);
				System.out.println("Interpolator2 = false");
				break;
			case 3 :
				//setViewPos(4);
				interpolator3.setEnable(false);
				System.out.println("Interpolator3 = false");
				break;
		}
	}

	/**
	 * Setzt die ViewingPosition des Betrachters.
	 * @param i ViewingPositonIndex
	 * */
	public void setViewPos(int i) {

		Transform3D universeTransform = new Transform3D();
		Transform3D tmp = new Transform3D();
		Transform3D tmp2 = new Transform3D();
		switch (i) {

			case 1 : // bruecke -> menu	
				universeTransform.set(new Vector3f(0.0f, 10.0f, -38.0f));
				break;

			case 2 : // credits -> menu
				universeTransform.set(new Vector3f(0.0f, 10.0f, -38.0f));
				break;

			case 3 : // vor credits
				universeTransform.set(new Vector3f(0.0f, 10.0f, -38.0f));
				tmp.rotY(Math.PI / 2.4);
				universeTransform.mul(tmp);
				break;

			case 4 : // vor bruecke
				universeTransform.set(new Vector3f(20.0f, 10.0f, 5.0f));
				tmp.rotY(Math.PI / 6.5);
				tmp2.setScale(1.8);
				universeTransform.mul(tmp);
				universeTransform.mul(tmp2);
				break;
		}
		simpleU.getViewingPlatform().getViewPlatformTransform().setTransform(
			universeTransform);
	}

}