package pacman3d.intro;

import java.awt.Font;
import javax.media.j3d.*;
import javax.vecmath.*;
import pacman3d.util.Debug;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.geometry.Text2D;
import com.sun.j3d.utils.universe.SimpleUniverse;

/**
 * Stellt die Introszene dar.
 * @author Gruppe Intro + Netz
 */
public class PacmanRoomScene {

	// fuer Wegstrecke des Pacman
	private RotPosPathInterpolator rotPosPathInt1;
	private RotPosPathInterpolator rotPosPathInt2;
	private RotPosPathInterpolator rotPosPathInt3;
	private Alpha alpha1;
	private Alpha alpha2;
	private Alpha alpha3;

	// Umschaltpause zwischen Credit-Eintraegen
	private static final int CREDITS_SWITCH_TIME = 20000;

	public static BoundingSphere LITTLE_BOUNDS =
		new BoundingSphere(new Point3d(0.0f, 0.0f, 0.0f), 1.0f);

	// das Universum, in dem wir uns befinden
	private SimpleUniverse su = null;

	private TransformGroup viewTG = new TransformGroup();
	private PacmanRoomSceneBehavior behavior = null;
	private Intro intro = null;

	/**
	 * Konstruktor
	 * Empfngt das Universum.
	 * @author Gruppe Intro + Netz
	 * @param simpleU Universum
	 * @param intro Instanz der Klasse Intro
	 * */
	public PacmanRoomScene(SimpleUniverse simpleU, Intro intro) {
		su = simpleU;
		this.intro = intro;
	}

	/**
	 * Hilfsmethode zum Laden der Credits-Elemente.
	 * @param nameFile 3ds-Datei
	 * @param symbolFile 3ds-Datei
	 * @return TransformGroup
	 *
	 * */
	private TransformGroup switchCredits(String nameFile, String symbolFile) {
		TransformGroup targetTG = new TransformGroup();
		targetTG.addChild(Intro.loadTGfrom3DS(nameFile));
		targetTG.addChild(Intro.loadTGfrom3DS(symbolFile));
		return targetTG;

	}

	/**
	 * Gibt an, ob der zum bergebenen Index gehrende Interpolator aktiv ist.
	 * @param i Interpolatorindex
	 * @return boolean
	 * */
	public boolean isActiveInterpolator(int i) {

		if (i == 1 && rotPosPathInt1.getEnable() == true) {
			System.out.println("rotPosPathInt1 aktiv...");
			return true;
		}
		if (i == 2 && rotPosPathInt2.getEnable() == true) {
			System.out.println("rotPosPathInt2 aktiv...");
			return true;
		}

		if (i == 3 && rotPosPathInt3.getEnable() == true) {
			System.out.println("rotPosPathInt3 aktiv...");
			return true;
		} else
			return false;
	}

	/**
	 * Gibt aktiven Interpolatorindex zurck.
	 * @return Integer
	 * */
	public int getActiveInterpolatorIndex() {

		if (rotPosPathInt1.getEnable() == true)
			return 1;
		if (rotPosPathInt2.getEnable() == true)
			return 2;
		if (rotPosPathInt3.getEnable() == true)
			return 3;
		else
			return 0;
	}

	/**
	 * Aktiviert den zum Parameter gehrenden Interpolator.
	 * @see PacmanRoomSceneBehavior#setEnable(int i)
	 * @param i Interpolatorindex
	 * */
	protected void setEnable(int i) {
		if (behavior != null)
			behavior.setEnable(i);
	}

	/**
	 * Deaktiviert den zum Parameter gehrenden Interpolator.
	 * @see PacmanRoomSceneBehavior#setDisable(int i)
	 * @param i Interpolatorindex
	 * */
	protected void setDisable(int i) {
		if (behavior != null)
			behavior.setDisable(i);
	}

	/**
	 * Deaktiviert alle Interpolatoren.
	 * @see PacmanRoomSceneBehavior#setDisable(int i)
	 * */
	protected void setAllDisable() {
		for (int i = 1; i < 4; i++) {
			behavior.setDisable(i);
		}
	}

	/**
	 * Setzt die Position des Betrachters.
	 * @param i Index der Position
	 * @see PacmanRoomSceneBehavior#setViewPos(int i)
	 * */
	protected void setViewPos(int i) {
		if (behavior != null)
			behavior.setViewPos(i);
	}

	/**
	 * TransformGroup, die den Pacman und seine drei Interpolatoren enthlt.
	 * @return TransformGroup
	 **/

	private TransformGroup pacmanToCredits() {

		// Wurzel
		TransformGroup pacmanMotionTG = new TransformGroup();
		pacmanMotionTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);

		// Pacman
		Transform3D trans = new Transform3D();
		Transform3D scale = new Transform3D();
		trans.set(new Vector3f(0.0f, 3.0f, 0.0f));
		scale.setScale(7.0);
		trans.mul(scale);
		TransformGroup loadPacmanTG = new TransformGroup(trans);
		loadPacmanTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);

		loadPacmanTG.addChild(
			new pacman3d.pacman.animation.PacmanObjTrans(
				"./models/pacman/body_low.wrl",
				true,
				false));

		TransformGroup pacmanTG = new TransformGroup();
		pacmanTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		pacmanTG.addChild(loadPacmanTG);

		pacmanMotionTG.addChild(pacmanTG);

		Transform3D yAxis = new Transform3D();

		// Interpolator1 - von Bruecke zu Menu
			alpha1 =
				new Alpha(-1, Alpha.INCREASING_ENABLE | Alpha.DECREASING_ENABLE, 0, 0, //40000,
	17000, 0, 0, 0, 0, 0);

		float[] float_array = { 0.0f, 0.3f, 0.7f, 1.0f };
		Quat4f[] quats_array = new Quat4f[4];
		quats_array[0] = new Quat4f(0.0f, 0.0f, 0.0f, 0.0f);
		quats_array[1] = new Quat4f(0.0f, 0.0f, 0.0f, 0.0f);
		quats_array[2] = new Quat4f(0.0f, 0.0f, 0.0f, 0.0f);
		quats_array[3] = new Quat4f(0.0f, 0.0f, 0.0f, 0.0f);

		Point3f[] pos_array = new Point3f[4];
		pos_array[0] = new Point3f(0.0f, 0.0f, -10.0f);
		pos_array[1] = new Point3f(-1.5f, 0.0f, -3.0f);
		pos_array[2] = new Point3f(-20.0f, 0.0f, -37.0f);
		pos_array[3] = new Point3f(-3.0f, 0.0f, -63.0f);

		rotPosPathInt1 =
			new RotPosPathInterpolator(
				alpha1,
				pacmanTG,
				yAxis,
				float_array,
				quats_array,
				pos_array);

		rotPosPathInt1.setSchedulingBounds(Defaults.BIG_BOUNDS);
		rotPosPathInt1.setEnable(false);
		pacmanMotionTG.addChild(rotPosPathInt1);

		// Interpolator2 - von Credits zu Menu
			alpha2 =
				new Alpha(-1, Alpha.INCREASING_ENABLE | Alpha.DECREASING_ENABLE, 0, 0, //40000,
	8000, 0, 0, 0, 0, 0);

		float[] float_array2 = { 0.0f, 1.0f };
		Quat4f[] quats_array2 = new Quat4f[2];
		quats_array2[0] = new Quat4f(0.0f, 0.0f, 0.0f, 0.0f);
		quats_array2[1] = new Quat4f(0.0f, 0.0f, 0.0f, 0.0f);

		Point3f[] pos_array2 = new Point3f[2];
		pos_array2[0] = new Point3f(-19.0f, 0.0f, -45.0f);
		pos_array2[1] = new Point3f(-3.0f, 0.0f, -63.0f);

		rotPosPathInt2 =
			new RotPosPathInterpolator(
				alpha2,
				pacmanTG,
				yAxis,
				float_array2,
				quats_array2,
				pos_array2);

		rotPosPathInt2.setSchedulingBounds(Defaults.BIG_BOUNDS);
		rotPosPathInt2.setEnable(false);
		pacmanMotionTG.addChild(rotPosPathInt2);

		// Interpolator3 - von Menu zu Credits
			alpha3 =
				new Alpha(-1, Alpha.INCREASING_ENABLE | Alpha.DECREASING_ENABLE, 0, 0, //40000,
	10000, 0, 0, 0, 0, 0);

		float[] float_array3 = { 0.0f, 1.0f };
		Quat4f[] quats_array3 = new Quat4f[2];

		//0: 0,0,0,0 und 1: 0.7,0,0,0 -> mehrere Interpolatoren werden ausgeloest, Pacman springt hin und her
		quats_array3[0] = new Quat4f(0.0f, 0.1f, 0.0f, 0.0f);
		quats_array3[1] = new Quat4f(0.0f, 0.1f, 0.0f, 0.0f);

		Point3f[] pos_array3 = new Point3f[2];
		pos_array3[0] = new Point3f(-3.0f, 0.0f, -63.0f);
		pos_array3[1] = new Point3f(-19.0f, 0.0f, -45.0f);

		rotPosPathInt3 =
			new RotPosPathInterpolator(
				alpha3,
				pacmanTG,
				yAxis,
				float_array3,
				quats_array3,
				pos_array3);

		rotPosPathInt3.setSchedulingBounds(LITTLE_BOUNDS);
		rotPosPathInt3.setEnable(false);
		pacmanMotionTG.addChild(rotPosPathInt3);

		// Behavior zum Steuern der Pacman-Bewegungen
		behavior = new PacmanRoomSceneBehavior(su, this);
		pacmanMotionTG.addChild(behavior);

		return pacmanMotionTG;
	}

	/**
	 * Aktivierte oder deaktiviert den bergebenen Interpolator. Je nach dem, ob er gerade
	 * inaktiv oder aktiv ist.
	 * @param i Interpolatorindex
	 * */
	protected void setRotPosPathInterpolator(int i) {
		Debug.out(
			getClass().getName(),
			"setRotPosPathInterpolator(" + i + ")",
			Debug.LEVEL_NOTICE);
		switch (i) {
			case 1 :
				rotPosPathInt1.setEnable(true);
				break;

			case 2 :
				rotPosPathInt2.setEnable(true);
				break;

			case 3 :
				rotPosPathInt3.setEnable(true);
				break;
		}
	}

	/**
	 * Hilfsmethode fuer den 2D-Text (Java 2D Text)
	 * @param name Textstring
	 * @param vector Postitionierungsvektor
	 * @return TransformGroup
	 * */
	private TransformGroup creditsName(String name, Vector3f vector) {
		Transform3D nameGroesse = new Transform3D();
		nameGroesse.setScale(2.5);
		Transform3D nameRot = new Transform3D();
		nameRot.rotY(Math.PI / 2.7d);
		nameRot.mul(nameGroesse);
		Transform3D namePacmanTrans = new Transform3D();

		namePacmanTrans.set(vector);
		namePacmanTrans.mul(nameRot);
		TransformGroup namePacmanTG = new TransformGroup(namePacmanTrans);

		Text2D pacman =
			new Text2D(name, Defaults.COLOR_WHITE, "Helvetica", 60, Font.PLAIN);
		namePacmanTG.addChild(pacman);

		return namePacmanTG;
	}

	/**
	 * Hilfsmethode fuer den Credits-Switch (Text als 3ds-Datei)
	 * @param credits TransformGroup die Java 2D Text enthlt
	 * @param symbolFile 3ds-Datei
	 * */
	private TransformGroup switchCreditsJava(
		TransformGroup credits,
		String symbolFile) {
		TransformGroup targetTG = new TransformGroup();
		targetTG.addChild(credits);
		targetTG.addChild(Intro.loadTGfrom3DS(symbolFile));
		return targetTG;
	}

	/**
	 * Raumszene ohne Menu und Pacman
	 * @return TransformGroup
	 * */
	public TransformGroup createRoom() {

		TransformGroup objRoot = new TransformGroup();

		// Raum-Objekte laden
		TransformGroup raumTG = new TransformGroup();
		raumTG.addChild(Intro.loadTGfrom3DS("scene_menu_back.3ds"));
		raumTG.addChild(Intro.loadTGfrom3DS("scene_menu_title.3ds"));
		raumTG.addChild(Intro.loadTGfrom3DS("scene_wand_dach.3ds"));
		raumTG.addChild(Intro.loadTGfrom3DS("scene_boden.3ds"));
		raumTG.addChild(Intro.loadTGfrom3DS("scene_credits_tisch.3ds"));
		raumTG.addChild(Intro.loadTGfrom3DS("scene_credits_agcLogo.3ds"));

		objRoot.addChild(raumTG);

		// Hinweis: zurueck zum Menue
		raumTG.addChild(
			creditsName("Zurueck zum Menue: F1 ", new Vector3f(-29.0f, 5.5f, -42.0f)));

		// Team Namen
		TransformGroup namePacman = new TransformGroup();
		namePacman.addChild(
			creditsName(".....Pacman Gruppe.....", new Vector3f(-29.0f, 11.5f, -42.0f)));
		namePacman.addChild(
			creditsName("Jihua Xu ", new Vector3f(-29.0f, 10.5f, -41.0f)));
		namePacman.addChild(
			creditsName("Christoph Karwoth ", new Vector3f(-29.0f, 9.5f, -41.0f)));
		namePacman.addChild(
			creditsName("Frank Bergmann ", new Vector3f(-29.0f, 8.5f, -41.0f)));

		TransformGroup nameMonster = new TransformGroup();
		nameMonster.addChild(
			creditsName(".....Monster Gruppe.....", new Vector3f(-29.0f, 11.5f, -42.0f)));
		nameMonster.addChild(
			creditsName("Katharina Kinder ", new Vector3f(-29.0f, 10.5f, -41.0f)));
		nameMonster.addChild(
			creditsName("Rolf Theisinger ", new Vector3f(-29.0f, 9.5f, -41.0f)));
		nameMonster.addChild(
			creditsName("Thomas Paes ", new Vector3f(-29.0f, 8.5f, -41.0f)));

		TransformGroup nameLabyrinth = new TransformGroup();
		nameLabyrinth.addChild(
			creditsName(".....Labyrinth Gruppe.....", new Vector3f(-29.0f, 11.5f, -42.0f)));
		nameLabyrinth.addChild(
			creditsName("Lijun Zhou ", new Vector3f(-29.0f, 10.5f, -41.0f)));
		nameLabyrinth.addChild(
			creditsName("Gordon Weckbach ", new Vector3f(-29.0f, 9.5f, -41.0f)));
		nameLabyrinth.addChild(
			creditsName("Fabian Wleklinski ", new Vector3f(-29.0f, 8.5f, -41.0f)));
		nameLabyrinth.addChild(
			creditsName("Martin Klossek ", new Vector3f(-29.0f, 7.5f, -41.0f)));
		nameLabyrinth.addChild(
			creditsName("Paul Izquierdo Rojas ", new Vector3f(-29.0f, 6.5f, -41.0f)));

		TransformGroup nameKamera = new TransformGroup();
		nameKamera.addChild(
			creditsName(".....Kamera Gruppe.....", new Vector3f(-29.0f, 11.5f, -42.0f)));
		nameKamera.addChild(
			creditsName("Armin Burger ", new Vector3f(-29.0f, 10.5f, -41.0f)));
		nameKamera.addChild(
			creditsName("Paul Izquierdo Rojas ", new Vector3f(-29.0f, 9.5f, -41.0f)));

		TransformGroup nameIntro = new TransformGroup();
		nameIntro.addChild(
			creditsName(
				".....Netz&Intro Gruppe.....",
				new Vector3f(-29.0f, 11.5f, -42.0f)));
		nameIntro.addChild(
			creditsName("Marina Tzanova ", new Vector3f(-29.0f, 10.5f, -41.0f)));
		nameIntro.addChild(
			creditsName("Christian Balzer  ", new Vector3f(-29.0f, 9.5f, -41.0f)));
		nameIntro.addChild(
			creditsName("Nicole Kaiser ", new Vector3f(-29.0f, 8.5f, -41.0f)));

		// Credits anzeigen
		Switch creditsSW = new Switch();
		creditsSW.setCapability(Switch.ALLOW_SWITCH_WRITE);
		creditsSW.setCapability(Switch.ALLOW_SWITCH_READ);
		creditsSW.setBounds(Defaults.BIG_BOUNDS);
		creditsSW.addChild(switchCreditsJava(namePacman, "scene_credits_pacman.3ds"));
		creditsSW.addChild(
			switchCreditsJava(nameLabyrinth, "scene_credits_labyrinth.3ds"));
		creditsSW.addChild(switchCreditsJava(nameMonster, "scene_credits_monster.3ds"));
		creditsSW.addChild(switchCreditsJava(nameKamera, "scene_credits_kamera.3ds"));
		creditsSW.addChild(switchCreditsJava(nameIntro, "scene_credits_laptop.3ds"));
		objRoot.addChild(creditsSW);

		// Credits wechseln
		Alpha creditsAlpha = new Alpha(-1, CREDITS_SWITCH_TIME);
		SwitchValueInterpolator creditsInp =
			new SwitchValueInterpolator(creditsAlpha, creditsSW);
		creditsInp.setSchedulingBounds(
			new BoundingSphere(new Point3d(8.0d, 8.0d, -31.0d), 1.0d));
		objRoot.addChild(creditsInp);

		// Licht

		Transform3D t3d = new Transform3D();
		t3d.set(new Vector3f(0.0f, 5.0f, 5.0f));
		TransformGroup directLights = new TransformGroup(t3d);
		objRoot.addChild(directLights);

		DirectionalLight dLight1 =
			new DirectionalLight(Defaults.COLOR_GREY1, new Vector3f(0.0f, 20.0f, -60.0f));
		dLight1.setInfluencingBounds(Defaults.BIG_BOUNDS);
		directLights.addChild(dLight1);

		DirectionalLight dLight2 =
			new DirectionalLight(Defaults.COLOR_GREY1, new Vector3f(0.0f, -20.0f, 0.0f));
		dLight2.setInfluencingBounds(Defaults.BIG_BOUNDS);
		directLights.addChild(dLight2);

		objRoot.addChild(pacmanToCredits());

		return objRoot;
	}

	/**
	 * Gibt Interpolator1 zurueck.
	 * @return Interpolator1
	 */
	public RotPosPathInterpolator getRotPosPathInt1() {
		return rotPosPathInt1;
	}

	/**
	 * Gibt Interpolator2 zurueck.
	 * @return Interpolator2
	 */
	public RotPosPathInterpolator getRotPosPathInt2() {
		return rotPosPathInt2;
	}

	/**
	 * Gibt Interpolator3 zurueck.
	 * @return Interpolator2
	 */
	public RotPosPathInterpolator getRotPosPathInt3() {
		return rotPosPathInt3;
	}

}