package pacman3d.intro;

import javax.media.j3d.*;
import javax.vecmath.*;
import java.awt.Font;

/**
 * <b>Title:</b> Java3D-Praktikum - Pacman3D</br>
 * <b>Description:</b><br>
 *
 * MenuEntry mit Funktion zum Aktivieren und Deaktivieren (Textfarbe wird ge&auml;ndert.)
 * <br>
 *
 * <b>Copyright:</b>	Copyright (c) 2002<br>
 *
 * @author              Netz+Intro<br>
 */
public class MenuEntry_TextItem implements MenuEntry {

	// ist Eintrag im Menue aktiviert ?
	protected boolean isActive = true;
	
	// Text des Eintrags
	protected String string;	
	
	// Default-Position des Eintrags
	protected Point3f pos = new Point3f(0.0f,0.0f,0.0f);
	
	// Java3D-Objekte des Eintrags
	private Text3D text3d = null;
	private Shape3D shape = null;
	private Appearance app = null;

	/**
	 * Erzeugt einen "navigierbaren" Men&uuml;eintrag.
	 * 
	 * @param string Texteintrag
	 * @param pos Startposition des Textes
	 * @param isActive als Aktiv markieren ?
	 */
	public MenuEntry_TextItem(String string, Point3f pos, boolean isActive){
		this.string = string;
		this.pos = pos;
		this.isActive = isActive;
		shape = new Shape3D();
		shape.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
		shape.setCapability(Shape3D.ALLOW_APPEARANCE_READ);
		text3d = new Text3D(Defaults.MENU_FONT3D, string, pos);
		shape.setGeometry(text3d);
		app = new Appearance();
		app.setCapability(Appearance.ALLOW_MATERIAL_WRITE);
		app.setCapability(Appearance.ALLOW_MATERIAL_READ);
		shape.setAppearance(app);
		setActive(isActive);
	}

	/**
	 * Erzeugt einen "navigierbaren" Men&uuml;eintrag an Position (0,0,0)
	 * mit inaktiven Zustand.
	 * 
	 * @param string Texteintrag
	 */
	public MenuEntry_TextItem(String string){
		this(string, new Point3f(0.0f,0.0f,0.0f),true);
	}
	
	/**
	 * Aktiviert bzw. deaktiviert Eintrag &uuml;ber Textfarbe.
	 * 
	 * @param active Eintrag aktiviert?
	 */
	public void setActive(boolean active){
		isActive = active;
		if (active) shape.getAppearance().setMaterial(Defaults.LIGHTGREEN_MATERIAL);
			else shape.getAppearance().setMaterial(Defaults.GRAY_MATERIAL);
	}
	
	/**
	 * Methode gibt Java3D-Objekt des Menn&uuml;eintrages zur&uuml;ck.
	 * 
	 * @return Java3D-Repr&auml;sentation des MenuEntrys
	 */
	public Node getNode(){
		return shape;
	}
	
	public String getString(){
		return string;	
	}

	/**
	 * Erzeugt Kopie des <i>MenuEntry</i>-Objekts.
	 * 
	 * @return Instanz des geklonten <i>MenuEntry</i>-Objekts.
	 */
	public Object cloneEntry(){
		return new MenuEntry_TextItem(new String(string), new Point3f(pos), isActive);	
	}

	/**
	 * Liefert den Typ der aktuellen Klasse als <i>Class</i>-Objekt.
	 * 
	 * @return Typ der Klasse
	 */		
	public Class getTyp(){ return MenuEntry_TextItem.class; }

}
