package pacman3d.intro;

import javax.media.j3d.*;
import javax.vecmath.*;
import java.awt.Font;

/**
 * <b>Title:</b> Java3D-Praktikum - Pacman3D</br>
 * <b>Description:</b><br>
 *
 * Einfacher Texteintrag mit Funktion zum &Auml;ndern des Textstrings.
 * <br>
 *
 * <b>Copyright:</b>	Copyright (c) 2002<br>
 *
 * @author              Netz+Intro<br>
 */
public class MenuEntry_SimpleText implements MenuEntry {

	// Text-String
	protected String string;

	// Default-Startposition
	protected Point3f pos = new Point3f(0.0f, 0.0f, 0.0f);

	// Text-3D-Objekt und Eigenschaftsobjekte
	private Text3D text3d = null;
	private Shape3D shape = null;
	private Appearance app = null;

	/**
	 * Erzeugt MenuEntry_SimpleText.
	 * 
	 * @param string anzuzeigender Text-String
	 * @param pos Startposition des Strings
	 */
	public MenuEntry_SimpleText(String string, Point3f pos) {
		this.string = string;
		this.pos = pos;
		shape = new Shape3D();
		text3d = new Text3D(Defaults.MENU_FONT3D, string, pos);
		text3d.setCapability(Text3D.ALLOW_STRING_WRITE);
		text3d.setCapability(Text3D.ALLOW_STRING_READ);
		shape.setGeometry(text3d);
		app = new Appearance();
		app.setMaterial(Defaults.RED_MATERIAL);
		shape.setAppearance(app);
	}

	/**
	 * Erzeugt MenuEntry_SimpleText. an Position (0,0,0)
	 * 
	 * @param string anzuzeigender Text-String
	 */
	public MenuEntry_SimpleText(String string) {
		this(string, new Point3f(0.0f, 0.0f, 0.0f));
	}

	/**
	 * Methode gibt Java3D-Objekt des Menn&uuml;eintrages zur&uuml;ck.
	 * 
	 * @return Java3D-Repr&auml;sentation des MenuEntrys
	 */
	public Node getNode() {
		return shape;
	}

	/**
	 * Erzeugt Kopie des <i>MenuEntry</i>-Objekts.
	 * 
	 * @return Instanz des geklonten <i>MenuEntry</i>-Objekts.
	 */
	public Object cloneEntry() {
		return new MenuEntry_SimpleText(new String(string), pos);

	}

	/**
	 * Liefert Text-String des Objektes zur&uuml;ck
	 * 
	 * @return Text-String
	 */
	public String getString() {
		return string;
	}

	/**
	 * Setzt Text-String des Objektes
	 * 
	 * @param s Text-String, der angezeigt werden soll
	 */
	public void setString(String s) {
		if (s != null)
			string = s;
		text3d.setString(string);
	}

	/**
	 * Liefert den Typ der aktuellen Klasse als <i>Class</i>-Objekt.
	 * 
	 * @return Typ der Klasse
	 */
	public Class getTyp() {
		return MenuEntry_SimpleText.class;
	}

}