package pacman3d.intro;

import javax.media.j3d.*;
import javax.vecmath.*;
import java.awt.Font;
import java.util.Vector;

import pacman3d.util.*;
import pacman3d.labyrinth.*;
import pacman3d.pacman.*;

/**
 * <b>Title:</b> Java3D-Praktikum - Pacman3D</br>
 * <b>Description:</b><br>
 *
 * Zeigt die verf&uuml;gbaren Pacmans zum Ausw&auml;hlen an.
 * <br>
 *
 * <b>Copyright:</b>  Copyright (c) 2002<br>
 *
 * @author              Netz+Intro<br>
 */
public class MenuEntry_SelectPacman implements MenuEntry {

  // zeigt fehlermeldung oder pacmanliste
  private Switch pcmSW = new Switch(0);

  // eintragscontainer
  private Appearance app = new Appearance();
  private Text3D string = null;

  // pacmanliste
  private Vector vPacmans = null;
  // aktuelle position im vektor
  private int pcmPos = 0;

  // initialize schon aufgerufen
  private boolean initDone = false;

   // speilmodus. default - true
  private boolean friendly = true;
  

  public MenuEntry_SelectPacman() {
     this(null);
  }
  /**
   * Dieser Konstruktor &uuml;bergibt leere Pacmanliste an seinen Kollegen :-)
   * 
   * @param pcl Vektor mit Pacman-Modell-Namen
   */
  public MenuEntry_SelectPacman(Vector pcl) {
    
    vPacmans = pcl;
    // init switch
    pcmSW = new Switch(0);
    pcmSW.setCapability(Switch.ALLOW_SWITCH_WRITE);
    pcmSW.setCapability(Switch.ALLOW_SWITCH_READ);
    pcmSW.setBounds(Defaults.BIG_BOUNDS);

    // add "no pacmans found" message
    Shape3D shape = new Shape3D();
    shape.setGeometry(
      new Text3D(
        Defaults.MENU_FONT3D,
        "Keine Pacmans gefunden!!! ",
        new Point3f(0.0f, -1.5f, 0.0f)));
    // child 0
    pcmSW.addChild(shape);

    // add pacman shapes
    TransformGroup tg = new TransformGroup();
    app.setMaterial(Defaults.GRAY_MATERIAL);
    
    Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    string = new Text3D(Defaults.MENU_FONT3D, "", position);
    string.setCapability(Text3D.ALLOW_STRING_WRITE);
    string.setCapability(Text3D.ALLOW_STRING_READ);
    Shape3D shape2 = new Shape3D();
    shape2.setAppearance(app);
    shape2.setGeometry(string);
    tg.addChild(shape2);
    // child 1
    pcmSW.addChild(tg);
  }

  /**
   * Holt die Pacmanliste in Form eines Pacman-Vektors beim PacmanHandler. Falls dieser Vektor Elemente
   * enth&auml;lt, werden diese angezigt, sonst eine Fehlermeldung.
   */
  public void initialize() {

    if (!initDone) {
      // pacmans holen, falls noetig
      if (vPacmans == null)
        vPacmans = Pacman.getModelList(); //holt die verfgbaren Pacmans
      // elemente vorhanden?
      if (vPacmans == null || vPacmans.size() == 0) {
        // upps. keine pacmans vorhanden -> Fehlermeldung
        pcmSW.setWhichChild(0);
      } else {
        // pacmans vorhanden
        pcmSW.setWhichChild(1);
        showPacmanInfo((String)vPacmans.elementAt(pcmPos));
      }
      initDone = true;
    }
  }
  /**
   * Geht im Vektor eine Position zur&uuml;ck und zeigt diese Pacmaninfos an.
   */
  public void backward() {
    if (vPacmans.size() == 0 || pcmPos < 1)
      return;
    if (!initDone)
      initialize();
    // info -> 3D
    if (vPacmans.elementAt(pcmPos - 1) instanceof String) {
      showPacmanInfo((String) vPacmans.elementAt(--pcmPos));
    }
  }

  /**
   * Geht im Vektor eine Position weiter und zeigt diese Pacmaninfos an.
   */
  public void forward() {
    if (vPacmans.size() == 0 || pcmPos == vPacmans.size() - 1)
      return;
    if (!initDone)
      initialize();
    // info -> 3D
    if (vPacmans.elementAt(pcmPos + 1) instanceof String) {
      showPacmanInfo((String) vPacmans.elementAt(++pcmPos));
    }
  }

  /**
   * Ersetzt die Pacmaninfoeintr&auml;ge durch die neu gew&auml;hlten.
   */
  private void showPacmanInfo(String pName) {
    if (pName != null) {
      string.setString(pName);
    } else
      System.out.println("ERROR IN PACMAN_INFO (testmeldung).");
  }

	/**
	 * Methode gibt Java3D-Objekt des Menn&uuml;eintrages zur&uuml;ck.
	 * 
	 * @return Java3D-Repr&auml;sentation des MenuEntrys
	 */
  public Node getNode() {
    return pcmSW;
  }

  /**
   * Liefert das gew&auml;hlten Pacman zur&uuml;ck.
   */
  public String getSelectedPacmanModel() {
    return (String)vPacmans.elementAt(pcmPos);
  }

  /**
   * Speichert den Spielmodus des Pacmans.
   */
  public void selectSpielModus(boolean friendly) {
    this.friendly = friendly;
  }
  
  /**
   * Gibt den Spielmodus des Pacmans zurck.
   */
  public boolean getSelectedSpielModus() {
    return friendly;
  }



 /**
  * Erzeugt Kopie des <i>MenuEntry</i>-Objekts.
  * 
  * @return Instanz des geklonten <i>MenuEntry</i>-Objekts.
  */
  public Object cloneEntry() {
    return new MenuEntry_SelectPacman(vPacmans);
  }

	/**
	 * Liefert den Typ der aktuellen Klasse als <i>Class</i>-Objekt.
	 * 
	 * @return Typ der Klasse
	 */	
  public Class getTyp() {
    return MenuEntry_SelectPacman.class;
  }

}