package pacman3d.intro;

import javax.media.j3d.*;
import javax.vecmath.*;
import java.awt.Font;
import java.util.Vector;

import pacman3d.util.*;
import pacman3d.labyrinth.*;

/**
 * <b>Title:</b> Java3D-Praktikum - Pacman3D</br>
 * <b>Description:</b><br>
 *
 * Zeigt die verf&uuml;gbaren Levels zum Ausw&auml;hlen an.
 * <br>
 *
 * <b>Copyright:</b>	Copyright (c) 2002<br>
 *
 * @author              Netz+Intro<br>
 */
public class MenuEntry_LevelInfo implements MenuEntry {

	// maximale string-laenge fuer level-infos
	private int maxLength = 25;

	// zeigt fehlermeldung oder levelliste
	private Switch lvlSW = new Switch(0);

	// eintragscontainer
	private Appearance app = new Appearance();
	private Shape3D[] shapes = new Shape3D[4];
	private Point3f[] positions = new Point3f[4];
	private Text3D[] strings = new Text3D[4];

	// levelliste
	private Vector vLevels = null;
	// aktuelle position im vektor
	private int levPos = 0;

	// initialize schon aufgerufen
	private boolean initDone = false;

	/**
	 * Dieser Konstruktor &uuml;bergibt leere Levelliste an seinen Kollegen :-)
	 */
	public MenuEntry_LevelInfo() {
		this(null);
	}


	/**
	 * Konstruktor erzeugt Switch mit Fehlermeldung und Levelliste.
	 * 
	 * @param lmi Vektor mit verf&uuml;gbaren Levels
	 */
	public MenuEntry_LevelInfo(Vector lmi) {

		// level setzen (im falle eines cloneSlice())
		vLevels = lmi;

		// init switch
		lvlSW = new Switch(0);
		lvlSW.setCapability(Switch.ALLOW_SWITCH_WRITE);
		lvlSW.setCapability(Switch.ALLOW_SWITCH_READ);
		lvlSW.setBounds(Defaults.BIG_BOUNDS);

		// add "no levels found" message
		Shape3D shape = new Shape3D();
		shape.setGeometry(
			new Text3D(
				Defaults.MENU_FONT3D,
				"Keine Levels gefunden!!! ",
				new Point3f(0.0f, -1.5f, 0.0f)));
		// child 0
		lvlSW.addChild(shape);

		// add level shapes
		TransformGroup tg = new TransformGroup();
		app.setMaterial(Defaults.GRAY_MATERIAL);
		for (int i = 0; i < shapes.length; i++) {
			positions[i] = new Point3f(0.0f, (-i * 1.5f), 0.0f);
			strings[i] = new Text3D(Defaults.MENU_FONT3D, "", positions[i]);
			strings[i].setCapability(Text3D.ALLOW_STRING_WRITE);
			strings[i].setCapability(Text3D.ALLOW_STRING_READ);
			shapes[i] = new Shape3D();
			shapes[i].setAppearance(app);
			shapes[i].setGeometry(strings[i]);
			tg.addChild(shapes[i]);
		}
		// child 1
		lvlSW.addChild(tg);
	}

	/**
	 * Holt die Levelliste in Form eines LevelMetaInfo-Vektors beim LevelHandler. Falls dieser Vektor Elemente
	 * enth&auml;lt, werden diese angezigt, sonst eine Fehlermeldung.
	 */
	public void initialize() {

		if (!initDone) {
			// level holen, falls noetig
			if (vLevels == null)
				vLevels = new LevelHandler().getLevels(); //holt die verfgbaren Levels
			// elemente vorhanden?
			if (vLevels == null || vLevels.size() == 0) {
				// upps. keine levels vorhanden -> Fehlermeldung
				lvlSW.setWhichChild(0);
			} else {
				// levels vorhanden
				lvlSW.setWhichChild(1);
				showLevelInfo((LevelMetaInfo) vLevels.elementAt(levPos));
			}
			initDone = true;
		}
	}

	/**
	 * Geht im Vektor eine Position zur&uuml;ck und zeigt diese Levelinfos an.
	 */
	public void backward() {
		if (vLevels.size() == 0 || levPos < 1)
			return;
		//cba: vorsichtshalber
		if (!initDone)
			initialize();
		// info -> 3D
		if (vLevels.elementAt(levPos - 1) instanceof LevelMetaInfo) {
			showLevelInfo((LevelMetaInfo) vLevels.elementAt(--levPos));
		}
	}

	/**
	 * Geht im Vektor eine Position weiter und zeigt diese Levelinfos an.
	 */
	public void forward() {
		if (vLevels.size() == 0 || levPos == vLevels.size() - 1)
			return;
		if (!initDone)
			initialize();
		// info -> 3D
		if (vLevels.elementAt(levPos + 1) instanceof LevelMetaInfo) {
			showLevelInfo((LevelMetaInfo) vLevels.elementAt(++levPos));
		}
	}

	/**
	 * Ersetzt die Levelinfoeintr&auml;ge durch die neu gew&auml;hlten.
	 */
	private void showLevelInfo(LevelMetaInfo lmInfo) {
		if (lmInfo != null) {
			// title
			strings[0].setString(
				lmInfo.getTitle().length() > maxLength
					? lmInfo.getTitle().substring(0, maxLength)
					: lmInfo.getTitle());
			// mission		
			strings[1].setString(
				lmInfo.getMission().length() > maxLength
					? lmInfo.getMission().substring(0, maxLength)
					: lmInfo.getMission());
			// version
			strings[2].setString(
				lmInfo.getVersion().length() > maxLength
					? lmInfo.getVersion().substring(0, maxLength)
					: lmInfo.getVersion());
			// date
			strings[3].setString(
				lmInfo.getDate().length() > maxLength
					? lmInfo.getDate().substring(0, maxLength)
					: lmInfo.getDate());
		} else
			System.out.println("ERROR IN LEVEL_INFO (testmeldung).");
	}

	/**
	 * Methode gibt Java3D-Objekt des Menn&uuml;eintrages zur&uuml;ck.
	 * 
	 * @return Java3D-Repr&auml;sentation des MenuEntrys
	 */
	public Node getNode() {
		return lvlSW;
	}

	/**
	 * Liefert das LevelMetaInfo-Objekt des gew&auml;hlten Levels zur&uuml;ck.
	 */
	public LevelMetaInfo getLevelInfo() {
		return (LevelMetaInfo) vLevels.elementAt(levPos);
	}

	/**
	 * Erzeugt Kopie des <i>MenuEntry</i>-Objekts.
	 * 
	 * @return Instanz des geklonten <i>MenuEntry</i>-Objekts.
	 */
	public Object cloneEntry() {
		return new MenuEntry_LevelInfo(vLevels);
	}

	/**
	 * Liefert den Typ der aktuellen Klasse als <i>Class</i>-Objekt.
	 * 
	 * @return Typ der Klasse
	 */	
	public Class getTyp() {
		return MenuEntry_LevelInfo.class;
	}

}