package pacman3d.intro;

import javax.media.j3d.Appearance;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.vecmath.Point3f;

/**
 * <b>Title:</b> Java3D-Praktikum - Pacman3D</br>
 * <b>Description:</b><br>
 *
 * Angepasster SimpleText-Eintrag, der nur "Ja" oder "Nein" darstellen kann
 * <br>
 *
 * <b>Copyright:</b>	Copyright (c) 2002<br>
 *
 * @author              Netz+Intro<br>
 */
public class MenuEntry_JaNeinSimpleText extends MenuEntry_SimpleText {

	// Status: Ja oder Nein
	private boolean state = false;
	
	/**
	 * Erzeugt MenuEntry_JaNeinSimpleText.
	 * 
	 * @param length maximale Eingabel&auml;nge
	 * @param shape_pos Startposition des Strings
	 */	
	public MenuEntry_JaNeinSimpleText(Point3f pos, boolean isActive) {
		super((isActive ? "Ja " : "Nein "), pos);
		state = isActive;	
	}

	/**
	 * &Auml;ndert den Status von Ja auf Nein und umgekehrt.
	 */
	public void changeState() {
		state = !state;
		if (state)
			setString("Ja ");
		else
			setString("Nein");
	}

	/**
	 * Gibt aktuellen Status (Ja -> true oder Nein -> false) zur&uuml;ck
	 * 
	 * @return aktuellen Status
	 */
	public boolean getState() {
		return state;
	}

	/**
	 * Methode gibt Java3D-Objekt des Menn&uuml;eintrages zur&uuml;ck.
	 * 
	 * @return Java3D-Repr&auml;sentation des MenuEntrys
	 */
	public Node getNode(){
		Shape3D shape = (Shape3D) super.getNode();
		shape.getAppearance().setMaterial(Defaults.GRAY_MATERIAL);
		return shape;
	}

	/**
	 * Erzeugt Kopie des <i>MenuEntry</i>-Objekts.
	 * 
	 * @return Instanz des geklonten <i>MenuEntry</i>-Objekts.
	 */
	public Object cloneEntry() {
		return new MenuEntry_JaNeinSimpleText(new Point3f(pos), state);

	}

	/**
	 * Liefert den Typ der aktuellen Klasse als <i>Class</i>-Objekt.
	 * 
	 * @return Typ der Klasse
	 */	
	public Class getTyp() {
		return MenuEntry_JaNeinSimpleText.class;
	}
}