package pacman3d.intro;

import javax.media.j3d.*;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import java.awt.Font;
import java.awt.event.KeyEvent;

/**
 * <b>Title:</b> Java3D-Praktikum - Pacman3D</br>
 * <b>Description:</b><br>
 *
 * Einfaches Eingabefeld fr beliebige Zahlen,Buchstaben und Sonderzeichen.
 * <br>
 *
 * <b>Copyright:</b>	Copyright (c) 2002<br>
 *
 * @author              Netz+Intro<br>
 */
public class MenuEntry_InputField implements MenuEntry {

	// StringBuffer enthaelt eigegebene Zeichen
	protected StringBuffer sb = new StringBuffer();
	
	// Laenge des eingegebenen Strings
	protected int length = 0;
	
	// Startposition des Textes
	protected static Point3f shape_pos = new Point3f(0.0f, 0.0f, 0.0f);
	
	// Text-3D-Objekt
	protected Text3D text3d = null;
	
	// j3d-container
	private Group group = new Group();
	
	// StringBuffer zum Setzen des Markierungssymbols
	protected StringBuffer marker = new StringBuffer();
	
	// Marker-3D-Objekt
	protected Text3D marker3d = null;

	/**
	 * Default-Konstruktor.<br>
	 * Erzeugt InputField an Position (0,0,0) und l&auml;sst 10 
	 * Eingabezeichen zu.
	 */
	public MenuEntry_InputField() {
		this(10, shape_pos);
	}


	/**
	 * Erzeugt InputField.
	 * 
	 * @param length maximale Eingabel&auml;nge
	 * @param shape_pos Startposition des Strings
	 */
	public MenuEntry_InputField(int length, Point3f shape_pos) {
		this.length = length;
		this.shape_pos = shape_pos;

		// create text3d
		text3d = new Text3D(Defaults.INPUT_FONT3D, "", shape_pos);
		text3d.setCapability(Text3D.ALLOW_STRING_WRITE);
		text3d.setCapability(Text3D.ALLOW_STRING_READ);

		// set up marker
		marker.insert(0, '-');
		// markers position
		Point3f ext = new Point3f(shape_pos);
		ext.add(new Point3f(0.0f, -0.5f, 0.0f));
		// marker text
		marker3d = new Text3D(Defaults.INPUT_FONT3D, marker.toString(), ext);
		marker3d.setCapability(Text3D.ALLOW_STRING_WRITE);
		marker3d.setCapability(Text3D.ALLOW_STRING_READ);

	}

	/**
	 * Methode gibt Java3D-Objekt des Menn&uuml;eintrages zur&uuml;ck.
	 * 
	 * @return Java3D-Repr&auml;sentation des MenuEntrys
	 */
	public Node getNode() {

		// text3d
		Shape3D shape1 = new Shape3D();
		Appearance app1 = new Appearance();
		app1.setMaterial(Defaults.BLUE_MATERIAL);
		shape1.setAppearance(app1);
		shape1.setGeometry(text3d);
		group.addChild(shape1);

		// marker3d
		Shape3D shape2 = new Shape3D();
		Appearance app2 = new Appearance();
		app2.setMaterial(Defaults.GRAY_MATERIAL);
		shape2.setAppearance(app2);
		shape2.setGeometry(marker3d);
		group.addChild(shape2);

		return group;
	}


	/**
	 * F&uuml;gt eine Tastatureingabe dem <i>StringBuffer</i> hinzu.
	 * 
	 * @param keyCode Tastaturcode aus <i>KeyEvent</i>
	 */
	protected void addKey(int keyCode) {
		String s = KeyEvent.getKeyText(keyCode);
		if ((s.length() == 1) && (sb.length() < length)) {
			sb.append(s);
			text3d.setString(sb.toString());
			marker.insert(0," ");
			marker3d.setString(marker.toString());
		}
	}


	/**
	 * Entfernt eine Tastatureingabe aus dem <i>StringBuffer</i>.
	 */
	protected void removeKey() {
		if ((sb.toString().length() - 1) > -1) {
			int pos = sb.length() - 1;
			sb.deleteCharAt(sb.length() - 1);
			text3d.setString(sb.toString());
			if (marker.length() > 1) {
				marker.deleteCharAt(0);
				marker3d.setString(marker.toString());
			}
		}
	}

	/**
	 * L&ouml;scht den Inhalt des <i>StringBuffer</i>
	 */
	protected void clearString() {
		sb.delete(0, sb.length());
		text3d.setString(sb.toString());
		marker.delete(0, marker.length()-1);
		marker3d.setString(marker.toString());
	}

	/**
	 * Liefert den eingegebenen String.
	 * 
	 * @return eingegebenen String
	 */
	protected String getString() {
		return sb.toString();
	}

	/**
	 * Erzeugt Kopie des <i>MenuEntry</i>-Objekts.
	 * 
	 * @return Instanz des geklonten <i>MenuEntry</i>-Objekts.
	 */
	public Object cloneEntry() {
		return new MenuEntry_InputField(length, new Point3f(shape_pos));
	}
	
	/**
	 * Liefert den Typ der aktuellen Klasse als <i>Class</i>-Objekt.
	 * 
	 * @return Typ der Klasse
	 */	
	public Class getTyp(){ return MenuEntry_InputField.class; }

}