package pacman3d.intro;

import javax.media.j3d.*;
import javax.vecmath.Point3f;

/**
 * <b>Title:</b> Java3D-Praktikum - Pacman3D</br>
 * <b>Description:</b><br>
 *
 * Angepasstes InputField, um IP-Adresse eingeben zu k&ouml;nnen.
 * <br>
 *
 * <b>Copyright:</b>	Copyright (c) 2002<br>
 *
 * @author              Netz+Intro<br>
 */
public class MenuEntry_IPInputField extends MenuEntry_InputField {

	//Text3D fuer IP-Text
	protected Text3D ipText3d = null;
	
	// Gruppe mit allen Java3D-Objekten
	private Group group = new Group();

	/**
	 * Erzeugt IPInputField.
	 * 
	 * @param length maximale Eingabel&auml;nge
	 * @param shape_pos Startposition des Strings
	 */
	public MenuEntry_IPInputField(int length, Point3f shape_pos) {
		super(length, shape_pos);
		Point3f ipTextPos = new Point3f(shape_pos);
		ipTextPos.sub(new Point3f(1.7f, 0.0f, 0.0f));
		ipText3d = new Text3D(Defaults.MENU_FONT3D, "IP: ", ipTextPos);

	}

	/**
	 * Methode gibt Java3D-Objekt des Menn&uuml;eintrages zur&uuml;ck.
	 * 
	 * @return Java3D-Repr&auml;sentation des MenuEntrys
	 */
	public Node getNode() {

		group = (Group) super.getNode();

		// ipText
		Shape3D ipText = new Shape3D();
		Appearance app = new Appearance();
		app.setMaterial(Defaults.GRAY_MATERIAL);
		ipText.setAppearance(app);
		ipText.setGeometry(ipText3d);
		group.addChild(ipText);

		return group;

	}

	/**
	 * 
	 * &Uuml;berpr&uuml;ft String auf IP-Notation (X.X.X.X mit 0 >= X <= 255)
	 * 
	 * @param s zu &uuml;berpr&uuml;fender String
	 * @return enspricht String den IP-Koventionen
	 */
	public boolean isIPString(String s) {

		// min 7 zeichen, max 15 zeichen
		if ((s.length() < 7) || (s.length() > 15))
			return false;
		System.out.println(s);
		int currentPos = 0;
		String currByte = null;
		int pktPos = -1;
		// byte 1 - 3
		for (int i = 1; i <= 3; i++) {
			// liefert naechsten punkt
			pktPos = s.indexOf(".", currentPos);
			// vorhanden ?
			if (pktPos == -1)
				return false;
			// byte i ermitteln
			currByte = s.substring(currentPos, pktPos);
			// numberformatexception bei ".0" etc
			if (!isByteType(currByte))
				return false;
			// weiterspringen
			currentPos = pktPos + 1;
		}
		// byte 4
		currByte = s.substring(currentPos, s.length());
		if (!isByteType(currByte))
			return false;
		return true;
	}

	/**
	 * Testet, ob int-Repr&auml;sentation eines Strings zwischen 0 und 255 liegt.
	 * 
	 * @param s zu &uuml;berpr&uuml;fender String
	 * @return liegt String in int-Form zwischen 0 und 255
	 */
	private boolean isByteType(String s) {
		try {

			int i = Integer.valueOf(s).intValue();
			if ((i < 0) || (i > 255))
				return false;
			else
				return true;

		}
		catch (Exception ex) {
			return false;
		}
	}
	
	/**
	 * Erzeugt Kopie des <i>MenuEntry</i>-Objekts.
	 * 
	 * @return Instanz des geklonten <i>MenuEntry</i>-Objekts.
	 */
	public Object cloneEntry() {
		return new MenuEntry_IPInputField(length, new Point3f(shape_pos));
	}
	
	/**
	 * Liefert den Typ der aktuellen Klasse als <i>Class</i>-Objekt.
	 * 
	 * @return Typ der Klasse
	 */		
	public Class getTyp(){ return MenuEntry_IPInputField.class; }

}