package pacman3d.intro;

import java.util.Enumeration;
import java.util.Vector;

import javax.media.j3d.*;
import javax.vecmath.*;

/**
 * <b>Title:</b> Java3D-Praktikum - Pacman3D</br>
 * <b>Description:</b><br>
 *
 * Beh&auml;lter f&uuml;r MenuEntry-Objekte und MenuItems.<br>
 * 
 * Der Container enth&aauml;lt Slices, die wiederum MenuEntry-Objekte
 * enthalten. Jeder Slice repr&auml;sentiert ein navigierbares Men&uuml; und
 * jeder MenuEntry einen Eintrag.
 * <br>
 *
 * <b>Copyright:</b>	Copyright (c) 2002<br>
 *
 * @author              Netz+Intro<br>
 */
public class MenuContainer {

	// speichert pro slice einen vektor
	private Vector slices = new Vector();

	// nicht navigierbare eintraege
	private Vector additional = new Vector();

	// aktuelle slice- und entry-position
	private int currentSlice = -1;
	private int currentEntry = -1;

	// menu-Switch zum Slice-wechseln
	private Switch menuSW = new Switch();

	/**
	 * Default_Konstruktor. Erzeugt Menue-Container.
	 */
	public MenuContainer() {
		menuSW = new Switch();
		menuSW.setCapability(Switch.ALLOW_SWITCH_WRITE);
		menuSW.setCapability(Switch.ALLOW_SWITCH_READ);
		menuSW.setBounds(Defaults.BIG_BOUNDS);
	}

	/*
	 * 				S L I C E
	 */

	/**
	 * Neue Slice im Container anlegen.
	 * 
	 * @return die ID der Slice im Container
	 */
	protected int addSlice() {
		Vector slice = new Vector();
		slices.add(slice);
		int size = slices.size() - 1;
		if (currentSlice == -1) {
			currentSlice = size;
			menuSW.setWhichChild(0);
		}
		Vector add = new Vector();
		additional.add(add);
		return size;
	}

	/**
	 * Aktivierte Slice setzen.
	 * 
	 * @param hash die ID der zu aktivierenden Slice
	 */
	protected void setActiveSlice(int hash) {
		if ((hash < slices.size())
			&& (hash > -1)
			&& (slices.elementAt(hash) != null)) {
			removeCurrentEntry();
			currentSlice = hash;
			Vector v = (Vector) slices.elementAt(hash);
			if ((v.size() != 0) && (v.elementAt(0) != null))
				 ((MenuEntry_TextItem) v.elementAt(0)).setActive(true);
			currentEntry = 0;
			menuSW.setWhichChild(hash);
		}
	}

	/**
	 * Aktivierte Slice zur&uuml;ckgeben.
	 * 
	 * @return die ID der aktuell gesetzten Slice im Container
	 */
	public int getActiveSlice() {
		return currentSlice;
	}

	/**
	 * Methoden zum Klonen von Slices.
	 * 
	 * @param hash die zu klonende Slice
	 */
	public int cloneSlice(int hash) {
		if (hash > -1 && hash < slices.size() && slices.elementAt(hash) != null) {

			// slice mit textentries holen
			Vector v1 = (Vector) slices.elementAt(hash);
			Vector slice_dest = new Vector();
			Enumeration enum1 = v1.elements();
			// textitems klonen
			while (enum1.hasMoreElements()) {
				MenuEntry entry = (MenuEntry) ((MenuEntry) enum1.nextElement()).cloneEntry();
				slice_dest.add(entry);
			}
			slices.add(slice_dest);

			// additional entries holen
			Vector v2 = (Vector) additional.elementAt(hash);
			Vector add_dest = new Vector();
			Enumeration enum2 = v2.elements();
			// additionals klonen
			while (enum2.hasMoreElements()) {
				MenuEntry entry = (MenuEntry) ((MenuEntry) enum2.nextElement()).cloneEntry();
				add_dest.add(entry);
			}
			additional.add(add_dest);

			return slices.size() - 1;
		}
		return -1;
	}

	/*
	 * 				E N T R Y
	 */

	/**
	 * Standard Eintrag hinzuf&uuml;gen. Diese k&ouml;nnen &uuml;ber die Tastatur
	 * gewechselt (aktiviert) werden.
	 * 
	 * @param hash Zielslice
	 * @param string Textstring
	 * @param position Position auf der Slice
	 */
	protected int addItem(int hash, String string, Point3f position) {
		if (hash > -1 && hash < slices.size() && slices.elementAt(hash) != null) {
			Vector slice = (Vector) slices.elementAt(hash);
			MenuEntry_TextItem entry = new MenuEntry_TextItem(string, position, false);
			slice.add(entry);
			int pos = slice.size() - 1;
			if (currentEntry == -1) {
				entry.setActive(true);
				currentEntry = pos;
			}
			return pos;
		}
		return -1;
	}

	/**
	 * Aktivierten Entry zur&uuml;ckgeben.
	 * 
	 * @return als aktiv markierter Eintrag der aktuell gesetzen Slice
	 */
	protected int getActiveEntry() {
		return currentEntry;
	}

	/**
	 * Anzahl der Entryeintr&auml;ge der aktuellen Slice zur&uuml;ckgeben.
	 * 
	 * @return Anzahl der Entryeintr&auml;ge der aktuellen Slice zur&uuml;ckgeben.
	 */
	private int getEntryCount() {
		return ((Vector) slices.elementAt(currentSlice)).size() - 1;
	}

	/**
	 * Aktuell aktivierten Eintrag deaktivieren.
	 */
	private void removeCurrentEntry() {
		// aktuelle slice holen
		Vector v = (Vector) slices.elementAt(currentSlice);
		if (v.size() > 0)
			 ((MenuEntry_TextItem) v.elementAt(currentEntry)).setActive(false);
	}

	/**
	 * Einen Entry aktivieren.
	 * 
	 * @param pos ID des zu aktivierenden <i>MenuEntry_TextItem</i>
	 */
	protected void setActiveEntry(int pos) {

		// aktuelle slice holen
		Vector v = (Vector) slices.elementAt(currentSlice);

		// ist pos auch anwaehlbar?
		if ((pos < v.size()) && (pos > -1) && (v.elementAt(pos) != null)) {

			// alten eintrag deaktivieren
			 ((MenuEntry_TextItem) v.elementAt(currentEntry)).setActive(false);

			// okay, dann aktivieren
			 ((MenuEntry_TextItem) v.elementAt(pos)).setActive(true);

			// neuen entry als aktiv setzen
			currentEntry = pos;
		}
	}

	/**
	 * Aktiven Eintrag wechseln.
	 * true -> UP , false -> DOWN
	 * 
	 * @param orientation Orientierung des Eintragwechsels
	 */
	protected void changeEntry(boolean orientation) {
		int newEntry;
		// richtung
		if (orientation) {
			if (currentEntry - 1 < 0)
				newEntry = getEntryCount();
			else
				newEntry = currentEntry - 1;
		} else {
			if (currentEntry + 1 > getEntryCount())
				newEntry = 0;
			else
				newEntry = currentEntry + 1;
		}
		// eintrag auch setzen
		setActiveEntry(newEntry);
	}

	/*
	 * 			O T H E R - E N T R I E S
	 */

	/**
	 * Von MenuEntry-abgeleitete Klasse hinzuf&uuml;gen.
	 * 
	 * @param slice ID der Zielslice
	 * @param entry Instanz des <i>MenuEntry</i>-Objektes, welches hinzugef&uuml;gt wird
	 */
	protected void addEntry(int slice, MenuEntry entry) {
		if ((entry != null) && (slice > -1) && (slice < slices.size())) {
			Vector add = (Vector) additional.elementAt(slice);
			add.add(entry);
		}

	}

	/**
	 * Liefert Referenz auf den ersten Eintrag aus Vektor, der dem &uuml;bergebenen 
	 * Typ entspricht.
	 * 
	 * @param slice ID der Zielslice
	 * @param typ zu suchender Klassentyp
	 * @return gefundener <i>MenuEntry</i> oder <i>null</i>
	 */
	protected MenuEntry getEntryByClass(int slice, Class typ) {
		// prueft, ob additional-vector zu dieser slice vorhanden
		if ((slice < additional.size())
			&& (slice > -1)
			&& (additional.elementAt(slice) != null)) {
			//Slice holen
			Vector slice_entries = (Vector) additional.elementAt(slice);
			// suche gewuenschten Eintrag und gib ihn zurueck
			Enumeration enum = slice_entries.elements();
			while (enum.hasMoreElements()) {
				MenuEntry entry = (MenuEntry) enum.nextElement();
				if (entry.getTyp() == typ)
					return entry;
			}

		}
		// ups. keinen eintrag gefunden.
		return null;
	}

	/*
	 *					 		M E N U E - N O D E
	 */

	/**
	 * 	Java3D-Men&uuml;objekt zur&uuml;ckgeben.
	 * 
	 * @return Java3D-<i>Node</i>
	 */
	protected Node getMenu() {

		for (int i = 0; i < slices.size(); i++) {

			TransformGroup tg = new TransformGroup();

			// additions rausholen
			Vector additions = (Vector) additional.elementAt(i);
			Enumeration enum1 = additions.elements();
			while (enum1.hasMoreElements()) {
				tg.addChild(((MenuEntry) enum1.nextElement()).getNode());
			}
			// slice-elements holen
			Vector slice = (Vector) slices.elementAt(i);
			Enumeration enum2 = slice.elements();
			while (enum2.hasMoreElements()) {
				tg.addChild(((MenuEntry) enum2.nextElement()).getNode());
			}
			// pro slice ein switch-eintrag
			menuSW.addChild(tg);
		}
		return menuSW;
	}

} //end of class