package pacman3d.intro;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;

/**
 * <b>Title:</b> Java3D-Praktikum - Pacman3D</br>
 * <b>Description:</b><br>
 *
 * Splash-Screen w&auml;hrend Intro-Ladevorgang
 * <br>
 *
 * <b>Copyright:</b>	Copyright (c) 2002<br>
 *
 * @author              Netz+Intro<br>
 */
public class LoadingCanvas extends Canvas {


	// logo-bild
	private Image logo = null;
	// canvas-bild
	private Image buffer = null;
	private Graphics gBuffer = null;

	/**
	 *  L&auml;dt das Pacman3D-Logo.
	 */
	public LoadingCanvas(){
		logo = getToolkit().createImage(Defaults.BASE_PATH + "pacman3d.png");
	}


	/**
	 * Neuzeichnen des Canvas.
	 * 
	 * @param g Graphics-Kontext des Splash-Screens
	 */
	public void paint(Graphics g){
		
		Graphics2D g2 = (Graphics2D) g;
		
		int wc = this.getWidth();
		int hc = this.getHeight();
		int wl = 0;
		int hl = 0;
		
		// leeren		
		g2.setColor(new Color(127,192,0));
		g2.fillRect (0, 0, wc, hc);

		
		// logo anzeigen		
		if (logo != null) {
			wl = logo.getWidth(this);
			hl = logo.getHeight(this);
			g2.drawImage(logo, (wc-wl)/2, (hc-hl)/2,this);
		}
		
		// loading string
		String s = "Loading...";
		g2.setColor(Color.yellow);
		g2.setFont(new Font("Arial", Font.PLAIN, 20));
		int ws = g2.getFontMetrics().stringWidth(s);
		int hs = g2.getFontMetrics().getHeight();
		g2.drawString("Loading...", (wc-ws)/2, (hc + hl) / 2);
		
	}

	/**
	 * Basic-update call durch Swing
	 * 
	 * @param g Graphics-Kontext des Splash-Screens
	 */	
	public void update(Graphics g){
	
		//cba: Code von GameCockpitPanel
		// BufferImage anlegen, falls noch nicht vorhanden
		if (buffer == null) {
			buffer = createImage (this.getSize().width, this.getSize().height);
			gBuffer = buffer.getGraphics();
		}

		// BufferImage resizen, wenn Frame geresizet wurde
		if ((buffer.getWidth(this) != getSize().width) || (buffer.getHeight(this) != getSize().height)) {
			buffer = createImage (this.getSize().width, this.getSize().height);
			gBuffer = buffer.getGraphics();
		}

		// Buffer subern und kopieren
		gBuffer.setColor(new Color(127,192,0));
		gBuffer.fillRect (0, 0, this.getWidth(), this.getHeight());

		// Aufruf der eigentlichen Paint-Methode mit dem Hintergrundpuffer,
		// der anschlieend auf den Bildschirm kopiert wird.
		paint (gBuffer);
		g.drawImage (buffer, 0, 0, this);
		
	}

	/**
	 * Minimale Gr&ouml;sse des Screens setzen
	 * 
	 * @return Gr&ouml;sse durch <i>Dimension</i> gekapselt
	 */ 
	public Dimension getMininumSize(){
		return new Dimension(600,400);	
	}

}
