package pacman3d.intro;

import javax.vecmath.*;
import javax.media.j3d.*;
import pacman3d.util.Debug;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.util.Enumeration;

/**
 * <b>Title:</b> Java3D-Praktikum - Pacman3D</br>
 * <b>Description:</b><br>
 * Hilfsklasse zur Ereignisbehandlung in EnteringRoomScene.
 * <br>
 *
 * <b>Copyright:</b>	Copyright (c) 2002<br>
 *
 * @author              Netz+Intro<br>
 */
public class EnteringSceneBehavior extends Behavior {

	private WakeupOnElapsedFrames wakeUp = null;
	private boolean isActive = false;
	private PositionPathInterpolator interpolator = null;
	private TransformGroup viewTG = null;
	private Transform3D view = new Transform3D();
	private EnteringRoomScene entering_scene = null;



	/**
	 * Konstruktor
	 *
	 * @param simpleU das Universum in das die Szene eingefgt wird
	 * @param entering_scene das EnteringRoomScene-Objekt, das das Behaviour steuert
	 * @param interpolator der Interpolator, der den Betrahcter zum Raumschiff bewegt
	 */
	public EnteringSceneBehavior(
		SimpleUniverse simpleU,
		EnteringRoomScene entering_scene,
		PositionPathInterpolator interpolator) {

		setSchedulingBounds(Defaults.BIG_BOUNDS);
		if (simpleU != null) {
			viewTG = simpleU.getViewingPlatform().getViewPlatformTransform();
		} else
			Debug.out(
				getClass().getName(),
				"SimpleUniverse is null!!!",
				Debug.LEVEL_CRITICAL);
		this.interpolator = interpolator;
		this.entering_scene = entering_scene;
	}

	/**
	 * Initialisiert das Behavior
	 */
	public void initialize() {
		wakeUp = new WakeupOnElapsedFrames(1, false);
		wakeupOn(wakeUp);
	}

	/**
	 * wird von Java3D aufgerufen, wenn der in Initialize definierte
	 * "WakeupOnElapsedFrames" - Stimulus eingetreten ist
	 *
	 * @param criteria Enumeration
	 */
	public void processStimulus(Enumeration criteria) {
		if (interpolator != null) {

			if (isActive) {
				// interpolator.value < 0.95 -> wir muessen was tun
				if (interpolator.getAlpha().value() < 0.95) {
					interpolator.getTarget().getTransform(view);
					viewTG.setTransform(view);
				} else
					entering_scene.enteringSceneDone();
			} else{

				Debug.out(
						getClass().getName(),
						"processStimulus(): interpolator inaktiv. pos = "
							+ interpolator.getAlpha().value(),
						Debug.LEVEL_NOTICE);
				// inaktiv -> laufen bis wert < 0.05
				if (interpolator.getAlpha().value() < 0.05) {
					interpolator.setEnable(false);
				} else interpolator.setEnable(true);
			}
		}
		wakeupOn(wakeUp);
	}

	/**
	 * Aktiviert und deaktiviert den Interpolator fr das Raumschiff
	 *
	 * @see enteringRoomScene#setEnable(boolean enable)
	 * @param boolean enable
	 */
	public void setEnable(boolean enable) {
		isActive = enable;
		if (enable)
			interpolator.setEnable(true);
	}

}