package pacman3d.intro;

import java.awt.Frame;
import java.awt.Font;
import javax.media.j3d.*;
import javax.vecmath.*;
import com.sun.j3d.utils.image.TextureLoader;
import com.mnstarfire.loaders3d.Inspector3DS;
import com.sun.j3d.utils.universe.SimpleUniverse;

/**
 * <b>Title:</b> Java3D-Praktikum - Pacman3D</br>
 * <b>Description:</b><br>
 * Eingangsanimation mit Raumschiff und 3D text wird erzeugt
 * <br>
 *
 * <b>Copyright:</b>	Copyright (c) 2002<br>
 *
 * @author              Netz+Intro<br>
 */
public class EnteringRoomScene {

	// Ein Interpolatorobjekt fr die Animation
	private PositionPathInterpolator interpolator = null;

	// das Universum, in dem wir uns befinden
	private SimpleUniverse su = null;

	private TransformGroup viewTG = new TransformGroup();
	private EnteringSceneBehavior behavior = null;
	private Intro intro = null;



	/**
	 * Konstruktor empfngt das Universum
	 *
	 * @param simpleU das Universum in das die Szene eingefgt wird
	 * @param intro das Intro-Objekt in das die Raumszene eingefgt wird
	 */
	public EnteringRoomScene(SimpleUniverse simpleU, Intro intro) {
		su = simpleU;
		this.intro = intro;
	}

	/**
	 * Hilsmethode, dei den Text, der in der Erffnungsszene eingeblendet werden soll, setzt
	 *
	 * @param text der Text der in der Szene eingeblendet wird
	 * @param position die Position des Textes
	 * @return
	 */
	private Shape3D sceneText(String text, Point3f position) {
		Font3D font3d = Defaults.INPUT_FONT3D;
		Text3D text1 = new Text3D(font3d, text, position);
		Shape3D shape = new Shape3D(text1);
		return shape;
	}

	/**
	 * Eingangsanimation mit Flug um Raumschiff erzeugen und zurckgeben
	 *
	 * @return eine Transformgroup, die die anzuzeigende Erffnungsszene enthlt
	 */
	protected TransformGroup createEnteringScene() {

		TransformGroup objRoot = new TransformGroup();
		objRoot.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		objRoot.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);

		//BACKGROUND
		TransformGroup bgGroup = new TransformGroup();
		objRoot.addChild(bgGroup);

		TextureLoader bgTexture =
		new TextureLoader(Defaults.BASE_PATH + "space2.jpg", new Frame());
		ImageComponent2D bgImage = bgTexture.getImage();
		Background bg = new Background(bgImage);
		bg.setApplicationBounds(bounds);
		bgGroup.addChild(bg);

		//LICHT
		DirectionalLight dLight = new DirectionalLight(new Color3f(1.0f,1.0f,1.0f), new Vector3f(7.0f,-7.0f,-25.0f));
		dLight.setInfluencingBounds(bounds);//einflussregion des lichts
		objRoot.addChild(dLight);//licht zum branch group einfuegen

		//RAUMSCHIFF LADEN
		Transform3D scale = new Transform3D();
		Transform3D translate = new Transform3D();
		scale.setScale(0.9);
		translate.set(new Vector3f(0.0f, 0.0f, -90.5f));
		scale.mul(translate);
		TransformGroup schiff2 = new TransformGroup(translate);
		schiff2.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		schiff2.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		schiff2.addChild(Intro.loadTGfrom3DS("entering_ship.3ds"));
		objRoot.addChild(schiff2);

		//TEXT3D
		scale.setScale(1.1);
		Transform3D rotate = new Transform3D();
		translate.set(new Vector3f(13.1f, 0.0f,2.5f));
		rotate.rotY(Math.PI / 6.0d);
		rotate.mul(scale);
		rotate.mul(translate);
		TransformGroup textTG = new TransformGroup(rotate);
		textTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		textTG.addChild(sceneText("Johann Wolfgang Goethe-Universitt", new Point3f(0.5f, 0.0f, 9.5f)));
		textTG.addChild(sceneText("Fachbereich Biologie und Informatik ", new Point3f(0.5f, -1.5f, 9.5f)));
		textTG.addChild(sceneText("Institut Informatik ", new Point3f(0.5f, -3.0f, 9.5f)));
		textTG.addChild(sceneText("Professur fr Graphische Datenverarbeitung ", new Point3f(0.5f, -6.0f, 9.5f)));
		textTG.addChild(sceneText("Prof. Dr.-Ing. Detlef Krmker ", new Point3f(0.5f, -7.5f, 9.5f)));
		textTG.addChild(sceneText("Java3D Praktikum ", new Point3f(0.5f, -10.5f, 9.5f)));
		textTG.addChild(sceneText("Wintersemester 01/02 ", new Point3f(0.5f, -12.0f, 9.5f)));
		objRoot.addChild(textTG);

		// Animationsanweisungen
		Transform3D yAxis = new Transform3D();
		float[] knots =
			{ 0.0f, 0.09f, 0.19f, 0.29f, 0.39f, 0.49f, 0.59f, 0.69f, 0.79f, 0.89f, 1.0f };

		Alpha alpha = new Alpha(-1, 2000, 0, 35000, 15000, 0);

		Point3f[] positions = new Point3f[11];
		positions[0] =  new Point3f( 0.0f, 0.0f,  5.0f);
		positions[1] =  new Point3f( 0.5f, 0.0f,  1.5f);
		positions[2] =  new Point3f( 1.0f, 0.0f,  0.0f);
		positions[3] =  new Point3f( 1.5f, 0.0f, -3.0f);
		positions[4] =  new Point3f( 1.9f, 0.0f, -8.0f);
		positions[5] =  new Point3f( 1.5f, 0.0f, -10.9f);
		positions[6] =  new Point3f( 1.1f, 0.0f, -25.2f);
		positions[7] =  new Point3f( 0.9f, 0.0f, -50.5f);
		positions[8] =  new Point3f( 0.7f, 0.0f, -70.0f);
		positions[9] =  new Point3f( 0.5f, 0.0f, -89.1f);
		positions[10] = positions[9];

		interpolator =
		  new PositionPathInterpolator(alpha, viewTG, yAxis, knots, positions);
		interpolator.setSchedulingBounds(bounds);
		objRoot.addChild(interpolator);
		interpolator.setEnable(false);


		AmbientLight ambientLight = new AmbientLight(Defaults.COLOR_WHITE);
		ambientLight.setInfluencingBounds(Defaults.BIG_BOUNDS);
		objRoot.addChild(ambientLight);

		// neues EnteringSceneBehaviour-Objekt erzeugen
		behavior = new EnteringSceneBehavior(su, this, interpolator);
		objRoot.addChild(behavior);

		return objRoot;
	}

	/**
	 * Aktiviert und deaktiviert den Interpolator fr das Raumschiff
	 *
	 * @see enteringSceneBehavior#setEnable(boolean enable)
	 * @param enable true aktiviert Interpolator und false schaltet ihn ab
	 */
	protected void setEnable(boolean enable) {
		if (behavior != null)
			behavior.setEnable(enable);
	}

	/**
	 * schaltet von Eingangsequenz zur Menansicht.
	 *
	 * @see Intro#enteringSceneDone()
	 */
	protected void enteringSceneDone() {
		intro.enteringSceneDone();
	}

}