package pacman3d.intro;

import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Font3D;
import javax.media.j3d.Material;
import javax.media.j3d.FontExtrusion;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import java.awt.Font;


/**
 * <b>Title:</b> Java3D-Praktikum - Pacman3D</br>
 * <b>Description:</b><br>
 *
 * Default-Einstellungen f&uuml;rs Intro.
 * <br>
 *
 * <b>Copyright:</b>	Copyright (c) 2002<br>
 *
 * @author              Netz+Intro<br>
 */
public interface Defaults {


	// Basis-Konstanten
	public static final String BASE_PATH = "./models/intro/";

	// ein paar Farbkonstanten fuer das Intro
	public static final Color3f COLOR_LBLUE = new Color3f(0.0f, 0.5f, 1.0f);
	public static final Color3f COLOR_GREY1 = new Color3f(0.5f, 0.5f, 0.5f);
	public static final Color3f COLOR_WHITE = new Color3f(1.0f, 1.0f, 1.0f);
	public static final Color3f COLOR_YELLOW = new Color3f(1.0f, 1.0f, 0.0f);
	public static final Color3f COLOR_BLACK = new Color3f(0.0f, 0.0f, 0.0f);

	// Farben fuer Intro CI
	public static final Color3f COLOR_P3D_GREEN = new Color3f(0.332f, 0.5f, 0.0f);
	public static final Color3f COLOR_P3D_LIGHTGREEN = new Color3f(0.496f, 0.75f, 0.0f);
	public static final Color3f COLOR_P3D_RED = new Color3f(0.863f, 0.089f, 0.046f);
	public static final Color3f COLOR_P3D_BLUE = new Color3f(0.199f, 0.437f, 0.667f);
	public static final Color3f COLOR_P3D_DARKGRAY = new Color3f(0.3125f, 0.3125f, 0.3125f);


	// Materialdefinitionen, die im Intro verwendet werden
	public static final Material GRAY_MATERIAL =
		new Material(COLOR_P3D_DARKGRAY,COLOR_P3D_DARKGRAY,COLOR_P3D_DARKGRAY,COLOR_P3D_DARKGRAY,100.0f);

	public static final Material LIGHTGREEN_MATERIAL =
		new Material(COLOR_P3D_LIGHTGREEN,COLOR_P3D_LIGHTGREEN,COLOR_P3D_LIGHTGREEN,COLOR_P3D_LIGHTGREEN,100.0f);

	public static final Material RED_MATERIAL =
		new Material(COLOR_P3D_RED,COLOR_P3D_RED,COLOR_P3D_RED,COLOR_P3D_RED,100.0f);

	public static final Material BLUE_MATERIAL =
		new Material(COLOR_P3D_BLUE,COLOR_P3D_BLUE,COLOR_P3D_BLUE,COLOR_P3D_BLUE,100.0f);


	// Fonts
	public static final Font3D MENU_FONT3D =
		new Font3D(new Font("dialog", Font.PLAIN, 1), new FontExtrusion());


	public static final Font3D INPUT_FONT3D =
		new Font3D(new Font("monospaced", Font.PLAIN, 1), new FontExtrusion());

	// default BoundingSphere
	public static BoundingSphere BIG_BOUNDS =
		new BoundingSphere(new Point3d(0.0f, 0.0f, 0.0f), 1000.0f);

}
