package pacman3d.camera;

/**
 * Title:        Pacman 3D
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author
 * @version 1.0
 */
import pacman3d.labyrinth.*;
import pacman3d.pacman.*;
import pacman3d.message.*;
import javax.media.j3d.*;
import javax.vecmath.*;
import com.sun.j3d.audioengines.javasound.*;
import pacman3d.util.Debug;

public class Camera implements MessageListener
{ private ID id;
  private Labyrinth lab;
  private View myView = new View();
  private Canvas3D can;
  private BranchGroup viewBranch;
  private TransformGroup viewTrGrPacManBase;
  private TransformGroup viewTrGrRotX;
  private TransformGroup viewTrGrRotY;
  private TransformGroup viewTrGrZoom;
  private int view;
  private int style;

  private double yrot = 0;
  private double xrot = -Math.PI/6;
  private double zoom = 2;
  private double rotStep  = Math.PI / 36;
  private double zoomStep = 0.5;

  private int labBreite;
  private int labTiefe;

  private double ampX = 0, ampY = 0, ampZ = 0;
  private double perX = 0, perY = 0, perZ = 0;
  private int duration = 0;
  private int duration_cur = 0;
  private double quakeX = 0, quakeY = 0, quakeZ = 0;
  private double cageX = 0, cageZ = 0;
  private double slug = 0;
  private Point3d Pacmanoldpos = new Point3d();
  private double FOV = 45;
  private double FOVstep = 5;

  public static final int EGO_VIEW       = 0;
  public static final int TRACKER_VIEW   = 1;
  public static final int BIRD_VIEW      = 2;
  public static final int ISO_VIEW       = 3;

  public static final int NORMAL_STYLE   = 0;
  public static final int FREEROT_STYLE  = 1;
  public static final int SLUGGISH_STYLE = 2;
  public static final int UNBOUND_STYLE  = 3;
  public static final int CAGE_STYLE     = 4;

  private String viewname;
  private String stylename;

  public Camera(Labyrinth lab, Canvas3D can)
  { this.id = new ID();
	labBreite = lab.getConstraints().x;
	labTiefe = lab.getConstraints().y;
	this.lab = lab;
	this.can = can;
	this.view = EGO_VIEW;
	this.view = TRACKER_VIEW;
	this.view = BIRD_VIEW;
//      this.view = ISO_VIEW;
        this.style = NORMAL_STYLE;
  }

  public String GetViewname()
  { return this.viewname;
  }

  public String GetStylename()
  { return this.stylename;
  }

  private void setView(int view)
  { this.view = view;
  }

  private void ResetStyle()
  { this.style = NORMAL_STYLE;
    this.stylename = "normal";
  }

  private void ResetTrackerCam()
  { this.xrot = -Math.PI/6;
    this.yrot = 0;
    this.zoom = 2;
  }

  private void ResetFOV()
  { this.FOV = 45;
    this.myView.setFieldOfView(FOV/180*Math.PI);
  }

  private void EnlargeFOV()
  { this.FOV += FOVstep;
    if (this.FOV > 60)
      this.FOV = 60;
    this.myView.setFieldOfView(FOV/180*Math.PI);
  }

  private void EncloseFOV()
  { this.FOV -= FOVstep;
    if (this.FOV < 5)
      this.FOV = 5;
    this.myView.setFieldOfView(FOV/180*Math.PI);
  }

  public void toggleStyle()
  { switch(this.view)
    { case EGO_VIEW:
        break;
      case TRACKER_VIEW:
        if(this.style==NORMAL_STYLE)
        { this.style = FREEROT_STYLE;
          this.stylename = "freerotation";
          ResetTrackerCam();
        }
        else if(this.style==FREEROT_STYLE)
/*        { this.style = SLUGGISH_STYLE;
          this.stylename = "sluggish";
        }
        else if(this.style==SLUGGISH_STYLE)*/
        { this.style = NORMAL_STYLE;
          this.stylename = "normal";
          ResetTrackerCam();
        }
        break;
      case BIRD_VIEW:
        if(this.style==NORMAL_STYLE)
        { this.style = UNBOUND_STYLE;
          this.stylename = "unbound";
        }
        else if(this.style==UNBOUND_STYLE)
        { this.style = CAGE_STYLE;
          this.stylename = "cage";
        }
        else if(this.style==CAGE_STYLE)
        { this.style = NORMAL_STYLE;
          this.stylename = "normal";
        }
        break;
      case ISO_VIEW:
        if(this.style==NORMAL_STYLE)
        { this.style = CAGE_STYLE;
          this.stylename = "cage";
        }
        else if(this.style==CAGE_STYLE)
        { this.style = NORMAL_STYLE;
          this.stylename = "normal";
        }
        break;
    }
  }

  public BranchGroup getViewBranch()
  { return viewBranch;
  }

  public void SetQuake(int duration, double ampX, double ampY, double ampZ, double perX, double perY, double perZ)
  { this.duration = duration;
    this.duration_cur = duration;
    this.ampX = ampX;
    this.ampY = ampY;
    this.ampZ = ampZ;
    this.perX = perX;
    this.perY = perY;
    this.perZ = perZ;
    this.quakeX = 0;
    this.quakeY = 0;
    this.quakeZ = 0;
  }

  private void CalcQuake(int nTicks)
  { if (this.duration_cur > 0)
    { double x = (double)(this.duration - this.duration_cur + 1);
      this.quakeX= Math.sin(x * this.perX) * this.ampX / x;
      this.quakeY= Math.sin(x * this.perY) * this.ampY / x;
      this.quakeZ= Math.sin(x * this.perZ) * this.ampZ / x;

      this.duration_cur -= nTicks;
      if (this.duration_cur <= 0)
        SetQuake(0, 0, 0, 0, 0, 0, 0);
    }
  }

  /**
   * generiert einen Viewbranch (Code aus pacman3d.labyrinth.Test bernommen)
   */
  public BranchGroup buildViewBranch()
  { viewBranch = new BranchGroup();
	viewTrGrPacManBase = new TransformGroup();
	viewTrGrRotX = new TransformGroup();
	viewTrGrRotY = new TransformGroup();
	viewTrGrZoom = new TransformGroup();

	// Plattform und Umgebung erzeugen
	ViewPlatform viewPf = new ViewPlatform();
	PhysicalBody body = new PhysicalBody();
	PhysicalEnvironment envi = new PhysicalEnvironment();

	viewTrGrPacManBase.addChild(viewTrGrRotY);
	viewTrGrRotY.addChild(viewTrGrRotX);
	viewTrGrRotX.addChild(viewTrGrZoom);
	viewTrGrZoom.addChild(viewPf);

	viewTrGrPacManBase.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
	viewTrGrRotX.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
	viewTrGrRotY.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
	viewTrGrZoom.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);

	viewBranch.addChild(viewTrGrPacManBase);

	// View wird erzeugt
	myView.addCanvas3D(can);
	myView.attachViewPlatform(viewPf);
	myView.setPhysicalBody(body);
	myView.setPhysicalEnvironment(envi);
	JavaSoundMixer mixer = new JavaSoundMixer(envi);
	mixer.initialize();
	return viewBranch;
  }

  public void updateCamera(int nTicks)
  { Pacman oPacman = lab.getPacman(lab.getActivePacmanID());
	Point3d pos = oPacman.getRealPacmanPos();
	Vector3d viewvector = oPacman.getRealLineOfSight();

	if (nTicks > 0)
          CalcQuake(nTicks);

        Transform3D tr = new Transform3D();
        if (this.style!=SLUGGISH_STYLE)
          tr.setTranslation(new Vector3d(pos.x+this.quakeX,pos.y+this.quakeY,pos.z+this.quakeZ));
        else
        {
          double x = pos.x;
          double z = pos.z;
//          x = Math.sqrt(pos.x - Pacmanoldpos.x);
//          z = Math.sqrt(pos.z - Pacmanoldpos.z);
          tr.setTranslation(new Vector3d(x+this.quakeX,pos.y+this.quakeY,z+this.quakeZ));
        }
	viewTrGrPacManBase.setTransform(tr);

	double ViewAngleY = (viewvector.x>0?-1:1)*viewvector.angle(new Vector3d(0,0,-1));
        // Rotation setzen
	tr = new Transform3D();
	tr.rotY(ViewAngleY);

	if((this.view!=Camera.ISO_VIEW) && (this.style!=UNBOUND_STYLE)  && (this.style!=CAGE_STYLE))
	  viewTrGrRotY.setTransform(tr);
	else
	  viewTrGrRotY.setTransform(new Transform3D());
	viewTrGrRotX.setTransform(new Transform3D());

	tr = new Transform3D();
	switch (this.view)
	{ case EGO_VIEW:
		tr.setTranslation(new Vector3d(0,0,0.5));
		viewTrGrZoom.setTransform(tr);
		for(int i=0;i<lab.getFloorCount();i++)
		{ lab.setFloorVisible(i,true);
		}
		break;
	  case TRACKER_VIEW:
		tr.setTranslation(new Vector3d(0,0.5,zoom));
		viewTrGrZoom.setTransform(tr);
		tr = new Transform3D();
		tr.rotY(ViewAngleY+yrot);
		Transform3D trn = new Transform3D();
		trn.rotX(xrot);
		tr.mul(trn);
		viewTrGrRotY.setTransform(tr);
		for(int i=0;i<lab.getFloorCount();i++)
		{ lab.setFloorVisible(i,(i<=pos.y));
		}
		break;
	  case BIRD_VIEW:
		tr.rotX(-Math.PI/2);
		viewTrGrRotX.setTransform(tr);
		tr = new Transform3D();
                if (this.style==CAGE_STYLE)
                { if (cageX < pos.x - 2.5)
                    cageX = pos.x - 2.5;
                  else if (cageX > pos.x + 2.5)
                    cageX = pos.x + 2.5;
                  if (cageZ < pos.z - 2)
                    cageZ = pos.z - 2;
                  else if (cageZ > pos.z + 2)
                    cageZ = pos.z + 2;
		  tr.setTranslation(new Vector3d(cageX,pos.y+10,cageZ));
                }
                else
		  tr.setTranslation(new Vector3d(pos.x,pos.y+10,pos.z));
		viewTrGrPacManBase.setTransform(tr);
		for(int i=0;i<lab.getFloorCount();i++)
		{ lab.setFloorVisible(i,(i<=pos.y));
		}
		break;
	  case ISO_VIEW:
		tr.setTranslation(new Vector3d(0,0.5,7.0));
		viewTrGrZoom.setTransform(tr);
		tr = new Transform3D();
		tr.rotY(Math.PI/4);
		Transform3D tri = new Transform3D();
		tri.rotX(16*Math.PI/9);
		tr.mul(tri);
		viewTrGrRotY.setTransform(tr);
		Transform3D trc = new Transform3D();
                if (this.style==CAGE_STYLE)
                { if (cageX < pos.x - 1)
                    cageX = pos.x - 1;
                  else if (cageX > pos.x + 1)
                    cageX = pos.x + 1;
                  if (cageZ < pos.z)
                    cageZ = pos.z;
                  else if (cageZ > pos.z + 3)
                    cageZ = pos.z + 3;
		  trc.setTranslation(new Vector3d(cageX,pos.y,cageZ));
                }
                else
		  trc.setTranslation(new Vector3d(pos.x,pos.y,pos.z));
		viewTrGrPacManBase.setTransform(trc);
		for(int i=0;i<lab.getFloorCount();i++)
		{ lab.setFloorVisible(i,(i<=pos.y));
		}
		break;

	}
  }


  public void getMessage(Message oMessage)
  { Pacman oPacman = lab.getPacman(lab.getActivePacmanID());
    if(oMessage.getContent() instanceof String)
	{ String h = (String) oMessage.getContent();
	  if(h.equalsIgnoreCase("toggle style"))
            toggleStyle();
	  if(h.equalsIgnoreCase("ego"))
	  { setView(Camera.EGO_VIEW);
            this.viewname = "EGO";
            ResetStyle();
            updateCamera(0);
            oPacman.setVisible(false);
	  }
	  else if (h.equalsIgnoreCase("bird"))
	  { setView(Camera.BIRD_VIEW);
            this.viewname = "BIRD";
            ResetStyle();
	    updateCamera(0);
            oPacman.setVisible(true);
	  }
	  else if (h.equalsIgnoreCase("iso"))
	  { setView(Camera.ISO_VIEW);
            this.viewname = "ISO";
            ResetStyle();
	    updateCamera(0);
            oPacman.setVisible(true);
	  }
	  else if (h.equalsIgnoreCase("tracker"))
	  { setView(Camera.TRACKER_VIEW);
            this.viewname = "TRACKER";
            ResetStyle();
	    updateCamera(0);
            oPacman.setVisible(true);
//            SetQuake(100, 5, 5, 5, .7, 1, 1.5);
	  }
	  else if (h.equalsIgnoreCase("camup"))
	  { if((view==Camera.TRACKER_VIEW) && (this.style==FREEROT_STYLE))
		  xrot -= rotStep;
	  }
	  else if (h.equalsIgnoreCase("camdown"))
	  { if((view==Camera.TRACKER_VIEW) && (this.style==FREEROT_STYLE))
		  xrot += rotStep;
	  }
	  else if (h.equalsIgnoreCase("camleft"))
	  { if((view==Camera.TRACKER_VIEW) && (this.style==FREEROT_STYLE))
		  yrot += rotStep;
	  }
	  else if (h.equalsIgnoreCase("camright"))
	  { if((view==Camera.TRACKER_VIEW) && (this.style==FREEROT_STYLE))
		  yrot -= rotStep;
	  }
	  else if (h.equalsIgnoreCase("camzoomin"))
	  { if((view==Camera.TRACKER_VIEW) && (this.style==FREEROT_STYLE))
            {
		  if(zoom>1.5)
			zoom -= zoomStep;
            }
	    else if(view==Camera.EGO_VIEW)
              EncloseFOV();
	  }
	  else if (h.equalsIgnoreCase("camzoomout"))
	  { if((view==Camera.TRACKER_VIEW) && (this.style==FREEROT_STYLE))
		  zoom += zoomStep;
	    else if(view==Camera.EGO_VIEW)
              EnlargeFOV();
	  }
	  else if (h.equalsIgnoreCase("camreset"))
	  { if((view==Camera.TRACKER_VIEW) && (this.style==FREEROT_STYLE))
              ResetTrackerCam();
	    else if(view==Camera.EGO_VIEW)
              ResetFOV();
	  }
	  if (yrot<0)
		yrot += 2*Math.PI;
	  if (yrot>2*Math.PI)
		yrot -= 2*Math.PI;
	  if (xrot<0)
		xrot += 2*Math.PI;
	  if (xrot>2*Math.PI)
		xrot -= 2*Math.PI;
//	  Debug.out(this.getClass().toString(),"Camera-Einstellungen: x-Rotation: " + Math.round(xrot/Math.PI*180) + "  y-Rotation: " + Math.round(yrot/Math.PI*180) + "  Zoom: " + zoom);
	}
  }

  public ID getID()
  { return id;
  }


}