package pacman3d;

import java.util.Vector;
import java.util.LinkedList;
import javax.swing.*;
import java.io.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.net.URL;

import javax.media.j3d.*;
import javax.vecmath.*;
import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.universe.*;
import com.sun.j3d.audioengines.javasound.*;
import com.sun.j3d.utils.behaviors.mouse.*;

import pacman3d.labyrinth.*;
import pacman3d.pacman.*;
import pacman3d.monster.*;
import pacman3d.message.*;
import pacman3d.camera.*;
import pacman3d.util.*;
import pacman3d.intro.*;
import pacman3d.net.*;

/**
 * <b>Title:</b> Pacman 3D - Nicht wirklich ;)<br/>
 * <b>Description:</b><p>Die Hauptklasse, die die Initialisierung aller anderen Objekte anstt.</p>
 * <b>Copyright:</b>Copyright (c) 2001<br/>
 *
 * @author Labyrinth-Gruppe<br/>
 * @version $Version$ $Date: 2002/03/26 08:11:44 $<br/>
 */

public class Game implements ActionListener, MessageListener {

	/* die Anzahl der Millisekunden pro Tick */
	public final static int m_ciMillisPerTick = 10;

	/* gibt an, ob sich Game im Debugmode befindet*/
	boolean m_bDebug = true;

	/* Flag gibt an, ob das Spiel am Laufen ist oder nicht */
	boolean m_bIsRunning = false;

	/* Flag gibt an, ob das Spiel am Laufen ist oder nicht */
	boolean m_bAppIsRunning = false;

	/* die Nachrichten-ID des Games */
	private ID m_idSelf = null;

	/* hlt die Instanz des Labyrinths */
	private Labyrinth m_oLabyrinth = null;

	/* hlt die Instanz der Monsterverwaltung */
	private MonsterChannel m_oMonsterChannel = null;

	/* Monster Positionen */
	private LinkedList monsterInitPositions = new LinkedList();

	/* Anzahl der zu ladenden Monster (-1 bedeutet: wie im Levelfile vorgegeben) */
	private int m_iMonsterAmount = -1;

	/* hlt die Instanz der Pacmanverwaltung */
	private Pacman m_oPacman = null;

	/* hlt die Instanz der Kameraverwaltung */
	private Camera m_oCamera = null;

	/* die oberste Transformgroup, in der alle Objekte (pacman, monster,
	labyrinth) gehalten werden */
	TransformGroup m_tgContent = null;

	/* der Dateiname des Levels, dass geladen werden soll (vermutlich nicht
	die finale Lsung, hier mu mit der Intro-Gruppe kommuniziert werden) */
	private String m_sLocalLevelFileName = "levels/level_10x10.p3d";

	/* der Dateiname, in dem das Level im Recording-Mode gespeichert wird */
	private String m_sRecordLevelFileName = "";

	/* URL, von der das Level geladen werden soll (typischerweise entsprechend
	dem m_sLocalLevelFileName-String) */
	private URL m_urlLevel = null;

	/* enthlt eine Timervariable zur Kontrollflusteuerung */
	private Timer m_oTimer;
	private int m_lActionCount = 0;

	/* die Instanzvariable fr das Spielfenster */
	private GameFrame m_oGameFrame;

	/* eine Instanz auf den Netzwerkservice */
	private NetworkService m_oNetworkService;

	/* eine Instanz auf die lokale Poststelle */
	private MessageService m_oMessageService;

	/* eine Instanz des Intros halten */
	private Intro m_oIntro;

	/* Flag gibt an, ob Intro gezeigt oder direkt zum Spiel gegangen werden
	soll (Default ist true) */
	private boolean m_bShowIntro = true;

	/* Flag gibt an, ob die Mouselistener zur Rotation/Bewegung/Skalierung
	der Szene aktiviert werden sollen (Default ist false) */
	private boolean m_bUseMouseListener = false;

	/* Flag gibt an, ob das Labyrinth im Wireframe-Modus oder mit "normaler"
	Ansicht gestartet werden soll. */
	private boolean m_bLabyrinthWireFrameMode = false;

	/* Flag, das true ist, wenn Applikation im Demomodus, false im normalen
	Spielmodus (Singleplayer wie Multiplayer) */
	private boolean m_bDemoMode = false;

	/* Flag ist gesetzt, wenn im Multiplayer-Modus Verbindung zum Netzwerk
	besteht, sonst false */
	private boolean m_bConnected = false;

	/* Flag gibt an, ob Anmeldenachricht bereits gesendet wurde */
	private boolean m_bPlayerNewMessageSent = false;

	/* Wert gibt an, wieviele ScoreUpdateContent-Nachrichten am Ende
	empfangen wurden */
	private int m_iScoreContentCount = 0;

	/* die maximale Anzahl von zu holenden ScoreUpdateContent-Nachrichten
	in der Endephase */
	private int m_iScoreContentMax = 0;

	/* Flag gibt an, ob Spielende-Phase aktiv ist und die entsprechende
	Nachricht bereits gesendet wurde */
	private boolean m_bEndingPhase = false;

	/* Nachrichten, die erst nach der Initialisierung der Grafik verarbeitet
	werden knnen, aber schon frher eingetroffen sind */
	private Vector m_vecPreRunningMessages = null;

	/* Flag, ob Multiplayermodus (true) oder Singleplayermodus (false) */
	private boolean m_bMultiplayerGame = false;

	/* Flag gibt Auskunft darber, ob dieses Spiel der Server ist oder nicht */
	private boolean m_bWeAreServer = false;

	/* unsere Hostadresse, wenn wir Server sind, die Adresse des Zielservers,
	wenn wir Client sind. Im Singleplayer-Modus ohne Funktion  */
	private String m_sHost = "";



	/* vom ActionListener-Interface vorgesehene Methode, die beim Auftreten
	eines ActionEvents gefeuert wird (beispielsweise durch ein Timer-Event) */
	public void actionPerformed (ActionEvent e) {
		m_lActionCount++;

		/* TEMPORR: Zhler wird nach 5 Aufrufen auf null gesetzt */
		if (m_lActionCount > 5) {
			m_lActionCount = 0;
		}
	}

	/**
	 * Nimmt eine Nachricht entgegen, die anschliessend ausgewertet wird.
	 * @param oMessage die bergebene Nachricht
	 */
	public void getMessage( Message oMessage ) {

		// Nachricht holen und checken, ob Inhalt dabei
		Object oContent = oMessage.getContent();
		if (oContent != null) {

			// temp:
			// Debug.out (this.getClass().getName(), "!!! Message in game received: " + oContent, Debug.LEVEL_NOTICE);

			// nach Inhaltstyp dispatchen
			if (oContent instanceof NetworkStateMessage) {

				Debug.out(this.getClass().getName(), "network state message received: " + oContent, Debug.LEVEL_NOTICE);

				NetworkStateMessage oNetworkStateMessage = (NetworkStateMessage)oContent;
				if (oNetworkStateMessage.getNetworkState() == NetworkListener.STATUS_CONNECTED) {
					m_bConnected = true;
					if ((!m_bIsRunning) && (!m_bWeAreServer) && (!m_bPlayerNewMessageSent)) {
						Debug.out (this.getClass().getName(), "let's fetz! ", Debug.LEVEL_NOTICE);
						try {
							PlayerNewContent oPlayerNewContent = new PlayerNewContent(m_idSelf);
							Message oNewMessage = new Message (m_idSelf, oPlayerNewContent, Message.RECEIVER_ALL_GAMES);
							m_oMessageService.sendMessage(oNewMessage, MessageService.PROPAGATE_NETWORK, 0);
							m_bPlayerNewMessageSent = true;
						} catch (Exception ex) {
							Debug.out (this.getClass().getName(), "error sending message to server: " + ex, Debug.LEVEL_CRITICAL);
							return;
						}
					}
				}

			} else if (oContent instanceof PlayerNewContent) {
				PlayerNewContent oPlayerNewContent = (PlayerNewContent)oContent;
				// ID idNewPlayer = oMessage.getSender();
				ID idNewPlayer = oPlayerNewContent.getID();
				Debug.out (this.getClass().getName(), "new player entered arena: " + idNewPlayer, Debug.LEVEL_NOTICE);

				// sind wir Server, dann eine LevelToLoad-Nachricht absetzen
				if (m_bWeAreServer) {
					try {
						LevelToLoadContent oLevelToLoadContent = new LevelToLoadContent(this.m_urlLevel);
						Debug.out (this.getClass().getName(), "client should load: " + this.m_urlLevel, Debug.LEVEL_NOTICE);
						Message oNewMessage = new Message (m_idSelf, oLevelToLoadContent, idNewPlayer);
						m_oMessageService.sendMessage(oNewMessage, MessageService.PROPAGATE_NETWORK, 0);
					} catch (Exception ex) {
						Debug.out (this.getClass().getName(), "error sending leveltoload message to new player: " + ex, Debug.LEVEL_CRITICAL);
						return;
					}

					// und auch die Items verteilen (dazu alle Zellen des Labyrinths
					// abgrasen und prfen, ob sie Items haben -> dann Nachricht bauen)
					Debug.out (this.getClass().getName(), "sending item information to new player: " + idNewPlayer, Debug.LEVEL_NOTICE);
					int iMaxX, iMaxY, iMaxZ;
					Point3i p3iTemp = m_oLabyrinth.getConstraints();
					iMaxY = p3iTemp.y;
					iMaxX = p3iTemp.x;
					iMaxZ = p3iTemp.z;

					pacman3d.labyrinth.cells.Cell oCell = null;
					Message oNewMessage = null;
					Vector vecItems = null;
					int iItemsToSend = 0;
					for (int iY = 0; iY < iMaxY; iY++) {
						for (int iX = 0; iX < iMaxX; iX++) {
							for (int iZ = 0; iZ < iMaxZ; iZ++) {

								oCell = m_oLabyrinth.getCell (iX, iY, iZ);

								// es werden nur Zellen mit Items behandelt
								if (oCell.getItemsCount() > 0) {
									p3iTemp.x = iX;  p3iTemp.y = iY;  p3iTemp.z = iZ;
									vecItems = oCell.getItemsVector();

									for (int iItem = 0; iItem < vecItems.size(); iItem++) {
										//if (iItemsToSend < 5) {
											try {
												ItemInfoContent oItemInfoContent = new ItemInfoContent(p3iTemp, (pacman3d.labyrinth.items.Item)(vecItems.get(iItem)));
												oNewMessage = new Message (m_idSelf, oItemInfoContent, idNewPlayer);
												m_oMessageService.sendMessage(oNewMessage, MessageService.PROPAGATE_NETWORK, 0);
											} catch (Exception ex) {
												Debug.out (this.getClass().getName(), "error sending item info message to new player: " + ex, Debug.LEVEL_CRITICAL);
												return;
											}
										//}
										iItemsToSend++;

									}
								}
							}
						}
					}



				}

				// in jedem Fall den eigenen Pacman auf den neuen Client zwingen
				try {
					//PacmanSpawnedContent oPacmanSpawnedContent = new PacmanSpawnedContent(m_oPacman);

					//PacmanSpawnedContent oPacmanSpawnedContent = new PacmanSpawnedContent(m_oPacman, m_oPacman.getParameter("modelname"), m_oPacman.getParameter("friendly"));
					PacmanSpawnedContent oPacmanSpawnedContent =
						new PacmanSpawnedContent(m_oPacman,
						(String)m_oPacman.getParameter("modelname"),
						((Boolean)m_oPacman.getParameter("friendly")).booleanValue());
					Message oNewMessage = new Message (m_idSelf, oPacmanSpawnedContent, idNewPlayer);
					m_oMessageService.sendMessage(oNewMessage, MessageService.PROPAGATE_NETWORK, 0);
				} catch (Exception ex) {
					Debug.out (this.getClass().getName(), "error sending pacman message to new player: " + ex, Debug.LEVEL_CRITICAL);
					return;
				}

			} else if (oContent instanceof LevelToLoadContent) {

				if (!m_bIsRunning) {
					LevelToLoadContent oLevelToLoadContent = (LevelToLoadContent)oContent;

					// das zu ladende Level holen und das Spiel starten
					m_urlLevel = oLevelToLoadContent.getUrlLevel();
					try {
						// m_urlLevel = new URL("file:" + m_sLocalLevelFileName);
						m_urlLevel = new URL(m_urlLevel.toString());
					} catch (java.net.MalformedURLException ex) {
						Debug.out (this.getClass().getName(), ex, Debug.LEVEL_CRITICAL);
						return;
					}

					Debug.out (this.getClass().getName(), "server said, url to load is: " + this.m_urlLevel, Debug.LEVEL_NOTICE);
					this.localStartGame();
				}

			} else if (oContent instanceof PacmanSpawnedContent) {

				// einige Nachrichten knnen erst verarbeitet werden, wenn ein
				// Spiel mit 3D-Elementen usw. steht, daher im nicht laufenden Modus
				// entsprechende Nachrichten einsammeln
				if (!m_bIsRunning) {

					m_vecPreRunningMessages.add (oMessage);

				// andernfalls direkte Auswertung
				} else {
					PacmanSpawnedContent oPacmanSpawnedContent = (PacmanSpawnedContent)oContent;

					// Initialisieren des Schatten-Pacmans
					try {
						// Pacman-Instanz mit den Werten aus der Nachricht anlegen
						ID idPacman = oPacmanSpawnedContent.getID();
						ID[] oaID = m_oLabyrinth.getAllPacmanIds();
						boolean bPacmanAlreadyAdded = false;
						if (oaID != null) {
							for (int i = 0; i < oaID.length; i++) {
								if (idPacman.equals(oaID[i])) {
									bPacmanAlreadyAdded = true;
								}
							}
						}

						if (!bPacmanAlreadyAdded) {
							Pacman oPacman = null;
							if (oPacmanSpawnedContent.getPacmanModel().equals("")) {
								oPacman = new Pacman (idPacman, m_oLabyrinth);
							} else {
								oPacman = new Pacman (idPacman, m_oLabyrinth,
								  oPacmanSpawnedContent.getPacmanModel(), oPacmanSpawnedContent.isFriendly());
							}
							oPacman.setLineOfSight (oPacmanSpawnedContent.getLineOfSight());
							oPacman.setPacmanPos (oPacmanSpawnedContent.getPacmanPos());
							m_oLabyrinth.setPacman (idPacman, oPacman);
							m_oLabyrinth.setPacmanPos (idPacman, oPacmanSpawnedContent.getPacmanPos());

							// Pacman-Instanz in die 3d-Strukturen einfgen
							BranchGroup bgPacman = new BranchGroup();
							bgPacman.setCapability(BranchGroup.ALLOW_CHILDREN_EXTEND);
							bgPacman.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);
							bgPacman.setCapability(BranchGroup.ALLOW_CHILDREN_READ);
							bgPacman.addChild(oPacman.getJ3DNode());
							if (m_tgContent != null) { m_tgContent.addChild(bgPacman); }
							m_oLabyrinth.setPacmanBranchGroup(idPacman, bgPacman);

							// und den Blitz zum Erwachen abfeuern ;)
							m_oMessageService.addMessageListener (oPacman);

						}

					} catch (Exception ex) {
						Debug.out (this.getClass().getName(), ex, Debug.LEVEL_CRITICAL);
						return;
					}
				}

			} else if (oContent instanceof PlayerLeftContent) {

				// Nachricht wird aufgerufen, wenn ein Spieler das Spiel verlt
				PlayerLeftContent oPlayerLeftContent = (PlayerLeftContent) oContent;
				ID idPlayerLeft = oPlayerLeftContent.getPacmanID();
				Pacman oPacman = m_oLabyrinth.getPacman(idPlayerLeft);

				Debug.out (this.getClass().getName(), "player left message arrived from " + idPlayerLeft + ". Trying to remove pacman.", Debug.LEVEL_NOTICE);

				if (oPacman == null) {
					Debug.out (this.getClass().getName(), "pacman " + idPlayerLeft + " to remove not available here", Debug.LEVEL_WARNING);
				} else if (m_oLabyrinth.getActivePacmanID().equals(idPlayerLeft)) {
					Debug.out (this.getClass().getName(), "cannot remove active pacman " + idPlayerLeft, Debug.LEVEL_WARNING);
				} else {
					Debug.out (this.getClass().getName(), "removing pacman " + idPlayerLeft, Debug.LEVEL_NOTICE);
					m_oMessageService.removeMessageListener(oPacman);
					BranchGroup bgPacman = m_oLabyrinth.getPacmanBranchGroup(idPlayerLeft);
					java.util.Enumeration enum = bgPacman.getAllChildren();
					int i = 0;
					while (enum.hasMoreElements()) {
						bgPacman.removeChild(i);
						i++;
					}
					// bgPacman.removeChild(0);
					m_oLabyrinth.removePacman(idPlayerLeft);
					oPacman = null;
				}

			} else if (oContent instanceof ItemInfoContent) {
				// einige Nachrichten knnen erst verarbeitet werden, wenn ein
				// Spiel mit 3D-Elementen usw. steht, daher im nicht laufenden Modus
				// entsprechende Nachrichten einsammeln
				if (!m_bIsRunning) {

					m_vecPreRunningMessages.add (oMessage);

				// andernfalls direkte Auswertung des Nachrichteninhalts
				} else {
					ItemInfoContent oItemInfoContent = (ItemInfoContent) oContent;
					// Debug.out(this.getClass().getName(), "iteminfo message received from " + oMessage.getSender(), Debug.LEVEL_NOTICE);

					ItemHandler oItemHandler = ItemHandler.getInstance();
					pacman3d.labyrinth.items.Item oItem = oItemHandler.getItemInstance(oItemInfoContent.getItemName());
					oItem.setID (oItemInfoContent.getID());

					// in zugeordnete Zelle einfgen
					Point3i p3iCellPos = oItemInfoContent.getCellPos();
					//Debug.out(this.getClass().getName(), "- point3i is " + p3iCellPos, Debug.LEVEL_NOTICE);
					pacman3d.labyrinth.cells.Cell oCell = m_oLabyrinth.getCell(p3iCellPos);
					oCell.addItem(oItem);

					m_oMessageService.addMessageListener(oItem);

				}

			} else if (oContent instanceof LabyrinthInfoContent) {

				// ein Labyrinth-Info-Content enthlt zur Zeit die Anzahl
				// der noch nicht eingesammelten Score-Items, die an
				// das Nachrichtenpanel weitergeleitet wird. Mglicherweise
				// werden hiermit spter noch weitere Informationen
				// ausgetauscht.
				try {
					// Debug.out (this.getClass().getName(), "item count update arrived ", Debug.LEVEL_NOTICE);
					Message oNewMessage = new Message (this.getID(), oContent, m_oGameFrame.panelScore.getID());
					m_oGameFrame.panelScore.getMessage(oMessage);
					// m_oMessageService.sendMessage(oMessage, MessageService.PROPAGATE_LOCAL);
				} catch (Exception ex) {
					Debug.out (this.getClass().getName(), "cannot send update message to score panel " + ex, Debug.LEVEL_WARNING);
				}

			} else if (oContent instanceof ScoreUpdateContent) {

				Debug.out (this.getClass().getName(), "player " + oMessage.getSender() + "'s last score: " + ((ScoreUpdateContent)oContent).getScore(), Debug.LEVEL_NOTICE);
				m_iScoreContentCount++;

				// wenn von allen Pacmans die Punkte eingetroffen sind, dann Ende!
				if (m_iScoreContentCount >= m_iScoreContentMax) {

					// Spiel-Thread beenden
					m_bIsRunning = false;

					// wenn Intro angezeigt wurde, dann jetzt wieder anzeigen und danach
					// wird die Methode auch schon verlassen, die Kontrolle ist wieder
					// beim GameFrame und AWT
					if (m_bShowIntro) {
						m_oGameFrame.cleanGamePanels();
						localStartIntro();
					} else {
						System.exit(0);
					}

				}

			}

		} else {
			Debug.out (this.getClass().getName(), "no content in message found.", Debug.LEVEL_WARNING);
		}

	}

	/**
	 * startet das Spiel im SinglePlayer-Mode
	 */
	public void startGame () {

		// Netzwerkspielmethode aufrufen mit leerem Netzwerkservice
		this.startGame(null);

	}

	/**
	 * startet ein Multiplayerspiel (das wird noch dahingehend gendert,
	 * dass die Instanz des Netzwerks im Game und nicht mehr im Intro erzeugt wird!)
	 * @param oNetworkService Eine Instanz auf den Netzwerkdienst
	 */
	public void startGame (NetworkService oNetworkService) {

		/* im MultiPlayer-Mode braucht man die Netzwerkdienst-Instanz,
		die in einer Instanzvariable gehalten wird. */
		m_oNetworkService = oNetworkService;
		if (m_oNetworkService != null) {
			m_bWeAreServer = oNetworkService.isServer();
			m_bMultiplayerGame = true;
			m_bPlayerNewMessageSent = false;
			m_vecPreRunningMessages = new Vector();
			m_bEndingPhase = false;
		} else {
			m_bWeAreServer = false;
			m_bMultiplayerGame = false;
			m_bPlayerNewMessageSent = false;
			m_vecPreRunningMessages = new Vector();
			m_bEndingPhase = false;
		}

		/* vom Intro das zu spielende Level holen, falls Intro ausgefhrt wurde */
		if ( (m_oIntro != null)
		  && ( (!m_bMultiplayerGame) || ((m_bMultiplayerGame) && (m_bWeAreServer)) ) ) {
			LevelMetaInfo oLevelToLoad = m_oIntro.getSelectedLevel();
			this.m_urlLevel = oLevelToLoad.getLevelURL();
		}
		try {
			normalizeURL ();
		} catch (Exception ex) {
			Debug.out (this.getClass().getName(), "error creating URL-object for level loading: " + ex, Debug.LEVEL_CRITICAL);
			return;
		}


		/* Instanz der Poststelle holen, mit Netzwerk verbinden (wenn
		m_oNetworkService vorhanden ist, also im Multiplayermode) und uns
		selbst als Listener eintragen */
		m_oMessageService = MessageService.getInstance();
		m_oMessageService.setNetworkService (m_oNetworkService);
		m_oMessageService.addMessageListener( this, "network.state" );

		/* im Client-Multiplayermodus erfolgt hier das Absetzen einer Nachricht,
		dass ein neuer Spieler am Spiel teilnehmen will (wir!) und das Game
		wartet danach auf eine LevelToLoad-Message, bis es mit der
		Instanzierung beginnt. */
		if ((m_bMultiplayerGame) && (!m_bWeAreServer)) {

			// im MessageHandler auf Handshake und entsprechenden
			// Nachrichtenempfang warten, wenn das vom Intro noch
			// nicht erledigt ist, da Intro nicht gestartet wurde ;)
			if (m_oIntro != null) {
				Debug.out(this.getClass().getName(), "sending message PlayerNew");
				try {
					PlayerNewContent oPlayerNewContent = new PlayerNewContent(m_idSelf);
					Message oMessage = new Message (m_idSelf, oPlayerNewContent, Message.RECEIVER_ALL_GAMES);
					m_oMessageService.sendMessage(oMessage, MessageService.PROPAGATE_NETWORK, 0);
					m_bPlayerNewMessageSent = true;
				} catch (Exception ex) {
					Debug.out (this.getClass().getName(), "error sending message to server: " + ex, Debug.LEVEL_CRITICAL);
					return;
				}
			}

		} else {

			/* Im Server- und Singleplayer-Modus geht es gleich los,
			denn wir kennen ja das zu ladende Level! */
			this.localStartGame();

		}

	}

	/**
	 * startet das Spiel (die lokale Variante, die die eigentliche Arbeit macht
	 * und von SinglePlayer- und MultiPlayer-Mode gleichermaen verwandt wird.
	 */
	private void localStartGame () {

		// das eigentliche Spiel initialisieren
		Debug.out (this.getClass().getName(), "game started.", Debug.LEVEL_NOTICE);

		// zunchst das GameFrame auf das Spiel vorbereiten (wie Setzen des
		// Hauptfenster-Titels (je nach Modus))
		if (m_bMultiplayerGame) {
			m_oGameFrame.setTitle ("Pacman3D - NetworkSession");
		} else {
			m_oGameFrame.setTitle ("Pacman3D");
		}
		m_oGameFrame.prepareGamePanels();
		m_oGameFrame.setGameMode (m_bMultiplayerGame, m_bWeAreServer);

		try {
			init ();
			m_oCamera.updateCamera(1);
		} catch( Exception ex ) {
			Debug.out( getClass().getName(), ex, Debug.LEVEL_NOTICE );
			return;
		}

		// den Thread fr den GameLoop initialisieren und starten
		/*GameLoop oGameLoop = new GameLoop();
		Thread oGameThread = new Thread(oGameLoop);
		oGameThread.start();
		Debug.out( "pacman3d.Game", "gameloop started.", Debug.LEVEL_NOTICE );*/

	}

	/**
	 * startet den Gameloop und damit das Spiel (diese Methode wird vom
	 * GameStartBehavior aufgerufen, nachdem der erste Frame von Java3D
	 * gerendert wurde). Ab hier beginnt das eigentliche Spiel.
	 */
	public void startGameLoop() {

		GameLoop oGameLoop = new GameLoop();
		Thread oGameThread = new Thread(oGameLoop);
		oGameThread.start();

		Debug.out( "pacman3d.Game", "gameloop started.", Debug.LEVEL_NOTICE );
	}

	/**
	 * beendet den GameLoop durch false-Setzen der Game-Instanzvariable m_bIsRunning
	 */
	public void stopGame () {

		// aktuellen Punktestand des eigenen Pacmans ausgeben
		Debug.out(this.getClass().getName(), "last score of local pacman: " + m_oPacman.getParameter("score"));

		// Im Multiplayermodus Abmelden vom Netzwerk und anderen Spielern
		// mitteilen, dass wir weg sind
		if (m_bMultiplayerGame) {

			if (m_bWeAreServer) {

				// im Servermodus eine EndGame-Nachricht verschicken, wenn noch nicht passiert
				if (!m_bEndingPhase) {
					try {
						m_iScoreContentCount = 0;
						m_iScoreContentMax = m_oLabyrinth.getPacmanCount();

						Message oMessage = new Message (m_idSelf, "request_score_content_message_and_quit", Message.RECEIVER_ALL_PACMANS);
						m_oMessageService.sendMessage(oMessage, MessageService.PROPAGATE_NETWORK + MessageService.PROPAGATE_LOCAL, 0);
						m_bEndingPhase = true;
						return;
					} catch (Exception ex) {
						Debug.out (this.getClass().getName(), "error sending message to pacmans: " + ex, Debug.LEVEL_CRITICAL);
						return;
					}
				} else {
					return;
				}

			} else {

				// im Client-Modus nur den anderen mitteilen, dass ich weg bin
				try {
					PlayerLeftContent oPlayerLeftContent = new PlayerLeftContent(m_idSelf, m_oLabyrinth.getActivePacmanID());
					Message oMessage = new Message (m_idSelf, oPlayerLeftContent, Message.RECEIVER_ALL_GAMES);
					m_oMessageService.sendMessage(oMessage, MessageService.PROPAGATE_NETWORK, 0);
				} catch (Exception ex) {
					Debug.out (this.getClass().getName(), "error sending message to other games: " + ex, Debug.LEVEL_CRITICAL);
					return;
				}
			}

			m_oNetworkService.closeNetwork();

		}

		// Spiel-Thread beenden
		m_bIsRunning = false;

		// wenn ein zu speicherndes Levelfile angegeben ist, wird die
		// Speicherung hier vorgenommen
		if (!m_sRecordLevelFileName.equals("")) {
			try {
				m_oLabyrinth.saveLevel(m_sRecordLevelFileName);
			} catch (Exception ex) {
				Debug.out(this.getClass().getName(), ex);
			}
		}

		// Abmelden von der Poststelle und Poststelle saubermachen (falls noch ntig)
		// m_oMessageService

		// wenn Intro angezeigt wurde, dann jetzt wieder anzeigen und danach
		// wird die Methode auch schon verlassen, die Kontrolle ist wieder
		// beim GameFrame und AWT
		if (m_bShowIntro) {
			m_oGameFrame.cleanGamePanels();
			localStartIntro();
		} else {
			System.exit(0);
		}

	}

	/**
	 * beendet das Hauptprogramm durch false-Setzen der Game-Instanzvariable m_bAppIsRunning
	 */
	public void quit () {
		m_bAppIsRunning = false;

		// im Moment wird hier lediglich ein System.exit() gemacht
		System.exit(0);
	}

	/**
	 * erzeugt eine Intro-Instant, falls noch nicht geschehen, und macht
	 * das Intro sichtbar
	 */
	private void localStartIntro () {

		// Titel des Fensters setzen
		m_oGameFrame.setTitle ("Pacman3D - Intro");

		// Aufrufen der Intro-Instanz, die eine Reihe von
		// Rckgabewerten hat (zu spielendes Level, Single/Multiplayer,
		// Pacmans, Monster, Labyrinth, xxx)
		Debug.out (this.getClass().getName(), "starting intro...", Debug.LEVEL_NOTICE);
		m_oIntro = new Intro (this);
		m_oIntro.showIntro();

	}

	/**
	 * liefert das aktuelle Spielefenster zurck
	 * @return das aktuelle GameFrame
	 */
	public GameFrame getGameFrame() {
		return m_oGameFrame;
	}

	/**
	 * liefert die Nachrichten-ID des Games zurck
	 * @return die ID des Panels
	 */
	public ID getID()
	{
		return m_idSelf;
	}

	/**
	 * wenn das m_urlLevel-Objekt leer ist, wird eine neuer URL mit dem
	 * lokalen Leveldateinamen aus m_sLocalLevelFileName erzeugt und in
	 * m_urlLevel gespeichert.
	 */
	private void normalizeURL () throws java.net.MalformedURLException {

		if (this.m_urlLevel == null) {
			try {
				m_urlLevel = new URL("file:" + m_sLocalLevelFileName);
			} catch (java.net.MalformedURLException ex) {
				Debug.out (this.getClass().getName(), ex, Debug.LEVEL_CRITICAL);
				throw ex;
			}
		}
	}

	/**
	 * Initialisierungen (insbesondere pacman, monster, labyrinth, kamera,
	 * ...) hier wird auch das Spielframe auf die ntigen Elementen fr das
	 * Spiel, vorbereitet.Neben der eigentlichen 3D-Ansicht sind das eine
	 * bersichtskarte, ein Inventorybereich und die Punkteanzeige.
	 */
	public void init() throws Exception {

		// Hauptschleifenflag zunchst auf false setzen (die Schleife wird
		// nicht durchlaufen!
		m_bIsRunning = false;

		// die 3d-Ansicht erstellen
		GraphicsConfiguration oConfig = SimpleUniverse.getPreferredConfiguration();
		Canvas3D oCanvas3D = new Canvas3D(oConfig);

		// die "groe" Initialisierungsrunde fr alle bentigten Objekte
		try {

			// Initialisieren des Labyrinths
			m_oLabyrinth = new Labyrinth ();
			m_oLabyrinth.setGame(this);
			m_oLabyrinth.setWireFrameMode (m_bLabyrinthWireFrameMode);
			m_oLabyrinth.setGameMode((this.m_oNetworkService == null) ? false : true,
			  0, m_bWeAreServer, m_bDemoMode);
			m_oCamera = new Camera (m_oLabyrinth, oCanvas3D);
			m_oLabyrinth.setCamera (m_oCamera);

			// Einladen des Levels
			try {
				m_oLabyrinth.loadLevel (m_urlLevel);
			} catch (Exception ex) {
				Debug.out (this.getClass().getName(), ex, Debug.LEVEL_CRITICAL);
				throw ex;
			}

			// Initialisieren der Monsterverwaltung; Einlesen der Startpositionen und
			// anderer Monster-Eigenschaften geschieht im MonsterChannel
			if (m_iMonsterAmount != 0) {
				m_oMonsterChannel = new MonsterChannel (m_oLabyrinth, m_urlLevel);
			}

			// Initialisieren des Spieler-Pacmans (die Schatten-Pacmans
			// werden durch Nachrichten erzeugt)
			ID idPacman1 = null;
			if (!this.m_bDemoMode) {
				if ((this.m_bShowIntro) && (m_oIntro != null)) {
					m_oPacman = new Pacman (m_oLabyrinth, m_oIntro.getSelectedPacmanModel(), m_oIntro.getSelectedSpielModus());
				} else {
					m_oPacman = new Pacman (m_oLabyrinth);
				}

				idPacman1 = m_oPacman.getID();
				Position oPosition = m_oLabyrinth.getNextPacmanStartPosition(idPacman1);
				m_oPacman.setLineOfSight (oPosition.getLineOfSight());
				m_oPacman.setPacmanPos (oPosition.getPosition());
				m_oLabyrinth.setPacman (idPacman1, m_oPacman);
				m_oLabyrinth.setPacmanPos (idPacman1, oPosition.getPosition());
				m_oLabyrinth.setActivePacmanID (idPacman1);

			} else {
				// im Demomodus enthlt das Labyrinth schon einen Pacman
				idPacman1 = m_oLabyrinth.getActivePacmanID();
				m_oPacman = m_oLabyrinth.getPacman(idPacman1);
			}

			// im Multiplayermode den anderen Mitspielern sagen,
			// dass ein neuer Pacman da ist
			if (m_bMultiplayerGame) {

				PacmanSpawnedContent oPacmanSpawnedContent = null;
				if ((this.m_bShowIntro) && (m_oIntro != null)) {
					oPacmanSpawnedContent = new PacmanSpawnedContent(m_oPacman, m_oIntro.getSelectedPacmanModel(), m_oIntro.getSelectedSpielModus());
				} else {
					oPacmanSpawnedContent = new PacmanSpawnedContent(m_oPacman);
				}
				Message oMessage = new Message (m_idSelf, oPacmanSpawnedContent, Message.RECEIVER_ALL_GAMES);
				m_oMessageService.sendMessage(oMessage, MessageService.PROPAGATE_NETWORK, 0);
			}

			// Pacman und Camera-Instanzen mit der Poststelle verbinden
			m_oMessageService.addMessageListener (m_oPacman);
			m_oMessageService.addMessageListener (m_oCamera);

			// Erzeugen und Einbinden der berblicksansicht
			m_oLabyrinth.setOverview(new Overview(m_oLabyrinth));

		} catch (pacman3d.labyrinth.P3DException ex) {

			// geht was beim Konstruieren des Labyrinths schief,
			// mssen wir eine ordentliche Fehlerbehandlung einfhren
			Debug.out (this.getClass().getName(), "+ error occured during game building: "+ex, Debug.LEVEL_CRITICAL);
			throw ex;

		}

		// die Overview-Ansicht in die Swing-Panels einfgen
		m_oLabyrinth.getOverview().setSize(200,300);
		m_oGameFrame.panelOverview.add(m_oLabyrinth.getOverview(),BorderLayout.CENTER);

		// den KeyListener von pacman den verschiedenen AWT und 3D-Elementen hinzufgen
		pacman3d.pacman.KeyControl oKeyControl = new pacman3d.pacman.KeyControl(new ID(),m_oLabyrinth.getActivePacmanID(),m_oCamera.getID());
		m_oGameFrame.addKeyListener(oKeyControl);
		oCanvas3D.addKeyListener(oKeyControl);
		m_oLabyrinth.getOverview().addKeyListener(oKeyControl);

		// die eigentliche Elemente der 3d-Ansicht einbauen
		VirtualUniverse oUniverse = new VirtualUniverse();
		Locale oLocale = new Locale(oUniverse);

		// Initialisieren der Kamera
		oLocale.addBranchGraph(m_oCamera.buildViewBranch());
		oLocale.addBranchGraph(buildContentBranch());

		// und das Canvas3D in das Fenster setzen und dann endlich: Vorhang auf!
		m_oGameFrame.panelView3D.add(oCanvas3D,BorderLayout.CENTER);
		m_oGameFrame.show();

		// macht die Hauptschleife scharf (sobald dieses Flag auf false
		// geht, endet die Hauptschleife)
		m_bIsRunning = true;
		Debug.out (this.getClass().getName(), "+ initialization done.", Debug.LEVEL_NOTICE);

		// Verarbeiten der noch nicht behandelten Nachrichten, die vor dem
		// Initialisieren eingetroffen sind
		if (m_vecPreRunningMessages.size() > 0) {
			Debug.out (this.getClass().getName(), "+ processing of " + m_vecPreRunningMessages.size() + " post init messages...", Debug.LEVEL_NOTICE);
			for (int i = 0; i < m_vecPreRunningMessages.size(); i++) {
				Object oThis = m_vecPreRunningMessages.get(i);
				if (oThis instanceof Message) {
					this.getMessage((Message)oThis);
				}
			}
		}

	}

	/**
	 * generiert den Contentbranch fr die anzuzeigenden Objekte (die Labyrinth,
	 * Pacman und Monster sind).
	 */
	private BranchGroup buildContentBranch() {

		// branchgroup aufbauen, die die anzuzeigenden Elemente enthlt
		BranchGroup bgContent = new BranchGroup();
		m_tgContent = new TransformGroup();
		m_tgContent.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		m_tgContent.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		m_tgContent.setCapability(TransformGroup.ALLOW_CHILDREN_EXTEND);
		m_tgContent.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
		m_tgContent.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);
		bgContent.setCapability(TransformGroup.ALLOW_CHILDREN_EXTEND);
		bgContent.setCapability(TransformGroup.ALLOW_CHILDREN_READ);
		bgContent.setCapability(TransformGroup.ALLOW_CHILDREN_WRITE);

		// wenn der entsprechende Kommandozeilenparameter gesetzt ist,
		// werden die Mouselistener zur Rotation/Bewegung/Skalierung der
		// Szene hinzugepackt
		if (m_bUseMouseListener) {
			BoundingSphere boundsScene = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0);
			MouseBehavior bvrMouseZoom = new MouseZoom();
			bvrMouseZoom.setTransformGroup (m_tgContent);
			bvrMouseZoom.setSchedulingBounds (boundsScene);
			m_tgContent.addChild(bvrMouseZoom);
			MouseBehavior bvrMouseRotate = new MouseRotate();
			bvrMouseRotate.setTransformGroup (m_tgContent);
			bvrMouseRotate.setSchedulingBounds (boundsScene);
			m_tgContent.addChild(bvrMouseRotate);
			MouseBehavior bvrMouseTranslate = new MouseTranslate();
			bvrMouseTranslate.setTransformGroup (m_tgContent);
			bvrMouseTranslate.setSchedulingBounds (boundsScene);
			m_tgContent.addChild(bvrMouseTranslate);
		}

		// Erzeugen eines GameStartBehaviors zum Aufwachen nach einem
		// gerenderten Frame (als Ereignis zum Spielstart!)
		GameStartBehavior oGameStartBehavior = new GameStartBehavior (this);
		bgContent.addChild(oGameStartBehavior);

		// jetzt die Spiel-Elemente Labyrinth, Spieler-Pacman und Monster einfhren
		m_tgContent.addChild(m_oLabyrinth.buildContentBranch());
		m_tgContent.addChild(m_oPacman.getJ3DNode());
		if (m_iMonsterAmount != 0) { m_tgContent.addChild(m_oMonsterChannel.getJ3DNode()); }
		bgContent.addChild(m_tgContent);
		bgContent.compile();
		Debug.out (this.getClass().getName(), "scene loaded and builded in java3d.", Debug.LEVEL_NOTICE);

		return bgContent;
	}

	/**
	 * die Thread-Klasse fr die Spielschleife
	 */
	class GameLoop implements Runnable {

		/**
		 * fhrt die Aktivitt des Threads aus, was in diesem Fall die
		 * Hauptschleife des Spiels mit den Aufrufen der Tick-Methoden ist
		 */
		public void run() {

			/* Variablen fr die Timestampes der letzten Aufrufe der undertick-Routinen */
			long lTimeLoopBegin = 0;
			long lLastCallPacman = System.currentTimeMillis();
			long lLastCallMonster = System.currentTimeMillis();
			long lLastCallCamera = System.currentTimeMillis();
			int iDeltaTicks = 0;

			// Eintritt in die Hauptschleife
			Debug.out (this.getClass().getName(), "+ running in game loop...", Debug.LEVEL_NOTICE);
			while (m_bIsRunning) {

				// hier werden die makeLoop()-Methoden der einzelnen Objekte aufgerufen
				lTimeLoopBegin = System.currentTimeMillis();

				iDeltaTicks = (int) (System.currentTimeMillis() - lLastCallPacman) / m_ciMillisPerTick;
				if (iDeltaTicks > 1) {
					ID[] oaPacmanIDs = m_oLabyrinth.getAllPacmanIds();
					for (int i = 0; i < oaPacmanIDs.length; i++) {
						m_oLabyrinth.getPacman(oaPacmanIDs[i]).makeLoop(iDeltaTicks);
					}
					lLastCallPacman = System.currentTimeMillis();
				}
				//iDeltaTicks = (int) (System.currentTimeMillis() - lTimeLoopBegin) / m_ciMillisPerTick;
				//Debug.out (this.getClass().getName(), "ticks consumed by pacmans: " + iDeltaTicks, Debug.LEVEL_NOTICE);

				iDeltaTicks = (int) (System.currentTimeMillis() - lLastCallCamera) / m_ciMillisPerTick;
				if (iDeltaTicks > 10) {
					m_oCamera.updateCamera(iDeltaTicks);
					lLastCallCamera = System.currentTimeMillis();
				}
				//iDeltaTicks = (int) (System.currentTimeMillis() - lTimeLoopBegin) / m_ciMillisPerTick;
				//Debug.out (this.getClass().getName(), "ticks consumed by camera: " + iDeltaTicks, Debug.LEVEL_NOTICE);

				if (m_iMonsterAmount != 0) {
					iDeltaTicks = (int) (System.currentTimeMillis() - lLastCallMonster) / m_ciMillisPerTick;
					if (iDeltaTicks > 1) {
						m_oMonsterChannel.makeLoop (iDeltaTicks);
						lLastCallMonster = System.currentTimeMillis();
					}
					//iDeltaTicks = (int) (System.currentTimeMillis() - lTimeLoopBegin) / m_ciMillisPerTick;
					//Debug.out (this.getClass().getName(), "ticks consumed by monsters: " + iDeltaTicks, Debug.LEVEL_NOTICE);
				}

				// wird an dieser Stelle noch ein waitstate stehen? evtl.
				// fr die Synchronisation mit anderen Spielern? lassen wir
				// den Thread erstmal fr 20ms schlafen hier...

				try {
					Thread.currentThread().sleep(20);
				} catch (InterruptedException ex) {
					Debug.out (this.getClass().getName(), "thread aufgeweckt", Debug.LEVEL_NOTICE);
				}
			}

			Debug.out (this.getClass().getName(), "+ left game loop...", Debug.LEVEL_NOTICE);

		}

	}

	/**
	 * Deinitialisierungen (insbesondere pacman, monster, labyrinth, kamera, ...)
	 */
	public void done () {
		Debug.out (this.getClass().getName(), "+ deinitialization done.", Debug.LEVEL_NOTICE);
	}

	/**
	 * Konstruktor der Klasse. Bei diesem luft nicht viel...
	 */
	public Game() {
		// eindeutige ID besorgen und Statusmeldung raus!
		this.m_idSelf = new pacman3d.message.ID();
		Debug.out(this.getClass().getName(), "message-id of game is: " + this.m_idSelf, Debug.LEVEL_NOTICE);
	}

	/**
	 * Zweiter Konstruktor der Klasse, der das Parameter-Array empfngt und
	 * optionale Parameter ausliest.
	 */
	public Game(String[] asArgs) {
		this();

		// Durchlaufen aller Kommandozeilenparameter und Extrahieren der
		// Informationen (dispatcher fr die diversen Parameterkeywords)
		int iCurrArgNo = 0;
		while (iCurrArgNo < asArgs.length) {

			// gibt die Kommandozeilenhilfe aus
			if (asArgs[iCurrArgNo].equalsIgnoreCase("--help")) {
				outputCommandLineHelp(true);
			}
			// unterdrckt die Anzeige des Intros und geht direkt
			// zum Defaultlevel (im Quelltext hart codiert) oder dem
			// per Argument bergebenen Leveldateinamen
			else if (asArgs[iCurrArgNo].equalsIgnoreCase("--withoutintro")) {
				m_bShowIntro = false;
			}
			// bergibt den Dateinamen des zu ladenden Levels (nur
			// ohne Anzeige des Intros sinnvoll, da die Auswahl im
			// Intromen den Dateinamen sonst berschreibt!)
			else if (asArgs[iCurrArgNo].equalsIgnoreCase("--levelfile")) {

				// das nchste Argument mu dann der Dateiname
				// des Levels sein
				if (iCurrArgNo +1 < asArgs.length) {
					iCurrArgNo++;
					m_sLocalLevelFileName = asArgs[iCurrArgNo];
				} else {
					System.out.print ("Angabe des Levels nach Parameter --levelfile fehlt\n");
					outputCommandLineHelp (true);
				}
			}
			// bergibt den Dateinamen, in dem das Level nach dem Spiel
			// gespeichert werden soll (ntig fr das Speichern der Daten
			// des "Makrorecorders" von Pacman fr den Demomode)
			else if (asArgs[iCurrArgNo].equalsIgnoreCase("--recordfile")) {

				// das nchste Argument mu dann der neue Dateiname sein
				if (iCurrArgNo +1 < asArgs.length) {
					iCurrArgNo++;
					m_sRecordLevelFileName = asArgs[iCurrArgNo];
				} else {
					System.out.print ("Angabe eines Dateinamens nach Parameter --recordfile fehlt\n");
					outputCommandLineHelp (true);
				}
			}
			// Aktivierung von Mouselistenern zum rotieren/skalieren/
			// translieren der gesamten 3D-Szene im Spielfenster
			else if (asArgs[iCurrArgNo].equalsIgnoreCase("--withmouselistener")) {
				m_bUseMouseListener = true;
			}
			// setzt den Labyrinth-Modus, der nur Linienwrfel statt
			// der vollen Zellenausgabe fr nicht-begehbare Zellen
			// zeichnet
			else if (asArgs[iCurrArgNo].equalsIgnoreCase("--wireframesonly")) {
				m_bLabyrinthWireFrameMode = true;
			}
			// setzt den Demo-Modus, bei dem automatische Bewegungen des
			// Player-Pacman, die im Levelfile definiert sind, abgefahren
			// werden.
			else if (asArgs[iCurrArgNo].equalsIgnoreCase("--demomode")) {
				m_bDemoMode = true;
			}
			// setzt den Debuglevel (Wert steht im folgenden Argument)
			else if (asArgs[iCurrArgNo].equalsIgnoreCase("--debuglevel")) {

				// das nchste Argument mu dann der Wert des
				// Debuglevels sein
				if (iCurrArgNo +1 < asArgs.length) {
					iCurrArgNo++;
					String sDebugLevel = asArgs[iCurrArgNo].toLowerCase();
					if (sDebugLevel.equals("notice")) {
						Debug.setDebugLevel(Debug.LEVEL_NOTICE);
					} else if (sDebugLevel.equals("warning")) {
						Debug.setDebugLevel(Debug.LEVEL_WARNING);
					} else if (sDebugLevel.equals("critical")) {
						Debug.setDebugLevel(Debug.LEVEL_CRITICAL);
					} else {
						System.out.print ("Nur Debuglevel notice, warning und critial mglich\n");
						outputCommandLineHelp (true);
					}
				} else {
					System.out.print ("Angabe des Debuglevels nach Parameter --debuglevel fehlt\n");
					outputCommandLineHelp (true);
				}
			}
			// startet ein Netzwerkspiel im Servermodus mit der angegebenen Hostadresse
			else if (asArgs[iCurrArgNo].equalsIgnoreCase("--servermode")) {

				this.m_bWeAreServer = true;
				this.m_bMultiplayerGame = true;

				// das nchste Argument mu dann die/der IP-Adresse/Hostname
				// sein, die fr den Server verwendet werden soll
				if (iCurrArgNo +1 < asArgs.length) {
					iCurrArgNo++;
					m_sHost = asArgs[iCurrArgNo];
				} else {
					System.out.print ("Hostangabe nach Parameter --servermode fehlt\n");
					outputCommandLineHelp (true);
				}
			}
			// startet ein Netzwerkspiel im Clientmodus mit der angegebenen Hostadresse
			else if (asArgs[iCurrArgNo].equalsIgnoreCase("--clientmode")) {

				this.m_bWeAreServer = false;
				this.m_bMultiplayerGame = true;

				// das nchste Argument mu dann die/der IP-Adresse/Hostname
				// sein, mit der zum Server connected werden soll
				if (iCurrArgNo +1 < asArgs.length) {
					iCurrArgNo++;
					m_sHost = asArgs[iCurrArgNo];
				} else {
					System.out.print ("Hostangabe nach Parameter --clientmode fehlt\n");
					outputCommandLineHelp (true);
				}
			}
			// setzt die Anzahl der instanzierten Monster (
			else if (asArgs[iCurrArgNo].equalsIgnoreCase("--monsteramount")) {

				// das nchste Argument mu dann die/der IP-Adresse/Hostname
				// sein, mit der zum Server connected werden soll
				if (iCurrArgNo +1 < asArgs.length) {
					iCurrArgNo++;
					String sMonsterAmount = asArgs[iCurrArgNo];
					try {
						m_iMonsterAmount = new Integer(sMonsterAmount).intValue();
					} catch (Exception ex) {
						System.out.print ("Falsches Format fr Parameter --monsteramount [Zahl]\n");
						outputCommandLineHelp (true);
					}
				} else {
					System.out.print ("Zahlenangabe nach Parameter --monsteramount fehlt\n");
					outputCommandLineHelp (true);
				}
			}

			iCurrArgNo++;
		}

		// einige weitere Ideen fr Kommandozeilenargumente:
		//  - Spiel mit Monstern / gewnschter Anzahl Monster starten
		//    (in Zusammenspiel mit den Daten, die vom Level kommen)
		//  - Netzwerkspiel / Client, Server / Adresse

	}

	/**
	 * gibt die mglichen Kommandozeilenparameter, ihre Optionen und
	 * Funktionsbeschreibung aus.
	 * @param bExit wenn gesetzt, dann wird Applikation beendet
	 */
	private void outputCommandLineHelp (boolean bExit) {

		// Ausgabe der mglichen Kommandozeilenoptionen
		System.out.println ("Pacman3D - Hilfe fuer die Kommandozeilenparameter\n");

		System.out.println (
			"--help               zeigt diese Liste der moeglichen Kommandozeilenparameter,\n" +
			"                     ihrer Optionen und Funktionsweise\n" +
			"--withoutintro       startet Pacman3D ohne Intro und laedt direkt das Default-\n" +
			"                     Level oder das mit dem --levelfiuee bergebene Level\n" +
			"--levelfile          laedt das angegebene Level mit dem Dateinamen filename,\n" +
			"  [ filename ]       wenn der Parameter --withoutintro ebenfalls angegeben\n" +
			"                     wurde. Zu beachten ist, dass der Pfad relativ zum \n" +
			"                     aktuellen Verzeichnis gesetzt sein muss (also \n" +
			"                     beispielsweise filename = level/level_10x10.p3d)\n" +
			"--withmouselistener  aktiviert Mouselistener fr die gesamte Spielszene, mit\n" +
			"                     denen Rotation, Translation und Skalierung vorgenommen\n" +
			"                     werden koennen\n" +
			"--wireframesonly     statt der ausgefuellten Zellen des Labyrinths werden nur\n"+
			"                     Linienquader gezeichnet, was insbesondere fuer grosse\n" +
			"                     Level auf leistungsschwaecheren Rechnern interessant ist\n" +
			"--debuglevel         setzt den Debugmodus des Spiels. critical beinhaltet\n" +
			"  [ notice |         schwere Fehler, warning in bestimmten Situationen\n" +
			"    warning |        unguenstige aber nicht kritische Probleme und notice\n" +
			"    critical ]       einfache Statusmeldungen.\n" +
			"--servermode         startet ein Netzwerkspiel im Servermodus. Der Zusatz host\n" +
			"  host               ist eine IP-Adresse oder ein Hostname, mit dem der Server\n" +
			"                     auf Clientanfragen horchen soll (ntig, wenn mehrere IPs\n" +
			"                     im lokalen Rechner vorhanden sind)\n" +
			"--clientmode         startet ein Netzwerkspiel im Clientmodus. Der Zusatz host\n" +
			"  host               ist die IP-Adresse bzw. der Hostname des Zielservers\n" +
			"--monsteramount      setzt die Anzahl der Monster auf den Zusatz n. Es werden\n" +
			"  n                  allerdings nur maximal so viele Monster geladen, wie im\n" +
			"                     Level vorgesehen. Im Netzwerkspiel hat die Einstellung nur\n" +
			"                     Auswirkungen auf dem Rechner, auf dem die Monster erzeugt\n" +
			"                     werden (= Serverrechner)\n"
			);

		// wenn Parameter bExit gesetzt, dann wird hier beendet
		if (bExit) {
			System.exit ( -1 );
		}
	}

	/**
	 * Ausfhrungsmethode der Klasse, ruft die Initialisierungs-, die Ausfhrungs- und
	 * die Deinitalisierungsmethoden auf. Auch der Aufruf von Intro/Men sind
	 * hier in einem Loop platziert, also gewissermaen der uere "gameloop"
	 */
	public int execute () {

		//  das Hauptfenster bereitstellen, dass von Intro und Spiel benutzt wird
		m_oGameFrame = new GameFrame();

		//  hier wird jetzt die Kontrolle an das Intro bergeben, das
		// seinerseits irgendwann ein Spiel startet oder das Programm
		// beendet oder auch direkt zum Spiel gesprungen, wenn das von der
		// Kommandozeile her gewnscht wird.
		boolean bAppIsRunning = true;
		if (m_bShowIntro) {
			localStartIntro();
		} else {
			m_oNetworkService = null;
			if (m_bMultiplayerGame) {
				if (m_bWeAreServer)
					m_oNetworkService = new TCPServer(m_sHost);
				else
					m_oNetworkService = new TCPClient(m_sHost);
				m_oNetworkService.startNetwork();
			}

			// Spiel starten
			startGame(m_oNetworkService);
		}

		// vorlufig wird 0 zurckgegeben. Spter kann hier auch ein
		// Errorcode durchgeschleift werden, was insb. fr Debugging
		// praktisch sein knnte.
		return 0;
	}

	/**
	 * Java-Applikations-Einsprungpunkt
	 */
	public static void main(String[] args) {

		// Debugklasse konfigurieren (sollte im Final-Build umgebaut werden!)
		Debug.setCharsPerLine(240);

		// Spielsteuerung starten
		try {
			Game gameInstance = new Game(args);
			int iReturnCode = gameInstance.execute();
			if (iReturnCode == 0) {
				Debug.out( "pacman3d.Game", "exiting main()-method, threads are running.", Debug.LEVEL_NOTICE );
			} else {
				System.exit (iReturnCode);
			}
		} catch (Exception ex) {
			System.out.println ("error: " + ex);
			ex.printStackTrace();
		}


	}

}