/*
 * Decompiled with CFR 0.152.
 */
package ncsa.vecmath;

import java.util.Enumeration;
import java.util.Vector;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class TriangleDeconstructor {
    static boolean DEBUG_ROTATION = false;
    static boolean DEBUG_FIGUREZVECTOR = false;
    static boolean DEBUG_MAKETRIANGLES = false;

    public static Point3d[][] destruct(Point3d[] point3dArray) {
        if (point3dArray.length <= 3) {
            Point3d[][] point3dArray2 = new Point3d[1][point3dArray.length];
            int n = 0;
            while (n < point3dArray.length) {
                point3dArray2[0][n] = point3dArray[n];
                ++n;
            }
            return point3dArray2;
        }
        Matrix4d matrix4d = TriangleDeconstructor.figureTranslation(point3dArray);
        TriangleDeconstructor.multiply(matrix4d, point3dArray);
        Vector3d vector3d = TriangleDeconstructor.figureXVector(point3dArray);
        Vector3d vector3d2 = TriangleDeconstructor.figureYVector(vector3d);
        Vector3d vector3d3 = TriangleDeconstructor.figureZVector(vector3d, vector3d2);
        Matrix4d matrix4d2 = TriangleDeconstructor.figureRotation(vector3d, vector3d2, vector3d3);
        TriangleDeconstructor.multiply(matrix4d2, point3dArray);
        Point3d[][] point3dArray3 = TriangleDeconstructor.makeConvexPolygons(point3dArray);
        Point3d[][] point3dArray4 = TriangleDeconstructor.makeTriangles(point3dArray3);
        matrix4d2.invert();
        TriangleDeconstructor.multiply(matrix4d2, point3dArray);
        matrix4d.invert();
        TriangleDeconstructor.multiply(matrix4d, point3dArray);
        return point3dArray4;
    }

    static void dump(Point3d[] point3dArray) {
        int n = 0;
        while (n < point3dArray.length) {
            System.out.println(point3dArray[n]);
            ++n;
        }
        System.out.println("**************************");
    }

    static Matrix4d figureRotation(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        Matrix4d matrix4d = new Matrix4d(vector3d.x, vector3d.y, vector3d.z, 0.0, vector3d2.x, vector3d2.y, vector3d2.z, 0.0, vector3d3.x, vector3d3.y, vector3d3.z, 0.0, 0.0, 0.0, 0.0, 1.0);
        if (DEBUG_ROTATION) {
            System.out.println(matrix4d);
        }
        return matrix4d;
    }

    static Matrix4d figureTranslation(Point3d[] point3dArray) {
        Matrix4d matrix4d = new Matrix4d();
        Vector3d vector3d = new Vector3d(-point3dArray[0].x, -point3dArray[0].y, -point3dArray[0].z);
        matrix4d.set(vector3d);
        return matrix4d;
    }

    static Vector3d figureXVector(Point3d[] point3dArray) {
        Vector3d vector3d = new Vector3d(point3dArray[1].x, point3dArray[1].y, point3dArray[1].z);
        vector3d.normalize();
        if (DEBUG_ROTATION) {
            System.out.println("figureXVector " + vector3d);
        }
        return vector3d;
    }

    static Vector3d figureYVector(Vector3d vector3d) {
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d(1.0, 0.0, 0.0);
        vector3d2.cross(vector3d3, vector3d);
        vector3d2.normalize();
        if (DEBUG_ROTATION) {
            System.out.println("figureYVector " + vector3d2);
        }
        return vector3d2;
    }

    static Vector3d figureYVector(Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d, vector3d2);
        vector3d3.normalize();
        if (DEBUG_ROTATION) {
            System.out.println("figureYVector " + vector3d3);
        }
        return vector3d3;
    }

    static Vector3d figureZVector(Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d, vector3d2);
        vector3d3.normalize();
        if (DEBUG_ROTATION) {
            System.out.println("figureZVector " + vector3d3);
        }
        return vector3d3;
    }

    static Vector3d figureZVector(Point3d[] point3dArray) {
        if (DEBUG_FIGUREZVECTOR) {
            System.out.println("######figureZVector###################");
        }
        Vector3d vector3d = new Vector3d(point3dArray[1].x, point3dArray[1].y, point3dArray[1].z);
        Vector3d vector3d2 = new Vector3d(point3dArray[2].x, point3dArray[2].y, point3dArray[2].z);
        Vector3d vector3d3 = new Vector3d(point3dArray[3].x, point3dArray[3].y, point3dArray[3].z);
        if (DEBUG_FIGUREZVECTOR) {
            System.out.println("p1 " + vector3d);
            System.out.println("p2 " + vector3d2);
            System.out.println("p3 " + vector3d3);
        }
        vector3d2.sub((Tuple3d)vector3d);
        vector3d3.sub((Tuple3d)vector3d);
        if (DEBUG_FIGUREZVECTOR) {
            System.out.println("p2-p1 " + vector3d2);
            System.out.println("p3-p1 " + vector3d3);
        }
        vector3d.cross(vector3d2, vector3d3);
        if (DEBUG_FIGUREZVECTOR) {
            System.out.println("p2Xp3 " + vector3d);
        }
        vector3d.normalize();
        if (DEBUG_FIGUREZVECTOR) {
            System.out.println("normalized " + vector3d);
            System.out.println("#############################");
        }
        if (DEBUG_ROTATION) {
            System.out.println("figureZVector " + vector3d);
        }
        return vector3d;
    }

    public static void main(String[] stringArray) {
        if (!TriangleDeconstructor.parseArgs(stringArray)) {
            return;
        }
        Point3d[][] point3dArray = TriangleDeconstructor.makeTests();
        int n = 0;
        while (n < point3dArray.length) {
            int n2 = 0;
            while (n2 < point3dArray[n].length) {
                System.out.print(String.valueOf(String.valueOf(point3dArray[n][n2])) + " ");
                ++n2;
            }
            System.out.println("");
            System.out.println("***************");
            Point3d[][] point3dArray2 = TriangleDeconstructor.destruct(point3dArray[n]);
            int n3 = 0;
            while (n3 < point3dArray2.length) {
                int n4 = 0;
                while (n4 < point3dArray2[n3].length) {
                    System.out.print(String.valueOf(String.valueOf(point3dArray2[n3][n4])) + " ");
                    ++n4;
                }
                System.out.println(" ");
                ++n3;
            }
            System.out.println("---------------");
            ++n;
        }
    }

    static Point3d[][] makeConvexPolygons(Point3d[] point3dArray) {
        Point3d[][] point3dArray2 = new Point3d[1][point3dArray.length];
        int n = 0;
        while (n < point3dArray.length) {
            point3dArray2[0][n] = point3dArray[n];
            ++n;
        }
        return point3dArray2;
    }

    static Point3d[][] makeTests() {
        Point3d[][] point3dArray = new Point3d[][]{new Point3d[4]};
        point3dArray[0][0] = new Point3d(1.0, 1.0, 0.0);
        point3dArray[0][1] = new Point3d(0.0, 2.0, 0.0);
        point3dArray[0][2] = new Point3d(2.0, 2.0, 0.0);
        point3dArray[0][3] = new Point3d(2.0, 0.0, 0.0);
        return point3dArray;
    }

    static Point3d[][] makeTriangles(Point3d[][] point3dArray) {
        Vector<Point3d[]> vector = new Vector<Point3d[]>();
        int n = 0;
        while (n < point3dArray.length) {
            int n2 = 1;
            while (n2 + 1 < point3dArray[n].length) {
                Point3d[] point3dArray2 = new Point3d[]{point3dArray[n][0], point3dArray[n][n2], point3dArray[n][n2 + 1]};
                vector.addElement(point3dArray2);
                ++n2;
            }
            ++n;
        }
        if (DEBUG_MAKETRIANGLES) {
            System.out.println("We have " + vector.size() + " triangles in the vector");
        }
        Point3d[][] point3dArray3 = new Point3d[vector.size()][];
        int n3 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            point3dArray3[n3++] = (Point3d[])enumeration.nextElement();
        }
        return point3dArray3;
    }

    static void multiply(Matrix4d matrix4d, Point3d[] point3dArray) {
        int n = 0;
        while (n < point3dArray.length) {
            matrix4d.transform(point3dArray[n]);
            ++n;
        }
    }

    static void multiply(Matrix4d matrix4d, Point3d[][] point3dArray) {
        int n = 0;
        while (n < point3dArray.length) {
            int n2 = 0;
            while (n2 < point3dArray[n].length) {
                matrix4d.transform(point3dArray[n][n2]);
                ++n2;
            }
            ++n;
        }
    }

    static boolean parseArgs(String[] stringArray) {
        if (stringArray.length == 0) {
            return true;
        }
        if (stringArray[0].compareTo("help") == 0) {
            System.out.println("rotation to see the rotation vectors");
            System.out.println("triangles to see how many triangle are made");
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].compareTo("rotation") == 0) {
                DEBUG_ROTATION = true;
            }
            if (stringArray[n].compareTo("vectors") == 0) {
                DEBUG_FIGUREZVECTOR = true;
            }
            if (stringArray[n].compareTo("triangles") == 0) {
                DEBUG_MAKETRIANGLES = true;
            }
            ++n;
        }
        return true;
    }

    static void reverseWinding(Point3d[] point3dArray) {
        int n = 1;
        while (n < Math.round((float)point3dArray.length / 2.0f)) {
            Point3d point3d = point3dArray[point3dArray.length - n];
            point3dArray[point3dArray.length - n] = point3dArray[n];
            point3dArray[n] = point3d;
            ++n;
        }
    }

    static float signedArea(Point3d[] point3dArray) {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = 0;
        while (n < point3dArray.length - 1) {
            f = (float)((double)f + point3dArray[n].x * point3dArray[n + 1].y);
            f2 = (float)((double)f2 - point3dArray[n + 1].x * point3dArray[n].y);
            ++n;
        }
        return (f + f2) / 2.0f;
    }
}

