/*
 * Decompiled with CFR 0.152.
 */
package ncsa.vecmath;

import java.util.Arrays;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import ncsa.vecmath.PointInfo;
import ncsa.vecmath.PointInfoComparator;
import ncsa.vecmath.PointInfoIndexComparator;

public class PolygonTools {
    public static double area(Point3d[] point3dArray) {
        double d = 0.0;
        int n = 0;
        while (n < point3dArray.length - 1) {
            d += point3dArray[n].x * point3dArray[n + 1].y;
            d -= point3dArray[n + 1].x * point3dArray[n].y;
            ++n;
        }
        return d / 2.0;
    }

    public static double area(Point3d[] point3dArray, Vector3d vector3d) {
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        int n = 0;
        while (n < point3dArray.length - 1) {
            vector3d4.set((Tuple3d)point3dArray[n]);
            vector3d5.set((Tuple3d)point3dArray[n + 1]);
            vector3d2.cross(vector3d4, vector3d5);
            vector3d3.add((Tuple3d)vector3d2);
            ++n;
        }
        return vector3d3.dot(vector3d) / 2.0;
    }

    public static double area(Point3d[] point3dArray, Vector3f vector3f) {
        Vector3d vector3d = new Vector3d((double)vector3f.x, (double)vector3f.y, (double)vector3f.z);
        return PolygonTools.area(point3dArray, vector3d);
    }

    public static Vector3f[] calculateIndexedNormals(Point3d[] point3dArray, int[] nArray, float f, int n) {
        int n2;
        Vector3f[] vector3fArray;
        Vector3f[] vector3fArray2 = PolygonTools.calculateIndexedSurfaceNormals(point3dArray, nArray, n);
        int n3 = vector3fArray2.length;
        PointInfo[] pointInfoArray = new PointInfo[n3];
        PointInfoComparator pointInfoComparator = new PointInfoComparator();
        int n4 = 0;
        while (n4 < n3) {
            pointInfoArray[n4] = new PointInfo(n4, point3dArray[nArray[n4]], vector3fArray2[n4]);
            ++n4;
        }
        Arrays.sort(pointInfoArray, pointInfoComparator);
        Vector3f[] vector3fArray3 = pointInfoArray[0];
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        Vector3f vector3f = vector3fArray3.getSurfaceNormal();
        boolean bl = false;
        int n8 = 1;
        while (n8 < n3) {
            vector3fArray = pointInfoArray[n8];
            n2 = pointInfoComparator.compare(vector3fArray3, vector3fArray);
            if (n2 == 0) {
                vector3f.add((Tuple3f)vector3f, (Tuple3f)vector3fArray.getSurfaceNormal());
                ++n5;
                n7 = n8;
                bl = true;
            } else {
                vector3f.scale(1.0f / (float)n5);
                int n9 = n6;
                while (n9 <= n7) {
                    pointInfoArray[n9].setPointNormal(vector3f);
                    ++n9;
                }
                n6 = n7 + 1;
                vector3fArray3 = vector3fArray;
                n5 = 1;
                vector3f = vector3fArray3.getSurfaceNormal();
                bl = false;
            }
            ++n8;
        }
        if (bl) {
            vector3f.scale(1.0f / (float)n5);
            int n10 = n6;
            while (n10 < n3) {
                pointInfoArray[n10].setPointNormal(vector3f);
                ++n10;
            }
        }
        Arrays.sort(pointInfoArray, new PointInfoIndexComparator());
        vector3fArray = new Vector3f[n3];
        n2 = 0;
        while (n2 < n3) {
            vector3fArray[n2] = pointInfoArray[n2].getPointNormal();
            ++n2;
        }
        return vector3fArray;
    }

    public static Vector3f[] calculateIndexedSurfaceNormals(Point3d[] point3dArray, int[] nArray, int n) {
        Vector3f[] vector3fArray = new Vector3f[point3dArray.length];
        boolean bl = false;
        int n2 = nArray.length;
        int n3 = n - 2;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n4;
            Point3d point3d = point3dArray[nArray[n4]];
            Point3d point3d2 = point3dArray[nArray[n4 + 1]];
            Point3d point3d3 = point3dArray[nArray[n4 + 2]];
            Vector3f vector3f = PolygonTools.normal(point3d, point3d2, point3d3);
            int n6 = n5;
            while (n6 < n5 + n) {
                vector3fArray[nArray[n6]] = new Vector3f(vector3f);
                ++n6;
            }
            n4 += n;
        }
        return vector3fArray;
    }

    public static Vector3f[] calculateSurfaceNormals(Point3d[] point3dArray) {
        Vector3f[] vector3fArray;
        Vector3f[] vector3fArray2 = new Vector3f[100];
        int n = 0;
        int n2 = 0;
        while (n2 < point3dArray.length) {
            if (vector3fArray2.length - n < 3) {
                vector3fArray = new Vector3f[vector3fArray2.length + 100];
                System.arraycopy(vector3fArray2, 0, vector3fArray, 0, vector3fArray2.length);
                vector3fArray2 = vector3fArray;
            }
            vector3fArray = point3dArray[n2++];
            Point3d point3d = point3dArray[n2++];
            Point3d point3d2 = point3dArray[n2++];
            vector3fArray2[n++] = PolygonTools.normal((Point3d)vector3fArray, point3d, point3d2);
            vector3fArray2[n++] = PolygonTools.normal((Point3d)vector3fArray, point3d, point3d2);
            vector3fArray2[n++] = PolygonTools.normal((Point3d)vector3fArray, point3d, point3d2);
            ++n2;
        }
        vector3fArray = new Vector3f[n];
        System.arraycopy(vector3fArray2, 0, vector3fArray, 0, n);
        vector3fArray2 = vector3fArray;
        return vector3fArray2;
    }

    public static Vector3f[] calculateSurfaceNormals(Point3f[] point3fArray, int n) {
        Vector3f[] vector3fArray;
        Vector3f[] vector3fArray2 = new Vector3f[100];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (vector3fArray2.length - n2 < 3) {
                vector3fArray = new Vector3f[vector3fArray2.length + 100];
                System.arraycopy(vector3fArray2, 0, vector3fArray, 0, vector3fArray2.length);
                vector3fArray2 = vector3fArray;
            }
            vector3fArray = point3fArray[n3++];
            Point3f point3f = point3fArray[n3++];
            Point3f point3f2 = point3fArray[n3++];
            vector3fArray2[n2++] = PolygonTools.normal((Point3f)vector3fArray, point3f, point3f2);
            vector3fArray2[n2++] = PolygonTools.normal((Point3f)vector3fArray, point3f, point3f2);
            vector3fArray2[n2++] = PolygonTools.normal((Point3f)vector3fArray, point3f, point3f2);
        }
        vector3fArray = new Vector3f[n2];
        System.arraycopy(vector3fArray2, 0, vector3fArray, 0, n2);
        vector3fArray2 = vector3fArray;
        return vector3fArray2;
    }

    public static void dump(Point3d[] point3dArray) {
        System.out.println("****START POLYGON VERTEX LIST****" + point3dArray);
        int n = 0;
        while (n < point3dArray.length) {
            System.out.println(point3dArray[n]);
            ++n;
        }
        System.out.println("****END POLYGON VERTEX LIST****" + point3dArray);
    }

    public static Vector3f normal(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        Vector3f vector3f5 = new Vector3f();
        Vector3f vector3f6 = new Vector3f();
        vector3f.set((Tuple3d)point3d);
        vector3f2.set((Tuple3d)point3d2);
        vector3f3.set((Tuple3d)point3d3);
        vector3f5.sub((Tuple3f)vector3f, (Tuple3f)vector3f2);
        vector3f6.sub((Tuple3f)vector3f2, (Tuple3f)vector3f3);
        vector3f4.cross(vector3f5, vector3f6);
        return vector3f4;
    }

    public static Vector3f normal(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        Vector3f vector3f5 = new Vector3f();
        Vector3f vector3f6 = new Vector3f();
        vector3f.set((Tuple3f)point3f);
        vector3f2.set((Tuple3f)point3f2);
        vector3f3.set((Tuple3f)point3f3);
        vector3f5.sub((Tuple3f)vector3f, (Tuple3f)vector3f2);
        vector3f6.sub((Tuple3f)vector3f2, (Tuple3f)vector3f3);
        vector3f4.cross(vector3f5, vector3f6);
        return vector3f4;
    }

    public static Vector3f normal(Point3d[] point3dArray) {
        return PolygonTools.normal(point3dArray[0], point3dArray[1], point3dArray[2]);
    }

    public static Vector3f normal(Point3f[] point3fArray) {
        return PolygonTools.normal(point3fArray[0], point3fArray[1], point3fArray[2]);
    }

    public static Vector3f[] pointNormals(Point3d[] point3dArray, int n, Vector3f[] vector3fArray, float f) {
        int n2;
        Vector3f[] vector3fArray2;
        int n3 = n;
        PointInfo[] pointInfoArray = new PointInfo[n3];
        PointInfoComparator pointInfoComparator = new PointInfoComparator();
        int n4 = 0;
        while (n4 < n3) {
            pointInfoArray[n4] = new PointInfo(n4, point3dArray[n4], vector3fArray[n4]);
            ++n4;
        }
        Arrays.sort(pointInfoArray, pointInfoComparator);
        Vector3f[] vector3fArray3 = pointInfoArray[0];
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        Vector3f vector3f = vector3fArray3.getSurfaceNormal();
        boolean bl = false;
        int n8 = 1;
        while (n8 < n3) {
            vector3fArray2 = pointInfoArray[n8];
            n2 = pointInfoComparator.compare(vector3fArray3, vector3fArray2);
            if (n2 == 0) {
                vector3f.add((Tuple3f)vector3f, (Tuple3f)vector3fArray2.getSurfaceNormal());
                ++n5;
                n7 = n8;
                bl = true;
            } else {
                vector3f.scale(1.0f / (float)n5);
                int n9 = n6;
                while (n9 <= n7) {
                    pointInfoArray[n9].setPointNormal(vector3f);
                    ++n9;
                }
                n6 = n7 + 1;
                vector3fArray3 = vector3fArray2;
                n5 = 1;
                vector3f = vector3fArray3.getSurfaceNormal();
                bl = false;
            }
            ++n8;
        }
        if (bl) {
            vector3f.scale(1.0f / (float)n5);
            int n10 = n6;
            while (n10 < n3) {
                pointInfoArray[n10].setPointNormal(vector3f);
                ++n10;
            }
        }
        Arrays.sort(pointInfoArray, new PointInfoIndexComparator());
        vector3fArray2 = new Vector3f[n3];
        n2 = 0;
        while (n2 < n3) {
            vector3fArray2[n2] = pointInfoArray[n2].getPointNormal();
            ++n2;
        }
        return vector3fArray2;
    }

    public static void reverseWinding(Point3d[] point3dArray) {
        int n = 1;
        while (n < Math.round((float)point3dArray.length / 2.0f)) {
            Point3d point3d = point3dArray[point3dArray.length - n];
            point3dArray[point3dArray.length - n] = point3dArray[n];
            point3dArray[n] = point3d;
            ++n;
        }
    }
}

