/*
 * Decompiled with CFR 0.152.
 */
package ncsa.vecmath;

import java.util.Vector;
import javax.media.j3d.IndexedTriangleArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import ncsa.vecmath.IndexedInfo;
import ncsa.vecmath.PolygonTools;
import ncsa.vecmath.Triangle;

public class IndexedPolygon {
    IndexedTriangleArray tri = null;
    Point3d[] points = null;
    int[][] pointIndices = null;
    Color3f[] colors = null;
    int[][] colorIndices = null;
    Vector3f[] normals = null;
    int[][] normalIndices = null;
    private Vector vec = new Vector();
    boolean smoothing = false;
    float creaseAngle = 0.0f;

    public IndexedPolygon(Point3d[] point3dArray, int[][] nArray) {
        this.points = point3dArray;
        this.pointIndices = nArray;
    }

    public IndexedPolygon(Point3f[] point3fArray, int[][] nArray) {
        Point3d[] point3dArray = new Point3d[point3fArray.length];
        int n = 0;
        while (n < point3fArray.length) {
            point3dArray[n] = new Point3d(point3fArray[n]);
            ++n;
        }
        this.points = point3dArray;
        this.pointIndices = nArray;
    }

    private void add(Triangle[] triangleArray) {
        int n = 0;
        while (n < triangleArray.length) {
            this.vec.addElement(triangleArray[n]);
            ++n;
        }
    }

    public void calculatePointNormals(boolean bl) {
        this.smoothing = bl;
    }

    public IndexedTriangleArray getIndexedTriangleArray() {
        Triangle triangle;
        int n;
        Vector3f[] vector3fArray;
        Object[] objectArray;
        int n2;
        int n3;
        boolean bl = false;
        int n4 = 0;
        while (n4 < this.pointIndices.length) {
            IndexedInfo[] indexedInfoArray = new IndexedInfo[this.pointIndices[n4].length];
            n3 = 0;
            n2 = 0;
            while (n2 < this.pointIndices[n4].length) {
                indexedInfoArray[n3] = new IndexedInfo(this.pointIndices[n4][n2]);
                if (this.colors != null) {
                    indexedInfoArray[n3].setColorIndex(this.colorIndices[n4][n2]);
                }
                if (this.normals != null) {
                    indexedInfoArray[n3].setNormalIndex(this.normalIndices[n4][n2]);
                }
                ++n3;
                ++n2;
            }
            objectArray = this.tesselate(indexedInfoArray);
            this.add((Triangle[])objectArray);
            ++n4;
        }
        int n5 = this.vec.size() * 3;
        n3 = 3;
        if (this.colors != null) {
            n3 |= 4;
        }
        this.tri = new IndexedTriangleArray(this.points.length, n3, n5);
        this.tri.setCapability(17);
        this.tri.setCapability(8);
        this.tri.setCapability(2);
        this.tri.setCapability(11);
        this.tri.setCapability(4);
        this.tri.setCapability(13);
        this.tri.setCapability(0);
        this.tri.setCapability(9);
        n2 = 0;
        objectArray = new int[n5];
        int n6 = 0;
        while (n6 < this.vec.size()) {
            vector3fArray = (Triangle)this.vec.elementAt(n6);
            objectArray[n2++] = (Triangle)vector3fArray.first.getPoint3dIndex();
            objectArray[n2++] = (Triangle)vector3fArray.second.getPoint3dIndex();
            objectArray[n2++] = (Triangle)vector3fArray.third.getPoint3dIndex();
            ++n6;
        }
        this.tri.setCoordinates(0, this.points);
        this.tri.setCoordinateIndices(0, (int[])objectArray);
        if (this.colors != null) {
            n2 = 0;
            vector3fArray = (Vector3f[])new int[n5];
            n = 0;
            while (n < this.vec.size()) {
                triangle = (Triangle)this.vec.elementAt(n);
                vector3fArray[n2++] = (Vector3f)triangle.first.getColorIndex();
                vector3fArray[n2++] = (Vector3f)triangle.second.getColorIndex();
                vector3fArray[n2++] = (Vector3f)triangle.third.getColorIndex();
                ++n;
            }
            this.tri.setColors(0, this.colors);
            this.tri.setColorIndices(0, (int[])vector3fArray);
        }
        if (this.normals != null) {
            n2 = 0;
            vector3fArray = (Vector3f[])new int[n5];
            n = 0;
            while (n < this.vec.size()) {
                triangle = (Triangle)this.vec.elementAt(n);
                vector3fArray[n2++] = (Vector3f)triangle.first.getNormalIndex();
                vector3fArray[n2++] = (Vector3f)triangle.second.getNormalIndex();
                vector3fArray[n2++] = (Vector3f)triangle.third.getNormalIndex();
                ++n;
            }
            this.tri.setNormals(0, this.normals);
            this.tri.setNormalIndices(0, (int[])vector3fArray);
        } else {
            vector3fArray = PolygonTools.calculateIndexedNormals(this.points, (int[])objectArray, this.creaseAngle, 3);
            n = 0;
            while (n < vector3fArray.length) {
                this.tri.setNormal(n, vector3fArray[n]);
                this.tri.setNormalIndices(0, (int[])objectArray);
                ++n;
            }
        }
        return this.tri;
    }

    public void setColors(Color3f[] color3fArray, int[][] nArray) {
        this.colors = color3fArray;
        this.colorIndices = nArray;
    }

    public void setCreaseAngle(float f) {
        this.creaseAngle = f;
    }

    public void setNormals(Vector3f[] vector3fArray, int[][] nArray) {
        this.normals = vector3fArray;
        this.normalIndices = nArray;
    }

    private Triangle[] tesselate(IndexedInfo[] indexedInfoArray) {
        int n = indexedInfoArray.length - 2;
        Triangle[] triangleArray = new Triangle[n];
        int n2 = 0;
        while (n2 < n) {
            triangleArray[n2] = new Triangle(indexedInfoArray[0], indexedInfoArray[n2 + 1], indexedInfoArray[n2 + 2]);
            ++n2;
        }
        return triangleArray;
    }
}

