/*
 * Decompiled with CFR 0.152.
 */
package ncsa.util;

import java.io.Reader;

public class ReaderTokenizer {
    public static final int TT_WORD = -101;
    public static final int TT_NUMBER = -102;
    public static final int TT_EOF = -103;
    public static final int WHITESPACE = 1;
    public static final int WORDCHAR = 2;
    public static final int NUMBER = 3;
    public static final int TOKEN = 4;
    public static final int QUOTE = 5;
    public static final int COMMENT = 6;
    public static final int NEWLINE = 7;
    public static final int ESCAPE = 8;
    public final int MAXSIZE = 8192;
    public int ttype;
    public String sval;
    public double nval;
    public boolean eol;
    protected Reader reader;
    public int lineno = 1;
    int[] chars = new int[65535];
    char putbackChar;
    int quote;
    boolean pushedBack = false;
    String pushed_sval;
    double pushed_nval;
    int pushed_ttype;
    boolean pushed_eol;
    int k;
    char[] buf = new char[8192];

    public ReaderTokenizer(Reader reader) {
        this.reader = reader;
        this.resetSyntax();
    }

    public int charType(int n) {
        return this.chars[n];
    }

    public void commentChar(int n) {
        this.chars[n] = 6;
    }

    public boolean eol() {
        return this.eol;
    }

    public void escapeChar(int n) {
        this.chars[n] = 8;
    }

    public int lineno() {
        return this.lineno;
    }

    public void newlineChar(int n) {
        this.chars[n] = 7;
    }

    public int nextToken() {
        char c;
        this.eol = false;
        if (this.pushedBack) {
            this.ttype = this.pushed_ttype;
            this.sval = this.pushed_sval;
            this.nval = this.pushed_nval;
            this.pushedBack = false;
            this.eol = this.pushed_eol;
            return this.ttype;
        }
        this.k = 0;
        block0: while ((c = this.read()) != '\uffff') {
            boolean bl;
            if (this.chars[c] == 1) continue;
            if (this.chars[c] == 4) {
                this.sval = new String(String.valueOf(c));
                this.ttype = c;
                return c;
            }
            if (this.chars[c] == 6) {
                while ((c = this.read()) != '\uffff') {
                    if (this.chars[c] == 7) continue block0;
                }
                continue;
            }
            if (this.chars[c] == 5) {
                bl = false;
                while ((c = this.read()) != '\uffff') {
                    if (this.chars[c] == 5 && !bl) {
                        this.sval = new String(this.buf, 0, this.k);
                        this.ttype = this.quote;
                        return this.ttype;
                    }
                    if (this.chars[c] == 8) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                    this.buf[this.k++] = c;
                }
                if (c == '\uffff') {
                    this.sval = new String(this.buf, 0, this.k);
                    this.ttype = this.quote;
                    return this.ttype;
                }
            }
            if (this.chars[c] == 3) {
                String string;
                bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = true;
                if (c == '.') {
                    bl4 = true;
                    this.buf[this.k++] = 48;
                }
                this.buf[this.k++] = c;
                bl5 = false;
                c = this.read();
                if (c == '\uffff' || this.chars[c] == 1) {
                    this.nval = this.k == 1 && this.buf[0] == '-' ? new Double(0.0).doubleValue() : new Double(this.buf[0] - 48).doubleValue();
                    this.ttype = -102;
                    return -102;
                }
                if (this.chars[c] == 3 && (c != '-' || bl5)) {
                    this.buf[this.k++] = c;
                    if (c == '.') {
                        bl4 = true;
                    }
                } else if (this.buf[0] == '0' && (c == 'x' || c == 'X')) {
                    this.buf[this.k++] = 120;
                    bl2 = true;
                } else if (c == 'e') {
                    this.buf[this.k++] = 101;
                    bl3 = true;
                    bl5 = true;
                } else {
                    bl = true;
                }
                if (!bl) {
                    while ((c = this.read()) != '\uffff') {
                        if (c == '.') {
                            if (bl2 || bl4 || bl3) continue;
                            this.buf[this.k++] = 46;
                            bl4 = true;
                            continue;
                        }
                        if (c == 'e' || c == 'E') {
                            bl5 = true;
                            boolean bl6 = bl2 || bl3;
                            this.buf[this.k++] = 101;
                            bl3 = true;
                            c = this.read();
                            if (c != '+' && c != '-') continue;
                            this.buf[this.k++] = c;
                            continue;
                        }
                        if (this.chars[c] != 3 || c == '-' && !bl5) break;
                        this.buf[this.k++] = c;
                    }
                }
                if (c != '\uffff') {
                    this.putback(c);
                }
                if ((string = new String(this.buf, 0, this.k)).equals("-")) {
                    string = new String("0");
                }
                if (bl4 || bl3) {
                    Double d = new Double(string);
                    this.nval = d;
                    this.ttype = -102;
                    return -102;
                }
                Integer n = Integer.decode(string);
                this.nval = n.doubleValue();
                this.ttype = -102;
                return -102;
            }
            if (this.chars[c] != 2) continue;
            this.buf[this.k++] = c;
            while ((c = this.read()) != '\uffff') {
                if (this.chars[c] != 2 && this.chars[c] != 3) break;
                this.buf[this.k++] = c;
            }
            if (c != '\uffff') {
                this.putback(c);
            }
            this.sval = new String(this.buf, 0, this.k);
            this.ttype = -101;
            return -101;
        }
        this.ttype = -103;
        return -103;
    }

    public void ordinaryChar(int n) {
        this.chars[n] = 4;
    }

    public void parseNumbers() {
        int n = 48;
        while (n <= 57) {
            this.chars[n] = 3;
            ++n;
        }
        this.chars[46] = 3;
        this.chars[45] = 3;
    }

    public void parseNumbersAsWords() {
        int n = 48;
        while (n <= 57) {
            this.chars[n] = 2;
            ++n;
        }
        this.chars[46] = 2;
        this.chars[45] = 2;
    }

    public void pushBack() {
        this.pushed_ttype = this.ttype;
        this.pushed_sval = this.sval;
        this.pushed_nval = this.nval;
        this.pushedBack = true;
        this.pushed_eol = this.eol;
        this.eol = false;
    }

    public void putback(char c) {
        this.putbackChar = c;
    }

    public void quoteChar(int n) {
        if (this.quote != 0) {
            this.chars[this.quote] = 0;
        }
        this.chars[n] = 5;
        this.quote = n;
    }

    public char read() {
        this.eol = false;
        if (this.k + 5 > this.buf.length) {
            char[] cArray = new char[this.buf.length + 1024];
            System.arraycopy(this.buf, 0, cArray, 0, this.buf.length);
            this.buf = cArray;
        }
        if (this.putbackChar != '\u0000') {
            char c = this.putbackChar;
            this.putbackChar = '\u0000';
            return c;
        }
        char c = '\u0000';
        try {
            c = (char)this.reader.read();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        if (c == '\uffff') {
            return c;
        }
        if (this.chars[c] == 7) {
            ++this.lineno;
            this.eol = true;
        }
        return c;
    }

    public void resetSyntax() {
        this.wordChars(0, 255);
        this.whitespaceChars(0, 32);
        this.whitespaceChar(44);
        this.quoteChar(34);
        this.ordinaryChar(123);
        this.ordinaryChar(125);
        this.ordinaryChar(91);
        this.ordinaryChar(93);
        this.ordinaryChar(47);
        this.escapeChar(92);
        this.newlineChar(10);
        this.commentChar(35);
        this.parseNumbers();
    }

    public void setType(int n, int n2) {
        this.chars[n] = n2;
    }

    public void whitespaceChar(int n) {
        this.chars[n] = 1;
    }

    public void whitespaceChars(int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            this.chars[n3] = 1;
            ++n3;
        }
    }

    public void wordChars(int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            this.chars[n3] = 2;
            ++n3;
        }
    }
}

