/*
 * Decompiled with CFR 0.152.
 */
package ncsa.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import ncsa.net.Customer;
import ncsa.net.Handler;

public class MulticastHandler
extends Handler
implements Runnable {
    MulticastSocket sock = null;
    InetAddress group = null;
    Customer customer;
    Thread thread = null;
    boolean stopped = false;
    boolean loopback = true;

    public MulticastHandler(String string, int n, Customer customer) {
        super(string, n);
        this.customer = customer;
    }

    public void begin() {
        try {
            this.group = InetAddress.getByName(this.address);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println(unknownHostException);
            return;
        }
        try {
            this.sock = new MulticastSocket(this.port);
            this.sock.joinGroup(this.group);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return;
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void end() {
        try {
            this.stopped = true;
            this.sock.leaveGroup(this.group);
            this.sock.close();
            this.thread.interrupt();
        }
        catch (IOException iOException) {}
    }

    public void run() {
        try {
            MulticastSocket multicastSocket = new MulticastSocket(this.port);
            multicastSocket.joinGroup(this.group);
            byte[] byArray = new byte[1024];
            while (true) {
                if (this.stopped) {
                    return;
                }
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                multicastSocket.receive(datagramPacket);
                if (!this.loopback && InetAddress.getLocalHost().equals(datagramPacket.getAddress())) continue;
                this.customer.consume(datagramPacket.getData(), datagramPacket.getLength());
            }
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (Exception exception) {
            System.out.println("We're done! " + exception);
        }
    }

    public void setLoopback(boolean bl) {
        this.loopback = bl;
    }

    public void transmit(byte[] byArray, int n) {
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n, this.group, this.port);
        try {
            this.sock.send(datagramPacket);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return;
        }
    }
}

