/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.ui.widgets.event;

import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnTransformChange;
import ncsa.j3d.ui.widgets.event.TransformChangedEvent;
import ncsa.j3d.ui.widgets.event.TransformChangedListener;

public class TransformWatcher
extends Behavior {
    TransformGroup transform;
    WakeupCriterion criterion;
    Vector transformWatchers = new Vector();
    int skip = 0;

    public TransformWatcher(TransformGroup transformGroup) {
        this.transform = transformGroup;
        BoundingSphere boundingSphere = new BoundingSphere();
        boundingSphere.setRadius(1000.0);
        this.setSchedulingBounds((Bounds)boundingSphere);
    }

    public void addTransformListener(TransformChangedListener transformChangedListener) {
        this.transformWatchers.addElement(transformChangedListener);
    }

    public void initialize() {
        this.criterion = new WakeupOnTransformChange(this.transform);
        this.wakeupOn((WakeupCondition)this.criterion);
    }

    public void notifyAllTransformWatchers() {
        TransformChangedEvent transformChangedEvent = new TransformChangedEvent((Object)this, this.transform);
        Enumeration enumeration = this.transformWatchers.elements();
        while (enumeration.hasMoreElements()) {
            ((TransformChangedListener)enumeration.nextElement()).transformChanged(transformChangedEvent);
        }
    }

    public void processStimulus(Enumeration enumeration) {
        this.wakeupOn((WakeupCondition)this.criterion);
        if (this.skip == 0) {
            this.notifyAllTransformWatchers();
        }
        this.skip = this.skip > 0 ? this.skip - 1 : 0;
    }

    public void removeTransformListener(TransformChangedListener transformChangedListener) {
        this.transformWatchers.removeElement(transformChangedListener);
    }

    public void skipOne() {
        ++this.skip;
    }
}

