/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.ui.widgets;

import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import ncsa.j3d.ui.events.EventManager;
import ncsa.j3d.ui.events.PortfolioEventReceiver;
import ncsa.j3d.ui.widgets.HasNode;
import ncsa.j3d.ui.widgets.HasStates;
import ncsa.j3d.ui.widgets.event.SFocusEvent;

public class WidgetManager
implements PortfolioEventReceiver {
    protected Vector windows = new Vector();
    protected BranchGroup fixed;
    protected BranchGroup group;
    protected Canvas3D canvas;
    protected HasStates object = null;
    protected boolean connected = false;
    protected WidgetManager instance = null;

    public WidgetManager(Canvas3D canvas3D) {
        this.canvas = canvas3D;
        this.group = new BranchGroup();
        this.group.setCapability(17);
        this.group.setCapability(14);
        this.group.setCapability(12);
        this.group.setCapability(13);
        EventManager.instance().addEventReceiver(this);
    }

    public void add(HasNode hasNode) {
        this.windows.addElement(hasNode);
        this.disconnect();
        this.group.addChild(hasNode.getNode());
        this.connect();
    }

    protected void connect() {
        if (this.fixed != null && !this.connected) {
            this.fixed.addChild((Node)this.group);
            this.connected = true;
        }
    }

    protected void disconnect() {
        if (this.connected) {
            this.group.detach();
        }
        this.connected = false;
    }

    protected boolean mouse(MouseEvent mouseEvent) {
        HasStates hasStates = this.selectNode(this.canvas, this.fixed, mouseEvent.getX(), mouseEvent.getY());
        switch (mouseEvent.getID()) {
            case 501: {
                if (this.object != null) {
                    this.object.focusLost(new SFocusEvent(this, 1));
                }
                this.object = hasStates;
                if (this.object != null) {
                    this.object.focusGained(new SFocusEvent(this, 0));
                    return true;
                }
                return false;
            }
            case 506: {
                if (this.object == null) break;
                return true;
            }
            case 502: {
                if (hasStates == null || hasStates != this.object) break;
                this.object.selected();
                return true;
            }
        }
        return false;
    }

    public boolean notify(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return this.mouse((MouseEvent)eventObject);
        }
        return false;
    }

    public HasStates selectNode(Canvas3D canvas3D, BranchGroup branchGroup, int n, int n2) {
        Transform3D transform3D = new Transform3D();
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = new Vector3d();
        HasStates hasStates = null;
        PickRay pickRay = new PickRay();
        System.out.println("canvas = " + canvas3D);
        canvas3D.getCenterEyeInImagePlate(point3d);
        canvas3D.getPixelLocationInImagePlate(n, n2, point3d2);
        canvas3D.getImagePlateToVworld(transform3D);
        transform3D.transform(point3d);
        transform3D.transform(point3d2);
        vector3d.sub((Tuple3d)point3d2, (Tuple3d)point3d);
        vector3d.normalize();
        pickRay.set(point3d2, vector3d);
        SceneGraphPath[] sceneGraphPathArray = branchGroup.pickAllSorted((PickShape)pickRay);
        if (sceneGraphPathArray != null) {
            int n3 = 0;
            while (n3 < sceneGraphPathArray.length) {
                if (sceneGraphPathArray[n3] != null) {
                    int n4 = 0;
                    while (n4 < sceneGraphPathArray[n3].nodeCount()) {
                        Node node = sceneGraphPathArray[n3].getNode(n4);
                        if (node instanceof HasStates) {
                            hasStates = (HasStates)node;
                            break;
                        }
                        ++n4;
                    }
                    if (hasStates != null) break;
                }
                ++n3;
            }
        }
        return hasStates;
    }

    public void setBranchGroup(BranchGroup branchGroup) {
        this.fixed = branchGroup;
        this.connect();
    }

    public void setCanvas(Canvas3D canvas3D) {
        this.canvas = canvas3D;
    }
}

