/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.ui.widgets;

import com.sun.j3d.utils.geometry.Sphere;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import ncsa.j3d.ui.widgets.HasNode;
import ncsa.j3d.ui.widgets.HasValue;
import ncsa.j3d.ui.widgets.RestrictivePickableTransformGroup;
import ncsa.j3d.ui.widgets.SJButton;
import ncsa.j3d.ui.widgets.SJComponent;
import ncsa.j3d.ui.widgets.event.TransformChangedEvent;
import ncsa.j3d.ui.widgets.event.TransformChangedListener;
import ncsa.j3d.ui.widgets.event.TransformWatcher;

public class SJSlider
extends SJComponent
implements HasNode,
TransformChangedListener,
ActionListener,
HasValue {
    static final int magnitude = 5;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int DEPTH = 2;
    protected int orientation = 1;
    protected Vector changeListeners = new Vector();
    protected int max = 0;
    protected int min = 0;
    protected int value = 0;
    protected Group group;
    protected TransformWatcher transformWatcher = null;
    protected RestrictivePickableTransformGroup slider = null;
    protected Node minimum = null;
    protected Node maximum = null;
    protected Node center = null;
    protected SJButton minButton = null;
    protected SJButton maxButton = null;

    public SJSlider() {
        this(0, 100, 50);
    }

    public SJSlider(int n, int n2) {
        this(n, n2, (n2 - n) / 2);
    }

    public SJSlider(int n, int n2, int n3) {
        this.setMinimum(n);
        this.setMaximum(n2);
        this.value = n3;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.maxButton) {
            this.setValue((int)Math.ceil(this.getValueD()) + 1);
        }
        if (object == this.minButton) {
            this.setValue((int)Math.floor(this.getValueD()) - 1);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.addElement(changeListener);
    }

    protected Node defaultNode() {
        Sphere sphere = new Sphere(0.5f, new Appearance());
        sphere.setCapability(1);
        return sphere;
    }

    protected void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Enumeration enumeration = this.changeListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ChangeListener)enumeration.nextElement()).stateChanged(changeEvent);
        }
    }

    public int getMaximum() {
        return this.max;
    }

    public int getMinimum() {
        return this.min;
    }

    public Node getNode() {
        if (this.group == null) {
            this.setup();
            this.fireStateChanged();
        }
        return this.group;
    }

    protected double getPercentage() {
        return (this.getSliderLocation() + 5.0) / 10.0;
    }

    protected double getSliderLocation() {
        Vector3d vector3d = this.slider.get();
        switch (this.orientation) {
            case 1: {
                return vector3d.x;
            }
            case 0: {
                return vector3d.y;
            }
            case 2: {
                return vector3d.z;
            }
        }
        System.out.println("invalid orientation for " + this);
        return 0.0;
    }

    public int getValue() {
        return (int)(this.getPercentage() * (double)(this.max - this.min)) + this.min;
    }

    protected double getValueD() {
        return this.getPercentage() * (double)(this.max - this.min) + (double)this.min;
    }

    protected Vector3d maximumOffset() {
        switch (this.orientation) {
            case 1: {
                return new Vector3d(5.0, 0.0, 0.0);
            }
            case 0: {
                return new Vector3d(0.0, 5.0, 0.0);
            }
            case 2: {
                return new Vector3d(0.0, 0.0, 5.0);
            }
        }
        System.out.println("Invalid orientation for " + this);
        return null;
    }

    protected Vector3d minimumOffset() {
        switch (this.orientation) {
            case 1: {
                return new Vector3d(-5.0, 0.0, 0.0);
            }
            case 0: {
                return new Vector3d(0.0, -5.0, 0.0);
            }
            case 2: {
                return new Vector3d(0.0, 0.0, -5.0);
            }
        }
        System.out.println("Invalid orientation for " + this);
        return null;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.removeElement(changeListener);
    }

    protected void restrict(RestrictivePickableTransformGroup restrictivePickableTransformGroup) {
        switch (this.orientation) {
            case 1: {
                this.slider.setXMax(5.0);
                this.slider.setXMin(-5.0);
                break;
            }
            case 0: {
                this.slider.setYMax(5.0);
                this.slider.setYMin(-5.0);
                break;
            }
            case 2: {
                this.slider.setZMax(5.0);
                this.slider.setZMin(-5.0);
                break;
            }
            default: {
                System.out.println("Invalid orientation for :" + this);
            }
        }
    }

    public void setMaximum(int n) {
        this.max = n;
    }

    public void setMaximumNode(Node node) {
        this.maximum = node;
    }

    public void setMinimum(int n) {
        this.min = n;
    }

    public void setMinimumNode(Node node) {
        this.minimum = node;
    }

    public void setOrientation(int n) {
        n = n < 0 ? 0 : n;
        this.orientation = n = n > 2 ? 2 : n;
    }

    public void setSlide(Node node) {
        this.center = node;
    }

    protected void setSliderLocation(double d) {
        Vector3d vector3d = this.slider.get();
        switch (this.orientation) {
            case 1: {
                vector3d.x = d;
                break;
            }
            case 0: {
                vector3d.y = d;
                break;
            }
            case 2: {
                vector3d.z = d;
                break;
            }
            default: {
                System.out.println("invalid orientation for " + this);
            }
        }
        this.slider.set(vector3d);
    }

    public void setValue(int n) {
        n = Math.min(this.max, n);
        n = Math.max(this.min, n);
        double d = ((double)n - (double)this.min) / (double)(this.max - this.min);
        double d2 = 10.0 * d - 5.0;
        this.setSliderLocation(d2);
    }

    protected void setup() {
        this.group = new Group();
        this.group.addChild(this.setupMinimumBlock());
        this.group.addChild(this.setupMaximumBlock());
        this.group.addChild(this.setupSlider());
    }

    protected Node setupMaximumBlock() {
        TransformGroup transformGroup = new TransformGroup();
        Transform3D transform3D = new Transform3D();
        transform3D.set(this.maximumOffset());
        transformGroup.setTransform(transform3D);
        this.maxButton = new SJButton(this.maximum != null ? this.maximum : this.defaultNode());
        this.maxButton.addActionListener(this);
        this.add(this.maxButton);
        transformGroup.addChild(this.maxButton.getNode());
        return transformGroup;
    }

    protected Node setupMinimumBlock() {
        TransformGroup transformGroup = new TransformGroup();
        Transform3D transform3D = new Transform3D();
        transform3D.set(this.minimumOffset());
        transformGroup.setTransform(transform3D);
        this.minButton = new SJButton(this.minimum != null ? this.minimum : this.defaultNode());
        this.minButton.addActionListener(this);
        this.add(this.minButton);
        transformGroup.addChild(this.minButton.getNode());
        return transformGroup;
    }

    protected Node setupSlider() {
        this.slider = new RestrictivePickableTransformGroup(new Vector3f(0.0f, 0.0f, 0.0f));
        this.restrict(this.slider);
        this.slider.addChild(this.center != null ? this.center : this.defaultNode());
        this.transformWatcher = new TransformWatcher(this.slider);
        this.transformWatcher.addTransformListener(this);
        this.slider.addChild((Node)this.transformWatcher);
        return this.slider;
    }

    public void transformChanged(TransformChangedEvent transformChangedEvent) {
        this.fireStateChanged();
    }
}

