/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.ui.widgets;

import java.util.BitSet;
import javax.media.j3d.Node;
import javax.media.j3d.Switch;
import ncsa.j3d.ui.widgets.GroupWithStates;
import ncsa.j3d.ui.widgets.HasNode;
import ncsa.j3d.ui.widgets.HasStates;
import ncsa.j3d.ui.widgets.SAbstractButton;
import ncsa.j3d.ui.widgets.SComponent;
import ncsa.j3d.ui.widgets.SJMenu;
import ncsa.j3d.ui.widgets.event.SFocusEvent;

public class SJMenuItem
extends SAbstractButton
implements HasNode,
HasStates {
    Switch node;
    int focus = 0;
    BitSet bits = new BitSet(3);
    boolean absolute = false;

    public SJMenuItem(Node node) {
        this.bits.set(0);
        this.node = new Switch();
        this.node.setCapability(17);
        this.node.setCapability(18);
        this.node.setWhichChild(-3);
        this.node.setChildMask(this.bits);
        GroupWithStates groupWithStates = new GroupWithStates(this);
        groupWithStates.addChild(node);
        this.node.addChild((Node)groupWithStates);
    }

    public void addFocus(Node node) {
        this.node.addChild(node);
        this.focus = 1;
    }

    protected void clear(int n) {
        if (this.absolute) {
            this.bits = new BitSet(3);
            this.bits.set(0);
        } else {
            this.bits.clear(n);
        }
        if (!this.absolute) {
            this.bits.set(0);
        }
        this.node.setChildMask(this.bits);
    }

    protected void closeParent() {
        SComponent sComponent = this.getParent();
        if (sComponent != null && sComponent instanceof SJMenu) {
            ((SJMenu)sComponent).close();
        }
    }

    public void focusGained(SFocusEvent sFocusEvent) {
        this.set(this.focus);
        SJMenu sJMenu = this.getParentMenu();
        if (sJMenu != null) {
            sJMenu.focusGained(sFocusEvent);
        }
    }

    public void focusLost(SFocusEvent sFocusEvent) {
        this.clear(this.focus);
        SJMenu sJMenu = this.getParentMenu();
        if (sJMenu != null) {
            sJMenu.focusLost(sFocusEvent);
        }
    }

    public Node getNode() {
        return this.node;
    }

    public SJMenu getParentMenu() {
        SComponent sComponent = this.getParent();
        if (sComponent instanceof SJMenu) {
            return (SJMenu)sComponent;
        }
        return null;
    }

    public void selected() {
        this.closeParent();
        this.doClick();
    }

    protected void set(int n) {
        if (this.absolute) {
            this.bits = new BitSet(3);
        }
        this.bits.set(n);
        this.node.setChildMask(this.bits);
    }

    public void setAbsolute(boolean bl) {
        this.absolute = bl;
    }
}

