/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.ui.tools;

import java.util.Enumeration;
import java.util.EventObject;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Point3d;
import ncsa.j3d.ui.PortfolioProperties;
import ncsa.j3d.ui.tools.ToolInterface;
import ncsa.j3d.ui.tools.ToolManagerInterface;

public class ViewTool
extends Behavior
implements ToolInterface {
    protected TransformGroup transGroup;
    protected ToolManagerInterface tmi;
    protected Sensor sensor;
    protected WakeupOnElapsedFrames conditions = new WakeupOnElapsedFrames(0);
    protected Transform3D transform = new Transform3D();

    public ViewTool() {
        this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 3.4028234663852886E38));
    }

    public String describe() {
        return "View Tool";
    }

    public String describeFunctionality() {
        return "No Functionality";
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.conditions);
    }

    public boolean notify(EventObject eventObject) {
        return false;
    }

    public void processStimulus(Enumeration enumeration) {
        this.sensor.getRead(this.transform);
        this.transGroup.setTransform(this.transform);
        this.wakeupOn((WakeupCondition)this.conditions);
    }

    public void setToolManager(ToolManagerInterface toolManagerInterface) {
        this.tmi = toolManagerInterface;
        this.setup();
    }

    protected void setup() {
        this.transGroup = this.tmi.getViewTransform();
        Canvas3D canvas3D = this.tmi.getCanvas();
        BranchGroup branchGroup = this.tmi.getBranchGroup();
        String string = PortfolioProperties.instance().getProperty("ViewTool.Channel");
        if (string != null) {
            this.sensor = canvas3D.getView().getPhysicalEnvironment().getSensor(Integer.parseInt(string));
            branchGroup.addChild((Node)this);
        } else {
            System.out.println("Please specify ViewToolChannel in portfolio.properties");
        }
    }
}

