/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.ui.tools;

import java.util.EventObject;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import ncsa.j3d.loaders.play.PlayWriter;
import ncsa.j3d.ui.PortfolioProperties;
import ncsa.j3d.ui.events.EventManager;
import ncsa.j3d.ui.events.PortfolioEvent;
import ncsa.j3d.ui.events.PortfolioEventReceiver;
import ncsa.j3d.ui.tools.ReceiverList;
import ncsa.j3d.ui.tools.ToolInterface;
import ncsa.j3d.ui.tools.ToolManagerInterface;

public class ToolManager
implements ToolManagerInterface {
    ReceiverList inactive = new ReceiverList();
    ReceiverList receivers = new ReceiverList();
    ReceiverList tools = new ReceiverList();
    ToolInterface activeTool;
    BranchGroup branchGroup;
    BranchGroup toolGroup = this.makeBranchGroup();
    TransformGroup viewTransform;
    Canvas3D canvas;
    boolean setup = false;
    protected static ToolManager instance = null;

    protected ToolManager() {
        this.setupRecord();
    }

    public void addActive(PortfolioEventReceiver portfolioEventReceiver) {
        if (portfolioEventReceiver instanceof ToolInterface) {
            this.setActiveTool((ToolInterface)portfolioEventReceiver);
        } else {
            this.receivers.add(portfolioEventReceiver);
        }
    }

    public void addEventSource(Object object) {
        EventManager.instance().addEventSource(object);
    }

    public void addInactive(PortfolioEventReceiver portfolioEventReceiver) {
        if (portfolioEventReceiver instanceof ToolInterface) {
            this.tools.add(portfolioEventReceiver);
        } else {
            this.inactive.add(portfolioEventReceiver);
        }
    }

    public void addPortfolioEvent(PortfolioEvent portfolioEvent) {
        EventManager.instance().addEvent(portfolioEvent);
    }

    protected void clearToolGroup() {
        this.toolGroup.detach();
        int n = this.toolGroup.numChildren() - 1;
        while (n >= 0) {
            this.toolGroup.removeChild(n);
            --n;
        }
        this.branchGroup.addChild((Node)this.toolGroup);
    }

    protected ToolInterface configureTool(ToolInterface toolInterface) {
        toolInterface.setToolManager(this);
        return toolInterface;
    }

    ToolInterface getActiveTool() {
        return this.activeTool;
    }

    public BranchGroup getBranchGroup() {
        return this.branchGroup;
    }

    public Canvas3D getCanvas() {
        return this.canvas;
    }

    ReceiverList getInactiveReceiverList() {
        return this.inactive;
    }

    public String[] getToolNames() {
        String[] stringArray = new String[this.tools.getSize()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = new String(((ToolInterface)this.tools.get(n)).describe());
            ++n;
        }
        return stringArray;
    }

    public TransformGroup getViewTransform() {
        return this.viewTransform;
    }

    public static ToolManager instance() {
        if (instance == null) {
            instance = new ToolManager();
        }
        return instance;
    }

    public void loadTools() {
        this.loadTools(PortfolioProperties.instance());
    }

    protected void loadTools(PortfolioProperties portfolioProperties) {
        Object[] objectArray = portfolioProperties.getObjects("Tool");
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof ToolInterface) {
                this.addInactive(this.configureTool((ToolInterface)objectArray[n]));
            } else {
                System.out.println("ToolManager could not loadTools because " + objectArray[n] + " does not implement ncsa.j3d.ui.tools.ToolInterface.");
            }
            ++n;
        }
    }

    public void makeActive(PortfolioEventReceiver portfolioEventReceiver) {
        if (portfolioEventReceiver instanceof ToolInterface) {
            this.setActiveTool((ToolInterface)portfolioEventReceiver);
        } else {
            boolean bl = this.inactive.remove(portfolioEventReceiver);
            this.receivers.add(portfolioEventReceiver);
        }
    }

    protected BranchGroup makeBranchGroup() {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(1);
        branchGroup.setCapability(14);
        branchGroup.setCapability(12);
        branchGroup.setCapability(13);
        branchGroup.setCapability(17);
        branchGroup.setCapability(5);
        return branchGroup;
    }

    public void makeInactive(PortfolioEventReceiver portfolioEventReceiver) {
        boolean bl = this.receivers.remove(portfolioEventReceiver);
        if (!(portfolioEventReceiver instanceof ToolInterface)) {
            this.inactive.add(portfolioEventReceiver);
        }
    }

    public boolean notify(EventObject eventObject) {
        if (this.activeTool != null && this.activeTool.notify(eventObject)) {
            return true;
        }
        return this.receivers.notify(eventObject);
    }

    public void remove(PortfolioEventReceiver portfolioEventReceiver) {
    }

    public void setActiveTool(int n) {
        ToolInterface toolInterface = (ToolInterface)this.tools.get(n);
        if (toolInterface != null) {
            this.setActiveTool(toolInterface);
        }
    }

    public void setActiveTool(ToolInterface toolInterface) {
        if (this.activeTool instanceof Node) {
            this.clearToolGroup();
        }
        this.tools.add(toolInterface);
        this.activeTool = toolInterface;
    }

    public void setBranchGroup(BranchGroup branchGroup) {
        if (this.branchGroup == null) {
            this.branchGroup = branchGroup;
            this.branchGroup.addChild((Node)this.toolGroup);
        }
    }

    public void setCanvas(Canvas3D canvas3D) {
        if (this.canvas == null) {
            this.canvas = canvas3D;
        }
    }

    public void setViewTransform(TransformGroup transformGroup) {
        if (this.viewTransform == null) {
            this.viewTransform = transformGroup;
        }
    }

    protected void setupRecord() {
        PortfolioProperties portfolioProperties = PortfolioProperties.instance();
        String string = portfolioProperties.getProperty("Record");
        if (string == null || string.equalsIgnoreCase("false")) {
            return;
        }
        string = portfolioProperties.getProperty("RecordFile");
        if (string != null) {
            PlayWriter.open(string);
            System.out.println("PlayWriter writing to " + string + ".");
        } else {
            System.out.println("ERROR: Record is turned on and RecordFile is not properly defined in portfolio.properties file.");
        }
    }
}

