/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.ui.tools;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import ncsa.j3d.ui.tools.ToolInterface;
import ncsa.j3d.ui.tools.ToolManagerInterface;

public abstract class Tool
implements ToolInterface {
    protected BranchGroup bg;
    protected Canvas3D canvas;
    protected ToolManagerInterface manager;

    public Tool() {
    }

    public Tool(Canvas3D canvas3D, BranchGroup branchGroup) {
        this.canvas = canvas3D;
        this.bg = branchGroup;
    }

    protected boolean LeftMouseDragged(MouseEvent mouseEvent) {
        return this.def();
    }

    protected boolean LeftMousePressed(MouseEvent mouseEvent) {
        return this.def();
    }

    protected boolean LeftMouseReleased(MouseEvent mouseEvent) {
        return this.def();
    }

    protected boolean MiddleMouseDragged(MouseEvent mouseEvent) {
        return this.def();
    }

    protected boolean MiddleMousePressed(MouseEvent mouseEvent) {
        return this.def();
    }

    protected boolean MiddleMouseReleased(MouseEvent mouseEvent) {
        return this.def();
    }

    protected boolean MouseDragged(MouseEvent mouseEvent) {
        if (Tool.left(mouseEvent)) {
            return this.LeftMouseDragged(mouseEvent);
        }
        if (Tool.middle(mouseEvent)) {
            return this.MiddleMouseDragged(mouseEvent);
        }
        if (Tool.right(mouseEvent)) {
            return this.RightMouseDragged(mouseEvent);
        }
        return false;
    }

    protected boolean MousePressed(MouseEvent mouseEvent) {
        if (Tool.left(mouseEvent)) {
            return this.LeftMousePressed(mouseEvent);
        }
        if (Tool.middle(mouseEvent)) {
            return this.MiddleMousePressed(mouseEvent);
        }
        if (Tool.right(mouseEvent)) {
            return this.RightMousePressed(mouseEvent);
        }
        return false;
    }

    protected boolean MouseReleased(MouseEvent mouseEvent) {
        if (Tool.left(mouseEvent)) {
            return this.LeftMouseReleased(mouseEvent);
        }
        if (Tool.middle(mouseEvent)) {
            return this.MiddleMouseReleased(mouseEvent);
        }
        if (Tool.right(mouseEvent)) {
            return this.RightMouseReleased(mouseEvent);
        }
        return false;
    }

    protected boolean RightMouseDragged(MouseEvent mouseEvent) {
        return this.def();
    }

    protected boolean RightMousePressed(MouseEvent mouseEvent) {
        return this.def();
    }

    protected boolean RightMouseReleased(MouseEvent mouseEvent) {
        return this.def();
    }

    protected boolean def() {
        return false;
    }

    public String describe() {
        return "Tool";
    }

    public String describeFunctionality() {
        return "No description availiable";
    }

    protected abstract void initialize();

    protected boolean keyboard(KeyEvent keyEvent) {
        return false;
    }

    public static boolean left(MouseEvent mouseEvent) {
        return !Tool.middle(mouseEvent) && !Tool.right(mouseEvent);
    }

    public static boolean middle(MouseEvent mouseEvent) {
        return (8 & mouseEvent.getModifiers()) > 0;
    }

    protected boolean mouse(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                return this.MousePressed(mouseEvent);
            }
            case 506: {
                return this.MouseDragged(mouseEvent);
            }
            case 502: {
                return this.MouseReleased(mouseEvent);
            }
        }
        return false;
    }

    public boolean notify(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return this.mouse((MouseEvent)eventObject);
        }
        if (eventObject instanceof KeyEvent) {
            return this.keyboard((KeyEvent)eventObject);
        }
        return false;
    }

    public static boolean right(MouseEvent mouseEvent) {
        return (4 & mouseEvent.getModifiers()) > 0;
    }

    public void setBranchGroup(BranchGroup branchGroup) {
        this.bg = branchGroup;
    }

    public void setCanvas(Canvas3D canvas3D) {
        this.canvas = canvas3D;
    }

    public void setToolManager(ToolManagerInterface toolManagerInterface) {
        this.manager = toolManagerInterface;
        this.initialize();
    }
}

