/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.ui.tools;

import java.util.Enumeration;
import java.util.EventObject;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Sensor;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Point3d;
import ncsa.devices.ValuesWithRotation;
import ncsa.j3d.ui.PortfolioProperties;
import ncsa.j3d.ui.tools.SensorViewDialog;
import ncsa.j3d.ui.tools.ToolInterface;
import ncsa.j3d.ui.tools.ToolManagerInterface;

public class SensorViewTool
extends Behavior
implements ToolInterface {
    protected WakeupOnElapsedFrames conditions = new WakeupOnElapsedFrames(0);
    SensorViewDialog dialog;
    ValuesWithRotation vwr;
    int sensor = 0;

    public SensorViewTool() {
        this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 3.4028234663852886E38));
    }

    public String describe() {
        return "SensorViewTool";
    }

    public String describeFunctionality() {
        return "Views the Sensor";
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.conditions);
    }

    public boolean notify(EventObject eventObject) {
        return false;
    }

    public void processStimulus(Enumeration enumeration) {
        if (this.dialog != null) {
            this.dialog.update();
        }
        this.wakeupOn((WakeupCondition)this.conditions);
    }

    public void setToolManager(ToolManagerInterface toolManagerInterface) {
        Canvas3D canvas3D = toolManagerInterface.getCanvas();
        String string = PortfolioProperties.instance().getProperty("SensorViewTool.Channel");
        if (string != null) {
            Sensor sensor = canvas3D.getView().getPhysicalEnvironment().getSensor(Integer.parseInt(string));
            this.dialog = new SensorViewDialog(sensor);
        }
        toolManagerInterface.getBranchGroup().addChild((Node)this);
    }
}

