/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.ui.tools;

import java.util.Enumeration;
import java.util.EventObject;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Sensor;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Point3d;
import ncsa.j3d.loaders.play.PlayWriter;
import ncsa.j3d.loaders.play.directives.SensorDirective;
import ncsa.j3d.ui.PortfolioProperties;
import ncsa.j3d.ui.tools.ToolInterface;
import ncsa.j3d.ui.tools.ToolManagerInterface;

public class SensorRecordTool
extends Behavior
implements ToolInterface {
    protected WakeupOnElapsedFrames conditions = new WakeupOnElapsedFrames(0);
    Sensor sensor;
    static int instances = 0;
    SensorDirective olddir = null;

    public SensorRecordTool() {
        this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 3.4028234663852886E38));
    }

    public String describe() {
        return "SensorRecordTool";
    }

    public String describeFunctionality() {
        return "Records the Sensor";
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.conditions);
    }

    public boolean notify(EventObject eventObject) {
        return false;
    }

    public void processStimulus(Enumeration enumeration) {
        SensorDirective sensorDirective = new SensorDirective(this.sensor);
        if (!sensorDirective.equals(this.olddir)) {
            PlayWriter.write(sensorDirective);
            this.olddir = sensorDirective;
        }
        this.wakeupOn((WakeupCondition)this.conditions);
    }

    public void setToolManager(ToolManagerInterface toolManagerInterface) {
        Canvas3D canvas3D = toolManagerInterface.getCanvas();
        String string = PortfolioProperties.instance().getProperty("SensorRecordTool" + instances++ + "Channel");
        if (string != null) {
            this.sensor = canvas3D.getView().getPhysicalEnvironment().getSensor(Integer.parseInt(string));
            toolManagerInterface.getBranchGroup().addChild((Node)this);
        } else {
            System.out.println("SensorRecordTool" + (instances - 1) + "Channel is not defined in portfolio.properties file. What do you expect me to record?");
        }
    }
}

