/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.ui.tools;

import com.sun.j3d.loaders.Scene;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventObject;
import javax.media.j3d.Appearance;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Sensor;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import ncsa.j3d.PickableTransformGroup;
import ncsa.j3d.loaders.ModelLoader;
import ncsa.j3d.ui.PortfolioProperties;
import ncsa.j3d.ui.tools.ToolInterface;
import ncsa.j3d.ui.tools.ToolManagerInterface;

public class PickTool
extends Behavior
implements ToolInterface {
    protected BranchGroup bg;
    protected TransformGroup tg;
    protected ToolManagerInterface tmi;
    protected Canvas3D canvas;
    protected Sensor sensor;
    protected Sensor buttonsensor;
    protected int[] buttons;
    protected PickableTransformGroup group = null;
    protected Transform3D original = null;
    protected Transform3D undo = null;
    boolean sticky = true;
    protected int SELECT = 0;
    protected int DROP = 1;
    protected int RESET = 2;
    WakeupOnElapsedFrames conditions = new WakeupOnElapsedFrames(0);
    Transform3D transform = new Transform3D();

    public PickTool() {
        this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 3.4028234663852886E38));
        this.tg = new TransformGroup();
        this.tg.setCapability(18);
        this.tg.setCapability(17);
    }

    protected void addCursor(BranchGroup branchGroup) {
        TransformGroup transformGroup = new TransformGroup();
        Transform3D transform3D = new Transform3D();
        Transform3D transform3D2 = new Transform3D();
        transform3D2.mul(transform3D);
        transformGroup.setTransform(transform3D2);
        if (branchGroup == null) {
            LineArray lineArray = null;
            lineArray = new LineArray(2, 3);
            lineArray.setCoordinate(0, new Point3d());
            lineArray.setCoordinate(1, new Point3d(0.0, 0.0, -300.0));
            lineArray.setNormal(0, new Vector3f(1.0f, 0.0f, 0.0f));
            lineArray.setNormal(1, new Vector3f(1.0f, 0.0f, 0.0f));
            Appearance appearance = new Appearance();
            LineAttributes lineAttributes = new LineAttributes();
            lineAttributes.setLineWidth(3.0f);
            appearance.setLineAttributes(lineAttributes);
            Material material = new Material();
            material.setDiffuseColor(new Color3f(1.0f, 0.0f, 0.0f));
            appearance.setMaterial(material);
            transformGroup.addChild((Node)new Shape3D((Geometry)lineArray, appearance));
        } else {
            transformGroup.addChild((Node)branchGroup);
        }
        this.tg.addChild((Node)transformGroup);
        this.tmi.getBranchGroup().addChild((Node)this.tg);
    }

    protected Transform3D buildTransformToOrigin(Transform3D transform3D) {
        Vector3d vector3d = new Vector3d(1.0, 0.0, 0.0);
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d(0.0, 0.0, 1.0);
        Vector3d vector3d4 = new Vector3d();
        transform3D.get(vector3d4);
        transform3D.transform(vector3d);
        transform3D.transform(vector3d3);
        vector3d.normalize();
        vector3d3.normalize();
        vector3d2.cross(vector3d3, vector3d);
        vector3d2.normalize();
        vector3d.cross(vector3d2, vector3d3);
        double[] dArray = new double[]{vector3d.x, vector3d.y, vector3d.z, -vector3d4.x, vector3d2.x, vector3d2.y, vector3d2.z, -vector3d4.y, vector3d3.x, vector3d3.y, vector3d3.z, -vector3d4.z, 0.0, 0.0, 0.0, 1.0};
        return new Transform3D(dArray);
    }

    protected PickRay construct_pickray() {
        Transform3D transform3D = new Transform3D();
        this.tg.getTransform(transform3D);
        Vector3d vector3d = new Vector3d(0.0, 0.0, -1.0);
        transform3D.transform(vector3d);
        vector3d.normalize();
        Vector3d vector3d2 = new Vector3d();
        transform3D.get(vector3d2);
        Point3d point3d = new Point3d((Tuple3d)vector3d2);
        return new PickRay(point3d, vector3d);
    }

    public String describe() {
        return "Pick Tool";
    }

    public String describeFunctionality() {
        return "Two Modes: Rotate and Translate\ninitial mode is translate\nspacebar toggles between modes\n\nTranslate mode:\nLeft mouse translates in x and y\nMiddle mouse translates in z\n\nRotate mode:\nLeft mouse rotates around x and y\nMiddles mouse rotates around z";
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.conditions);
    }

    public boolean notify(EventObject eventObject) {
        return false;
    }

    protected PickableTransformGroup pick(PickRay pickRay) {
        SceneGraphPath[] sceneGraphPathArray = this.bg.pickAll((PickShape)pickRay);
        if (sceneGraphPathArray == null) {
            return null;
        }
        int n = 0;
        while (n < sceneGraphPathArray.length) {
            int n2 = 0;
            while (n2 < sceneGraphPathArray[n].nodeCount()) {
                Node node = sceneGraphPathArray[n].getNode(n2);
                if (node instanceof PickableTransformGroup) {
                    return (PickableTransformGroup)node;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    protected void processButtonSensor() {
        Transform3D transform3D = new Transform3D();
        this.buttonsensor.getRead(transform3D);
        this.buttonsensor.lastButtons(this.buttons);
        if (this.SELECT < this.buttons.length && this.buttons[this.SELECT] != 0 && this.group == null) {
            PickRay pickRay = this.construct_pickray();
            this.group = this.pick(pickRay);
            if (this.group != null) {
                this.original = new Transform3D();
                this.group.get(this.original);
                this.undo = this.buildTransformToOrigin(this.transform);
            }
        }
        if (this.SELECT < this.buttons.length && !this.sticky && this.buttons[this.SELECT] == 0) {
            this.group = null;
        }
        if (this.DROP < this.buttons.length && this.buttons[this.DROP] != 0 && this.sticky) {
            this.group = null;
        }
        if (this.RESET < this.buttons.length && this.buttons[this.RESET] != 0 && this.group != null) {
            this.group.set(this.original);
            this.original = new Transform3D();
            this.group.get(this.original);
            this.undo = this.buildTransformToOrigin(this.transform);
        }
    }

    protected void processGroup() {
        if (this.group == null) {
            return;
        }
        Transform3D transform3D = new Transform3D(this.transform);
        Vector3d vector3d = new Vector3d();
        transform3D.get(vector3d);
        transform3D.setTranslation(new Vector3d());
        Transform3D transform3D2 = new Transform3D(this.undo);
        Vector3d vector3d2 = new Vector3d();
        transform3D2.get(vector3d2);
        transform3D2.setTranslation(new Vector3d());
        Transform3D transform3D3 = new Transform3D();
        transform3D3.mul(transform3D, transform3D2);
        Transform3D transform3D4 = new Transform3D(this.original);
        transform3D4.setTranslation(new Vector3d());
        transform3D3.mul(transform3D4);
        Vector3d vector3d3 = new Vector3d();
        this.original.get(vector3d3);
        vector3d3.add((Tuple3d)vector3d2);
        vector3d3.add((Tuple3d)vector3d);
        transform3D3.setTranslation(vector3d3);
        this.group.set(transform3D3);
    }

    public synchronized void processStimulus(Enumeration enumeration) {
        this.sensor.getRead(this.transform);
        this.tg.setTransform(this.transform);
        this.processButtonSensor();
        this.processGroup();
        this.wakeupOn((WakeupCondition)this.conditions);
    }

    public void setToolManager(ToolManagerInterface toolManagerInterface) {
        this.tmi = toolManagerInterface;
        this.setup();
    }

    protected void setup() {
        String string;
        String string2;
        this.bg = this.tmi.getBranchGroup();
        this.canvas = this.tmi.getCanvas();
        PortfolioProperties portfolioProperties = PortfolioProperties.instance();
        String string3 = portfolioProperties.getProperty("PickTool.Channel");
        if (string3 != null) {
            this.sensor = this.tmi.getCanvas().getView().getPhysicalEnvironment().getSensor(Integer.parseInt(string3));
            this.tmi.getBranchGroup().addChild((Node)this);
            string2 = portfolioProperties.getProperty("PickTool.Cursor");
            string = null;
            if (string2 != null) {
                ModelLoader modelLoader = new ModelLoader();
                try {
                    URL uRL = new URL(string2);
                    Scene scene = modelLoader.load(uRL);
                    string = scene.getSceneGroup();
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
            this.addCursor((BranchGroup)string);
        } else {
            System.out.println("There is no Device at " + string3);
        }
        string2 = portfolioProperties.getProperty("PickTool.Button.Channel");
        if (string2 == null) {
            string2 = string3;
        }
        if (string2 != null) {
            this.buttonsensor = this.tmi.getCanvas().getView().getPhysicalEnvironment().getSensor(Integer.parseInt(string2));
            this.buttons = new int[this.buttonsensor.getSensorButtonCount()];
        }
        if ((string = portfolioProperties.getProperty("PickTool.Sticky")) != null) {
            this.sticky = string.equalsIgnoreCase("true");
        }
    }
}

