/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.ui.tools;

import java.util.Enumeration;
import java.util.EventObject;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import ncsa.devices.Fake2DInputDevice;
import ncsa.j3d.PickableTransformGroup;
import ncsa.j3d.ui.PortfolioProperties;
import ncsa.j3d.ui.tools.ToolInterface;
import ncsa.j3d.ui.tools.ToolManagerInterface;

public class MouseTool
extends Behavior
implements ToolInterface {
    protected BranchGroup bg;
    protected ToolManagerInterface tmi;
    protected Canvas3D canvas;
    protected int[] buttons;
    protected Vector3f vector;
    protected PickableTransformGroup pg = null;
    protected Point2f point;
    protected boolean mode = true;
    protected boolean lmv = false;
    protected Vector3d offset;
    boolean CUMULATIVE_ROTATE = false;
    protected float TRANSLATION = 0.05f;
    protected double ROTATION = Math.PI / 360;
    protected double scale = 0.01;
    protected Fake2DInputDevice input = null;
    protected int TRANS = 0;
    protected int ROT = 1;
    protected int MODE = 2;
    WakeupOnElapsedFrames conditions = new WakeupOnElapsedFrames(0);
    float line_x;
    float line_y;
    float line_z;

    public MouseTool() {
        this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 3.4028234663852886E38));
    }

    protected void buttonUp() {
        this.point = null;
        this.pg = null;
    }

    protected PickRay construct_pickray() {
        Transform3D transform3D = new Transform3D();
        Vector3d vector3d = new Vector3d(0.0, 0.0, -1.0);
        transform3D.transform(vector3d);
        vector3d.normalize();
        Vector3d vector3d2 = new Vector3d();
        transform3D.get(vector3d2);
        Point3d point3d = new Point3d((Tuple3d)vector3d2);
        return new PickRay(point3d, vector3d);
    }

    public String describe() {
        return "Mouse Tool";
    }

    public String describeFunctionality() {
        return "no functionality";
    }

    protected void drag(PickRay pickRay, boolean bl, Tuple3d tuple3d) {
        Point3d point3d = new Point3d();
        Vector3d vector3d = new Vector3d();
        pickRay.get(point3d, vector3d);
        float f = (float)point3d.x;
        float f2 = (float)point3d.y;
        float f3 = (float)point3d.z;
        float f4 = (float)vector3d.x;
        float f5 = (float)vector3d.y;
        float f6 = (float)vector3d.z;
        if (bl) {
            this.line_x = f4;
            this.line_y = f5;
            this.line_z = f6;
        }
        double d = (tuple3d.x - (double)f) * (double)this.line_x + (tuple3d.y - (double)f2) * (double)this.line_y + (tuple3d.z - (double)f3) * (double)this.line_z;
        float f7 = f4 * this.line_x + f5 * this.line_y + f6 * this.line_z;
        if ((double)f7 == 0.0) {
            return;
        }
        tuple3d.x = (double)f + (d /= (double)f7) * (double)f4;
        tuple3d.y = (double)f2 + d * (double)f5;
        tuple3d.z = (double)f3 + d * (double)f6;
    }

    protected void drag_depth(double d, Tuple3d tuple3d) {
        tuple3d.x += d * (double)this.line_x;
        tuple3d.y += d * (double)this.line_y;
        tuple3d.z += d * (double)this.line_z;
    }

    protected PickRay findRay(int n, int n2, TransformGroup transformGroup) {
        Transform3D transform3D;
        Point3d point3d = new Point3d();
        this.canvas.getPixelLocationInImagePlate(n, n2, point3d);
        Point3d point3d2 = new Point3d();
        this.canvas.getCenterEyeInImagePlate(point3d2);
        Transform3D transform3D2 = new Transform3D();
        this.canvas.getImagePlateToVworld(transform3D2);
        transform3D2.transform(point3d);
        transform3D2.transform(point3d2);
        if (transformGroup != null) {
            transform3D = new Transform3D();
            transformGroup.getTransform(transform3D);
            transform3D.invert();
            transform3D.transform(point3d);
            transform3D.transform(point3d2);
        }
        transform3D = new Vector3d(point3d.x - point3d2.x, point3d.y - point3d2.y, point3d.z - point3d2.z);
        transform3D.normalize();
        PickRay pickRay = new PickRay(point3d2, (Vector3d)transform3D);
        return pickRay;
    }

    protected void firstButton(int n, int n2) {
        if (this.mode) {
            Vector3d vector3d = this.pg.get();
            PickRay pickRay = this.findRay(n, n2, null);
            this.drag(pickRay, false, (Tuple3d)vector3d);
            vector3d.add((Tuple3d)this.offset);
            this.pg.set(vector3d);
        } else {
            this.pg.rotY((double)((float)n - this.point.x) * this.ROTATION);
            this.pg.rotX((double)((float)n2 - this.point.y) * this.ROTATION);
            if (!this.CUMULATIVE_ROTATE) {
                this.point = new Point2f((float)n, (float)n2);
            }
        }
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.conditions);
    }

    public boolean notify(EventObject eventObject) {
        return false;
    }

    protected PickableTransformGroup pick(PickRay pickRay) {
        SceneGraphPath[] sceneGraphPathArray = this.bg.pickAll((PickShape)pickRay);
        if (sceneGraphPathArray == null) {
            return null;
        }
        int n = 0;
        while (n < sceneGraphPathArray.length) {
            int n2 = 0;
            while (n2 < sceneGraphPathArray[n].nodeCount()) {
                Node node = sceneGraphPathArray[n].getNode(n2);
                if (node instanceof PickableTransformGroup) {
                    return (PickableTransformGroup)node;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public void processStimulus(Enumeration enumeration) {
        if (this.input == null) {
            return;
        }
        this.vector = this.input.getVector3f();
        this.buttons = this.input.getButtons();
        if (!this.lmv && this.buttons[this.MODE] != 0) {
            this.mode ^= true;
        }
        boolean bl = this.lmv = this.buttons[this.MODE] != 0;
        if (this.pg == null && (this.buttons[this.TRANS] != 0 || this.buttons[this.ROT] != 0)) {
            this.select((int)this.vector.x, (int)this.vector.y);
        }
        if (this.pg != null) {
            if (this.buttons[this.TRANS] != 0) {
                this.firstButton((int)this.vector.x, (int)this.vector.y);
            }
            if (this.buttons[this.ROT] != 0) {
                this.secondButton((int)this.vector.x, (int)this.vector.y);
            }
        }
        if (this.buttons[this.TRANS] == 0 && this.buttons[this.ROT] == 0) {
            this.buttonUp();
        }
        this.wakeupOn((WakeupCondition)this.conditions);
    }

    protected void secondButton(int n, int n2) {
        if (this.mode) {
            Vector3d vector3d = this.pg.get();
            this.drag_depth((this.point.y - (float)n2) * this.TRANSLATION, (Tuple3d)vector3d);
            this.pg.set(vector3d);
            this.point = new Point2f((float)n, (float)n2);
        } else {
            this.pg.rotZ((double)((float)n - this.point.x) * this.ROTATION);
            if (!this.CUMULATIVE_ROTATE) {
                this.point = new Point2f((float)n, (float)n2);
            }
        }
    }

    protected void select(int n, int n2) {
        this.pg = PickableTransformGroup.selectNode(this.canvas, this.bg, n, n2);
        if (this.pg != null) {
            this.offset = this.pg.get();
            PickRay pickRay = this.findRay(n, n2, null);
            this.drag(pickRay, true, (Tuple3d)this.offset);
            this.offset.sub((Tuple3d)this.pg.get(), (Tuple3d)this.offset);
        }
        this.point = new Point2f((float)n, (float)n2);
    }

    public void setToolManager(ToolManagerInterface toolManagerInterface) {
        this.tmi = toolManagerInterface;
        this.setup();
    }

    protected void setup() {
        this.bg = this.tmi.getBranchGroup();
        this.canvas = this.tmi.getCanvas();
        PortfolioProperties portfolioProperties = PortfolioProperties.instance();
        Object object = portfolioProperties.getObject("MouseTool.Input");
        if (object == null) {
            System.out.println("MouseTool: NOT PROPERLY CONSTRUCTED.");
            System.out.println("Please define MouseTool.Input in ");
            System.out.println("portfolio.properties file.");
            return;
        }
        if (object instanceof Fake2DInputDevice) {
            this.input = (Fake2DInputDevice)object;
        } else {
            System.out.println(String.valueOf(String.valueOf(this.input)) + " needs to implement" + " Fake2DInputDevice.");
        }
        this.bg.addChild((Node)this);
    }
}

