/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.ui.tools;

import java.util.Enumeration;
import java.util.EventObject;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.InputDevice;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Point3d;
import ncsa.devices.AdjustableInterface;
import ncsa.devices.AdjustmentDialog;
import ncsa.devices.AdjustmentInterface;
import ncsa.j3d.ui.PortfolioProperties;
import ncsa.j3d.ui.tools.ToolInterface;
import ncsa.j3d.ui.tools.ToolManagerInterface;

public class AdjustmentTool
extends Behavior
implements ToolInterface {
    AdjustmentDialog dialog;
    protected WakeupOnElapsedFrames conditions = new WakeupOnElapsedFrames(0);

    public AdjustmentTool() {
        this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 3.4028234663852886E38));
    }

    public String describe() {
        return "AdjustmentTool";
    }

    public String describeFunctionality() {
        return "Adjusts Input Device";
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.conditions);
    }

    public boolean notify(EventObject eventObject) {
        return false;
    }

    public void processStimulus(Enumeration enumeration) {
    }

    public void setToolManager(ToolManagerInterface toolManagerInterface) {
        Canvas3D canvas3D = toolManagerInterface.getCanvas();
        AdjustmentInterface adjustmentInterface = null;
        int n = 0;
        String string = PortfolioProperties.instance().getProperty("AdjustmentTool.Channel");
        if (string != null) {
            InputDevice inputDevice = canvas3D.getView().getPhysicalEnvironment().getSensor(Integer.parseInt(string)).getDevice();
            if (inputDevice instanceof AdjustableInterface) {
                adjustmentInterface = ((AdjustableInterface)inputDevice).getAdjustmentInterface();
            } else {
                System.out.println("AdjustmentTool: " + inputDevice + " does not implement ncsa.devices.AdjustableInterface.");
            }
        }
        if ((string = PortfolioProperties.instance().getProperty("AdjustmentTool.Sensor")) != null) {
            n = Integer.parseInt(string);
        }
        if (adjustmentInterface != null) {
            this.dialog = new AdjustmentDialog(adjustmentInterface, n);
        }
    }
}

