/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.ui.record;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;
import javax.vecmath.Point3f;
import ncsa.j3d.ui.PortfolioProperties;
import ncsa.j3d.ui.record.RendezvousInterface;

public class RecordableCanvas3D
extends Canvas3D
implements RendezvousInterface {
    Vector images = new Vector();
    BufferedImage image;
    Raster raster;
    GraphicsContext3D gc = this.getGraphicsContext3D();
    int frame = 0;
    int height = 0;
    int width = 0;
    boolean recording = false;
    boolean captureInPostRender = false;
    boolean bRepaint = true;
    boolean takeSnapShot = false;
    String prefix = "image";
    String dir = "frames";
    String file_separator = null;
    String filename = "image.jpg";

    public RecordableCanvas3D(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        Properties properties = System.getProperties();
        this.file_separator = properties.getProperty("file.separator");
        PortfolioProperties portfolioProperties = PortfolioProperties.instance();
        String string = portfolioProperties.getProperty("RecordableCanvas3D.repaint");
        if (string == null) {
            return;
        }
        if (string.equals("true")) {
            this.bRepaint = true;
        } else if (string.equals("false")) {
            this.bRepaint = false;
        }
    }

    public RecordableCanvas3D(GraphicsConfiguration graphicsConfiguration, boolean bl) {
        this(graphicsConfiguration);
        this.bRepaint = bl;
    }

    public synchronized void Notify() {
        this.notify();
    }

    public void allocImage() {
        if (this.image != null && this.raster != null && this.width == ((Component)((Object)this)).getWidth() && this.height == ((Component)((Object)this)).getHeight()) {
            return;
        }
        this.image = new BufferedImage(((Component)((Object)this)).getWidth(), ((Component)((Object)this)).getHeight(), 2);
        ImageComponent2D imageComponent2D = new ImageComponent2D(1, this.image);
        this.raster = new Raster(new Point3f(0.0f, 0.0f, 0.0f), 1, 0, 0, this.image.getWidth(), this.image.getHeight(), imageComponent2D, null);
    }

    public void captureInPostRender(boolean bl) {
        this.captureInPostRender = bl;
    }

    private void doCapture() {
        this.allocImage();
        this.gc.readRaster(this.raster);
        if (this.recording) {
            this.writeImage(String.valueOf(this.getDumpPrefix(this.frame)) + this.frame + ".jpg", this.raster.getImage().getImage());
        } else {
            this.writeImage(this.filename, this.raster.getImage().getImage());
        }
        this.Notify();
    }

    public String getDirectoryName() {
        return this.dir;
    }

    private String getDumpPrefix(int n) {
        String string = null;
        if (n < 10) {
            string = new String("000");
        } else if (n < 100) {
            string = new String("00");
        } else if (n < 1000) {
            string = new String("0");
        }
        if (string == null) {
            return String.valueOf(this.dir) + this.file_separator + this.prefix;
        }
        return String.valueOf(this.dir) + this.file_separator + this.prefix + string;
    }

    public String getFilePrefix() {
        return this.prefix;
    }

    public void postRender() {
        super.postRender();
        if (this.captureInPostRender && this.recording) {
            this.doCapture();
        }
    }

    public void postSwap() {
        super.postSwap();
        if (!this.captureInPostRender && this.recording) {
            this.doCapture();
        } else if (this.takeSnapShot) {
            this.takeSnapShot = false;
            this.doCapture();
        }
    }

    public synchronized void rendezvous() {
        block2: {
            if (!this.recording) break block2;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setDirectoryName(String string) {
        this.dir = string;
    }

    public void setFilePrefix(String string) {
        this.prefix = string;
    }

    public void startRecording() {
        this.recording = true;
        if (this.bRepaint) {
            this.takeSnapShot = true;
            ((Component)((Object)this)).repaint();
        } else {
            this.doCapture();
        }
    }

    public void stopRecording() {
        this.recording = false;
        this.Notify();
        System.out.println("Wrote " + this.frame + " frames");
    }

    public void takeSnapshot() {
        if (this.bRepaint) {
            ((Component)((Object)this)).repaint();
        } else {
            this.doCapture();
        }
    }

    public void takeSnapshot(String string) {
        this.filename = string;
        if (this.bRepaint) {
            this.takeSnapShot = true;
            ((Component)((Object)this)).repaint();
        } else {
            this.doCapture();
        }
        string = "image.jpg";
    }

    public void writeImage(String string, BufferedImage bufferedImage) {
        System.out.println("Writing " + string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            jPEGEncodeParam.setQuality(1.0f, true);
            jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
            jPEGImageEncoder.encode(bufferedImage);
            bufferedOutputStream.flush();
            fileOutputStream.close();
            ++this.frame;
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

