/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.ui.events;

import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalEnvironment;
import ncsa.devices.NCSAInputDevice;
import ncsa.j3d.ui.PortfolioProperties;
import ncsa.j3d.ui.events.PortfolioEvent;
import ncsa.j3d.ui.events.PortfolioEventReceiver;
import ncsa.j3d.ui.tools.ToolManager;

public class EventManager
implements PortfolioEventReceiver {
    Vector behaviors = new Vector();
    Vector eventSources = new Vector();
    Vector eventReceivers = new Vector();
    BranchGroup branchGroup;
    BranchGroup eventGroup = new BranchGroup();
    boolean connect = false;
    private static EventManager instance = null;

    protected EventManager() {
        this.eventGroup.setCapability(17);
    }

    public void addBehavior(Behavior behavior) {
        this.disconnect();
        this.insertBehavior(behavior);
        this.connect();
    }

    public void addEvent(PortfolioEvent portfolioEvent) {
        if (portfolioEvent instanceof Behavior) {
            this.addBehavior((Behavior)portfolioEvent);
        } else {
            this.addEventSource(portfolioEvent);
        }
    }

    public void addEventReceiver(PortfolioEventReceiver portfolioEventReceiver) {
        this.eventReceivers.addElement(portfolioEventReceiver);
    }

    public void addEventSource(Object object) {
        this.eventSources.addElement(object);
    }

    protected void configurePortfolioDevices(InputDevice inputDevice, int n) {
        PortfolioProperties portfolioProperties = PortfolioProperties.instance();
        String string = portfolioProperties.getProperty("InputDevice" + n + ".Name");
        if (!(inputDevice instanceof NCSAInputDevice) && string != null) {
            System.out.println("Cannot set name for device " + n + " because it does not implement ncsa.devices.NCSAInputDevice.");
            return;
        }
        if (inputDevice instanceof NCSAInputDevice) {
            NCSAInputDevice nCSAInputDevice = (NCSAInputDevice)inputDevice;
            nCSAInputDevice.initializePortfolioDevice(string);
        }
    }

    protected void connect() {
        if (this.branchGroup != null) {
            this.branchGroup.addChild((Node)this.eventGroup);
            this.connect = true;
        }
    }

    protected void disconnect() {
        if (this.connect) {
            this.eventGroup.detach();
        }
        this.connect = false;
    }

    protected void insertBehavior(Behavior behavior) {
        this.eventGroup.addChild((Node)behavior);
        this.behaviors.addElement(behavior);
    }

    public static EventManager instance() {
        if (instance == null) {
            instance = new EventManager();
        }
        return instance;
    }

    public void loadInputDevices() {
        Object[] objectArray = PortfolioProperties.instance().getObjects("InputDevice");
        PhysicalEnvironment physicalEnvironment = null;
        if (objectArray.length > 0) {
            Canvas3D canvas3D = ToolManager.instance().getCanvas();
            physicalEnvironment = canvas3D.getView().getPhysicalEnvironment();
        }
        int n = 0;
        while (n < objectArray.length) {
            InputDevice inputDevice = (InputDevice)objectArray[n];
            inputDevice.initialize();
            this.configurePortfolioDevices(inputDevice, n);
            this.setSensors(physicalEnvironment, inputDevice, n);
            physicalEnvironment.addInputDevice(inputDevice);
            ++n;
        }
    }

    public void loadInputSources() {
        Object[] objectArray = PortfolioProperties.instance().getObjects("InputSource");
        int n = 0;
        while (n < objectArray.length) {
            PortfolioEvent portfolioEvent = (PortfolioEvent)objectArray[n];
            portfolioEvent.setReceiver(this);
            this.addEvent(portfolioEvent);
            ++n;
        }
    }

    public boolean notify(EventObject eventObject) {
        Enumeration enumeration = this.eventReceivers.elements();
        while (enumeration.hasMoreElements()) {
            ((PortfolioEventReceiver)enumeration.nextElement()).notify(eventObject);
        }
        return true;
    }

    public void removeBehavior(Behavior behavior) {
        System.out.println("EventManager.removeBehavior needs to be implemented");
    }

    public void setBranchGroup(BranchGroup branchGroup) {
        if (this.branchGroup == null) {
            this.branchGroup = branchGroup;
            this.connect();
        }
    }

    public void setHeadIndex() {
        String string = PortfolioProperties.instance().getProperty("HeadIndex");
        if (string != null) {
            ToolManager.instance().getCanvas().getView().getPhysicalEnvironment().setHeadIndex(Integer.parseInt(string));
            ToolManager.instance().getCanvas().getView().setTrackingEnable(true);
            ToolManager.instance().getCanvas().getView().setUserHeadToVworldEnable(true);
            System.out.println(ToolManager.instance().getCanvas().getView().getPhysicalEnvironment().getSensor(Integer.parseInt(string)));
        }
    }

    protected void setSensors(PhysicalEnvironment physicalEnvironment, InputDevice inputDevice, int n) {
        String string;
        int n2 = 0;
        while ((string = PortfolioProperties.instance().getProperty("InputDevice" + n + ".Channel" + n2)) != null) {
            if (inputDevice.getSensorCount() <= n2) {
                System.out.println("InputDevice" + n + " can only support " + inputDevice.getSensorCount() + " Channel(s).");
                System.out.println("All subsequent channel definitions have been ignored.");
                return;
            }
            physicalEnvironment.setSensor(Integer.parseInt(string), inputDevice.getSensor(n2++));
        }
    }
}

