/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.ui;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class PortfolioProperties
extends Properties {
    protected static boolean printedError = false;
    protected static PortfolioProperties instance = null;

    protected PortfolioProperties() {
        try {
            this.load(new FileInputStream("portfolio.properties"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!printedError) {
                System.out.println("No portfolio.properties file");
                printedError = true;
            }
            PortfolioProperties.makeDefault(this);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public Enumeration getEnumeration(String string) {
        Vector vector = this.getVector(string);
        return vector.elements();
    }

    public Object getObject(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return null;
        }
        try {
            return Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(String.valueOf(string) + " not found.");
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            System.out.println(instantiationException);
        }
        return null;
    }

    public Object[] getObjects(String string) {
        Vector vector = this.getVector(string);
        Object[] objectArray = new Object[vector.size()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = vector.elementAt(n);
            ++n;
        }
        return objectArray;
    }

    public Vector getVector(String string) {
        String string2;
        Vector vector = new Vector();
        int n = 0;
        while ((string2 = this.getProperty(String.valueOf(string) + n++)) != null) {
            try {
                vector.addElement(Class.forName(string2).newInstance());
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("PortfolioProperties could not find " + string2);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                System.out.println(instantiationException);
            }
        }
        return vector;
    }

    public static PortfolioProperties instance() {
        if (instance == null) {
            instance = new PortfolioProperties();
        }
        return instance;
    }

    public static void main(String[] stringArray) {
        PortfolioProperties portfolioProperties = new PortfolioProperties();
        PortfolioProperties.makeDefault(portfolioProperties);
        PortfolioProperties.save(portfolioProperties);
    }

    public static void makeDefault(Properties properties) {
        ((Hashtable)properties).put("InputSource0", "ncsa.j3d.ui.events.KeyPress");
        ((Hashtable)properties).put("InputSource1", "ncsa.j3d.ui.events.KeyRelease");
        ((Hashtable)properties).put("InputSource2", "ncsa.j3d.ui.events.MouseDown");
        ((Hashtable)properties).put("InputSource3", "ncsa.j3d.ui.events.MouseUp");
        ((Hashtable)properties).put("InputSource4", "ncsa.j3d.ui.events.MouseDrag");
        ((Hashtable)properties).put("ActiveTool", "ncsa.j3d.ui.tools.PickTool");
        ((Hashtable)properties).put("InactiveTool0", "ncsa.j3d.ui.tools.ViewTool");
    }

    public static void reload() {
        instance = null;
    }

    public static void save(Properties properties) {
        try {
            properties.store(new FileOutputStream("portfolio.properties"), "NCSA Portfolio configuration file");
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }
}

