/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.wavefront;

import com.sun.j3d.loaders.Scene;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Group;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import ncsa.j3d.loaders.wavefront.AppearanceManager;
import ncsa.j3d.loaders.wavefront.AppearanceReader;
import ncsa.j3d.loaders.wavefront.Face;
import ncsa.j3d.loaders.wavefront.GenReader;
import ncsa.j3d.loaders.wavefront.SceneManager;
import ncsa.j3d.loaders.wavefront.VertexManager;
import ncsa.j3d.loaders.wavefront.VertexNormalManager;

public class WavefrontReader
extends GenReader {
    VertexManager vm = new VertexManager();
    VertexNormalManager vnm = new VertexNormalManager();
    SceneManager groupman;
    AppearanceManager am;
    Group group;
    String groupname = new String("default");
    String basePath = null;
    String baseUrl = null;
    Vector v;

    public WavefrontReader(Reader reader, String string, String string2) throws Exception {
        super(reader);
        this.basePath = string;
        this.baseUrl = string2;
        this.am = new AppearanceManager();
        this.groupman = new SceneManager(this.vm, this.vnm, this.am);
    }

    public Scene consume() {
        Scene scene = super.consume();
        Scene scene2 = this.groupman.getScene();
        this.vm = null;
        this.vnm = null;
        this.groupman = null;
        this.am = null;
        return scene2;
    }

    AppearanceManager createAppearanceManager(String string) {
        block7: {
            try {
                AppearanceReader appearanceReader = null;
                if (this.basePath != null) {
                    appearanceReader = new AppearanceReader(String.valueOf(this.basePath) + string);
                    break block7;
                }
                try {
                    appearanceReader = new AppearanceReader(new URL(String.valueOf(this.baseUrl) + string));
                }
                catch (Exception exception) {
                    this.am = new AppearanceManager();
                    return this.am;
                }
                this.am = appearanceReader.create();
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    AppearanceReader appearanceReader = null;
                    appearanceReader = new AppearanceReader(string);
                    this.am = appearanceReader.create();
                }
                catch (FileNotFoundException fileNotFoundException2) {
                    System.out.println("Material file not found");
                    this.am = new AppearanceManager();
                }
            }
        }
        return this.am;
    }

    protected void face(int n) {
        this.v.addElement(new Integer(n - 1));
    }

    protected void faceEnd() {
        int[] nArray = new int[this.v.size()];
        int n = 0;
        Enumeration enumeration = this.v.elements();
        while (enumeration.hasMoreElements()) {
            nArray[n++] = (Integer)enumeration.nextElement();
        }
        this.groupman.addFace(new Face(nArray, null), this.groupname);
    }

    protected void faceStart() {
        this.v = new Vector();
    }

    protected void group(String string) {
        if (string.equals("default") || string.equals("shape") || string.equals("all") || string.equals("link") || string.equals("copy")) {
            return;
        }
        this.groupname = string;
    }

    protected void groupEnd() {
    }

    protected void groupStart() {
        this.groupname = new String("default");
    }

    void handleMtllib() {
        int n = this.charType(46);
        int n2 = this.charType(47);
        int n3 = this.charType(92);
        this.wordChars(46, 46);
        this.wordChars(47, 47);
        this.wordChars(92, 92);
        if (this.nextToken() == -101) {
            AppearanceManager appearanceManager = this.createAppearanceManager(this.sval);
            this.groupman.setAppearanceManager(appearanceManager);
        }
        this.setType(46, n);
        this.setType(47, n2);
        this.setType(92, n3);
    }

    protected void material(String string) {
        this.am.use(string);
    }

    public void setAppearanceToGroupName() {
        this.groupman.setAppearanceToGroupName();
    }

    protected void vertex(Point3d point3d) {
        if (point3d != null) {
            this.vm.add(point3d);
        }
    }

    protected void vertexNormal(Vector3d vector3d) {
        if (vector3d != null) {
            this.vnm.add(new Point3d((Tuple3d)vector3d));
        }
    }
}

