/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.wavefront;

import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import ncsa.j3d.loaders.wavefront.AppearanceManager;
import ncsa.j3d.loaders.wavefront.Face;
import ncsa.j3d.loaders.wavefront.FaceManager;
import ncsa.j3d.loaders.wavefront.VertexManager;
import ncsa.j3d.loaders.wavefront.VertexNormalManager;

public class SceneManager
extends Hashtable {
    VertexManager vm;
    VertexNormalManager vnm;
    AppearanceManager am;
    boolean appearanceToGroupName = false;

    public SceneManager(VertexManager vertexManager, VertexNormalManager vertexNormalManager, AppearanceManager appearanceManager) {
        this.vm = vertexManager;
        this.vnm = vertexNormalManager;
        this.am = appearanceManager;
    }

    public void addFace(Face face, String string) {
        FaceManager faceManager;
        if (this.containsKey(string)) {
            faceManager = (FaceManager)this.get(string);
        } else {
            Appearance appearance = this.appearanceToGroupName ? this.am.get(string) : this.am.get();
            faceManager = new FaceManager(this.vm, this.vnm, appearance);
            this.put(string, faceManager);
        }
        faceManager.addFace(face);
    }

    public void changeColor(String string, String string2) {
        if (this.containsKey(string)) {
            FaceManager faceManager = (FaceManager)this.get(string);
            faceManager.changeAppearance(this.am.get(string2));
        }
    }

    public Scene getScene() {
        SceneBase sceneBase = new SceneBase();
        BranchGroup branchGroup = new BranchGroup();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            FaceManager faceManager = (FaceManager)enumeration.nextElement();
            branchGroup.addChild(faceManager.getShape());
        }
        if (branchGroup != null) {
            sceneBase.setSceneGroup(branchGroup);
        }
        return sceneBase;
    }

    public void setAppearanceManager(AppearanceManager appearanceManager) {
        this.am = appearanceManager;
    }

    public void setAppearanceToGroupName() {
        this.appearanceToGroupName = true;
    }
}

